<?php
   
   /*
    * @script	A class to convert, parse and create CSS files with PHP
    * @author	Fabian Tomischka
    * @date		17.09.2012
    * 
    * @functions	Parse 			-	Outputs a parsed PHP array including the CSS elements
    * 				ParseIntoMain	-	Adds the included CSS into the global array to combine it with the Add() function
    * 				ParseCSS		-	Main class: Converting the pure .css syntax into an array
    * 				Add				-	Adds a parameter into the global array
	*				Optimize		-	Removes whitespaces, tabs, and other characters and optimizes the CSS to reduce file size
    * 				Clean			-	Nearly same as Get() function, just skips some other functions
    * 				Get				-	Outputs the CSS in the global array with the specified output
    * 				GetPureCSS		-	Convert an array into a pure CSS file syntax
    */
    
    
class astiCSS
{
	
	private $css = array();
	
				
	/*
	 * @function	Parse
	 * @description	Creates an array including all the elements in the file
	 * @params		$css	-	The file which will be included
	 * @return		array($final_css)
	 */
	 
	public function Parse ($css)
	{
   		return $this->parseCSS($css);
	}

	
	/*
	 * @function	ParseIntoMain
	 * @description	Adds the values of the parsed CSS file into the main array
	 * @params		$css	-	The file which will be included
	 * @return		bool(true)
	 */
	 
	public function ParseIntoMain ($css)
	{
		$cssParsed = $this->parseCSS($css);
		
		foreach($cssParsed as $cssElement)
			$this->css[$cssElement['selector']] = $cssElement;
	}
	
			
	/*
	 * @function	ParseCSS
	 * @description	Main function parsing the CSS from the source into an array
	 * @params		$css	-	The file which will be included
	 * @return		array($final_css)
	 */
	 
	private function ParseCSS ($css)
	{
		$final_css = array();
			
		// If $css is a file, if not returning an empty array
		if(!is_file($css))
			return $final_css;
		
		// Takes the whole CSS-content and removes the whitespaces,tabs, ...
		$css = file_get_contents($css);
		$css = str_replace(array(" ","\r\n","\n","\t"),'',$css);
		
		// Getting all the CSS-tags
		$tags = explode('}',$css);
		
		foreach ($tags as $tag) 
		{
			// Get the name of the selector
			$selector = explode('{', $tag);
			$selector = $selector[0];
			
			// Setting up a new array for the selector
			if(!empty($selector))
				$final_css[$selector] = array('selector' => $selector);
			
			// Get each value
			$values = explode(';',$tag);
			
			// Remove the selector from the first value
			$values[0] = str_replace($selector.'{','',$values[0]);
			
			foreach($values as $value) 
			{
				// Get the value of each value
				$valSplit = explode(':',$value);
				
				// Add last info into array
				if(!empty($valSplit[0]))
					$final_css[$selector]['values'][$valSplit[0]] = $valSplit[1];
			}
		}
		
		return $final_css;		
	}
		
	
	/*
	 * @function	Add
	 * @description	Adds a value to the specified selector
	 * @params		$selector	-	The CSS selector
	 * 				$values		-	All values inside the selector
	 * @return		bool(true)
	 */

	public function Add ($selector = '' , $values = array())
	{
		// Set the name of the selector which will be edited
		$this->css[$selector]['selector'] = $selector;
		
		// Loop through all given values
		foreach($values as $key => $value)
		{
			// Add them
			$this->css[$selector]['values'][$key] = $value;
		}
		
		return true;
	}



	/*
	 * @function	Optimize
	 * @description	Outputs the CSS code without whitespaces, tabs, ..
	 * @params		$css	-	Array or pure CSS code
	 * @return		CSS Code
	 */
	
	public function Optimize ($css)
	{
		// If CSS is a file, convert into array
		if(is_file($css))
			$css = $this->ParseCSS($css);
		
		return $this->GetPureCSS($css,1);
	}
	
	
	/*
	 * @function	Clean
	 * @description	Outputs a cleaned CSS code
	 * @params		$css	-	Array or pure CSS code
	 * @return		code($clean)
	 */
	
	public function Clean ($css)
	{
		// If CSS is a file, convert into array
		if(is_file($css))
			$css = $this->ParseCSS($css);
		
		return $this->GetPureCSS($css);
	}
		
			
	/*
	 * @function	Get
	 * @description	Outputs the CSS code in the specified format
	 * @params		$type	-	The output type which will be sent back
	 * @return		array($css),json($css),code($css)
	 */
	
	public function Get ($type = 'array')
	{
		if($type == 'json')
			return json_encode($this->css);
		
		if($type == 'code')
			return $this->GetPureCSS($this->css);
		
		return $this->css;
	}
		
		
	/*
	 * @function	GetPureCSS
	 * @description	Converts the given array into CSS-Code
	 * @params		$css	-	The array of CSS elements
	 * 				$type	-	0 = Normal code, 1 = Optimized code
	 * @return		code($css)
	 */
	 	
	private function GetPureCSS ($css = array(),$type = 0)
	{
		$cssBuilder = '';
		
		// Running through all the given CSS elements
		foreach($css as $element)
		{
			// Adding the selector
			if($type == 0)
				$cssBuilder .= $element['selector']." {\n";
			else
				$cssBuilder .= $element['selector'].'{';
			
			// Getting all values
			foreach($element['values'] as $key => $value)
			{
				// Setting + formating them
				if($type == 0)
					$cssBuilder .= "\t $key: $value; \n";
				else
					$cssBuilder .= $key.':'.$value.';';
			}
			
			// Finish tag
			if($type == 0)
				$cssBuilder .= "}\n\n";
			else
				$cssBuilder .= '}';
		}
		
		return $cssBuilder;
	}
	
}

?>