﻿using System;
using System.Collections;

namespace GameServer
{
    class SP_ISC_LOGIN_PACKET : cServerPacketHandler
    {
        public SP_ISC_LOGIN_PACKET()
        {
            newPacket(1199);
            AddBlock("1"); // 0 = GameServer | 1 = GameServer
            AddBlock(Program.ConfigClass.ISC_Pw); // Auth PW
            AddBlock(Program.ConfigClass.Server_ID);
            AddBlock(Program.ConfigClass.Server_IP);
            AddBlock(Program.ConfigClass.Server_Port);
            AddBlock(Program.ConfigClass.Server_Name);
            AddBlock(77);
        }
    }

    class SP_ISC_PLAYERUPDATE : cServerPacketHandler
    {
        public SP_ISC_PLAYERUPDATE()
        {
            newPacket(5555);
            AddBlock(Program.ConfigClass.Server_ID);
            AddBlock(Program.ConfigClass.CurrentPlayer);
        }
    }

    class SP_WELCOME_PACKET : cServerPacketHandler
    {
        public SP_WELCOME_PACKET()
        {
            newPacket(24832);
            AddBlock(1);
            AddBlock(DateTime.Now.ToString(@"ss\/mm\/HH\/dd\/MM\/110") + "/3/356/0");
          
        }
    }

    class SP_CHARACTER_INFO : cServerPacketHandler
    {
        public SP_CHARACTER_INFO(cWRClient Client)
        {
            newPacket(25088);
            AddBlock(1);
            AddBlock("Gameserver" + Program.ConfigClass.Server_ID.ToString());
            AddBlock(0);
            AddBlock(Client.getUserID());
            AddBlock(1);
            AddBlock(Client.getNickname());
            //Clan
            AddBlock(-1);
            AddBlock(-1);
            AddBlock(-1);
            AddBlock(-1);
            //END Clan
            AddBlock(Client.getPremium());
            AddBlock(0);
            AddBlock(0);
            AddBlock(Client.getLevel());
            AddBlock(Client.getExp());
            AddBlock(49390); // ??
            AddBlock(0);
            AddBlock(Client.getDinar());
            AddBlock(Client.getKills());
            AddBlock(Client.getDeaths());
            AddBlock(0);
            AddBlock(0);
            AddBlock(0);
            AddBlock(0);
            AddBlock(0);
            AddBlock("F,F,F,F");

            string WeaponE = "";
            string WeaponM = "";
            string WeaponS = "";
            string WeaponA = "";
            string WeaponH = "";

          
            foreach (cWRClient.tItem pItem in Client.getItems())
            {

                switch (pItem.SlotEngineer)
                {
                    case 0: Client.slot1E = pItem.itemCode; break;
                    case 1: Client.slot2E = pItem.itemCode; break;
                    case 2: Client.slot3E = pItem.itemCode; break;
                    case 3: Client.slot4E = pItem.itemCode; break;
                    case 4: Client.slot5E = pItem.itemCode; break;
                    case 5: Client.slot6E = pItem.itemCode; break; 
                  }
                switch(pItem.SlotMedic)
                {
                    case 0: Client.slot1M = pItem.itemCode; break;
                    case 1: Client.slot2M = pItem.itemCode; break;
                    case 2: Client.slot3M = pItem.itemCode; break;
                    case 3: Client.slot4M = pItem.itemCode; break;
                    case 4: Client.slot5M = pItem.itemCode; break;
                    case 5: Client.slot6M = pItem.itemCode; break;   
                }
                 switch(pItem.SlotSniper)
                {
                    case 0: Client.slot1S = pItem.itemCode; break;
                    case 1: Client.slot2S = pItem.itemCode; break;
                    case 2: Client.slot3S = pItem.itemCode; break;
                    case 3: Client.slot4S = pItem.itemCode; break;
                    case 4: Client.slot5S = pItem.itemCode; break;
                    case 5: Client.slot6S = pItem.itemCode; break; 
                  }
                 switch(pItem.SlotAssault)
                {
                    case 0: Client.slot1A = pItem.itemCode; break;
                    case 1: Client.slot2A = pItem.itemCode; break;
                    case 2: Client.slot3A = pItem.itemCode; break;
                    case 3: Client.slot4A = pItem.itemCode; break;
                    case 4: Client.slot5A = pItem.itemCode; break;
                    case 5: Client.slot6A = pItem.itemCode; break;   
                  }
                 switch(pItem.SlotHeavyTrooper)
                {
                    case 0: Client.slot1H = pItem.itemCode; break;
                    case 1: Client.slot2H = pItem.itemCode; break;
                    case 2: Client.slot3H = pItem.itemCode; break;
                    case 3: Client.slot4H = pItem.itemCode; break;
                    case 4: Client.slot5H = pItem.itemCode; break;
                    case 5: Client.slot6H = pItem.itemCode; break;
                        
                  }

          }

            WeaponE = Client.slot1E + "," + Client.slot2E + "," + Client.slot3E + "," + Client.slot4E + "," + Client.slot5E + ","+Client.slot6E+",^,^";
            WeaponM = Client.slot1M + "," + Client.slot2M + "," + Client.slot3M + "," + Client.slot4M + "," + Client.slot5M + ","+Client.slot6M+",^,^";
            WeaponS = Client.slot1S + "," + Client.slot2S + "," + Client.slot3S + "," + Client.slot4S + "," + Client.slot5S + ","+Client.slot6S+",^,^";
            WeaponA = Client.slot1A + "," + Client.slot2A + "," + Client.slot3A + "," + Client.slot4A + "," + Client.slot5A + ","+Client.slot6A+",^,^";
            WeaponH = Client.slot1H + "," + Client.slot2H + "," + Client.slot3H + "," + Client.slot4H + "," + Client.slot5H + "," + Client.slot6H + ",^,^";

            AddBlock(WeaponE);//scheis noooooobs -.-
            AddBlock(WeaponM);
            AddBlock(WeaponS);
            AddBlock(WeaponA);
            AddBlock(WeaponH);

            string Items = "";
            
            foreach (cWRClient.tItem pItem in Client.getItems())
            {
                Items += pItem.itemCode + "-3-0-" + pItem.expireDate.ToString() + "-0-0-0-0-0-9999-9999,";
            }

            for (int i = 0; i < (31 - Client.getItems().Count); i++)
            {
                Items += "^,";
            }

            Items = Items.Substring(0, Items.Length - 1);
            
            AddBlock(Items); // Inventory (Weapons/PX-Items)
            AddBlock(0);
            AddBlock(0);
        }
    }

    class SP_PREMIUM_LEFT : cServerPacketHandler
    {
        public SP_PREMIUM_LEFT(cWRClient Client)
        {
            newPacket(25600);
            AddBlock(5000);
            AddBlock(0);
            AddBlock(0);
            AddBlock(-1);
            AddBlock(4);
            AddBlock(0);
            AddBlock(0);
            AddBlock(Client.getPremiumLeftTime());
        }
    }

    class SP_CHANGE_CHANNEL : cServerPacketHandler
    {
        public SP_CHANGE_CHANNEL(cWRClient Client)
        {
            newPacket(28673);
            AddBlock(1);
            AddBlock(Client.getChannelID());
        }
    }

    class SP_CHAT : cServerPacketHandler
    {
        public enum ChatType : int
        {
            Notice1 = 1,
            Notice2,
            Lobby_ToChannel,
            Room_ToAll,
            Room_ToTeam,
            Whisper,
            Lobby_ToAll = 8,
            Clan
        }

        public enum ErrorCodes : int
        {
            ErrorUser = 95040
        }

        public SP_CHAT(cWRClient Client, ChatType Type, string Message, long TargetID, string TargetName)
        {
            
            newPacket(29696);
            AddBlock(1);
            AddBlock(Client.getSessionID());
            AddBlock(Client.getNickname());
            AddBlock((int)Type);
            AddBlock(TargetID);
            AddBlock(TargetName);
            AddBlock(Message);
        }

        public SP_CHAT(ErrorCodes ErrCode, params object[] Params )
        {
            newPacket(29696);
            AddBlock((int)ErrCode);
            for (int i = 0; i < Params.Length; i++)
            {
                AddBlock(Params[i]);
            }
        }
    }

    class SP_USER_LIST : cServerPacketHandler
    {
        public SP_USER_LIST(ArrayList PlayerList)
        {
            newPacket(28960);
            AddBlock(PlayerList.Count);

            foreach (cWRClient _Client in PlayerList)
            {
                AddBlock(_Client.getUserID());
                AddBlock(_Client.getNickname());
                AddBlock(_Client.getPremium()); 
                AddBlock(-1); // Clan
                AddBlock(_Client.getLevel());
                AddBlock(_Client.getChannelID());
                if (_Client.getRoom() == null)
                {
                    AddBlock(-1); // -1 = Lobby
                } 
                else
                { 
                    AddBlock(_Client.getRoom().getRoomID());
                }
            }
        }
    }
    
    class SP_CHANGE_WEAPON : cServerPacketHandler
    {
        public SP_CHANGE_WEAPON(int _Class, string Items)
        {
            //1115603592 29970 1 1 DA02,I003,I000,DQ01,^,I006,^,I005
            newPacket(29970);
            AddBlock(1);
            AddBlock(_Class);
            AddBlock(Items);
            


        }
    }
  

    class SP_BUY_WEAPON : cServerPacketHandler
    {
        public SP_BUY_WEAPON(cWRClient Client,int ErrorCode,long Dinar,string Waffenstring)
        {
             
          
            newPacket(30208); 
            AddBlock(ErrorCode);
            AddBlock(1110);
            if(ErrorCode==1){
            AddBlock(-1);
            AddBlock(3);
            AddBlock(4);//nochmal nachschauen :)
            AddBlock(Waffenstring);
            AddBlock(Dinar);
            AddBlock("F,F,F,F");
            
            Program.SQLClass.runSQL("UPDATE ACCOUNT_TBL_DETAIL SET dinar = '" + Dinar + "' WHERE userID = '" + Client.getUserID().ToString() + "'").ToString();
            
             }
            
            
        }
    }

    class SP_CREATE_ROOM : cServerPacketHandler
    {
        public SP_CREATE_ROOM(cWRRoom Room)
        {
            newPacket(29440);
            AddBlock(1); 
            AddBlock(0);
            AddRoomInfo(Room);
        }
    }

    class SP_LEAVE_ROOM : cServerPacketHandler
    {
        public SP_LEAVE_ROOM(cWRClient Client, cWRRoom Room, int oldPlace, int newMaster)
        {
            newPacket(29504);
            AddBlock(1);
            AddBlock(Client.getSessionID());
            AddBlock(oldPlace); // Position in Room
            AddBlock(0); // ?
            AddBlock(newMaster);
            AddBlock(Client.getExp());
            AddBlock(Client.getDinar());
        }
    }
  class SP_ROOMSTATE2 : cServerPacketHandler
    {
      public SP_ROOMSTATE2(cWRRoom WRRoom)
        { 
          
          newPacket(29200);
         
        AddBlock(WRRoom.getRoomID());
        AddBlock(1);
        AddBlock(WRRoom.getRoomID());
        AddBlock(WRRoom.getRoomStatus());
        AddBlock(WRRoom.getRoomStatus());
        AddBlock(WRRoom.getIDOfPlayer(WRRoom.getRoomMaster()));
        AddBlock(WRRoom.getRoomName());
        AddBlock(WRRoom.HasPassword());
        AddBlock(WRRoom.getMaxPlayer());//das haben wir doch alles rausgfunden undjetzt nur noch neues packet anlegen ...^^
        AddBlock(WRRoom.getPlayers().Count);
        AddBlock(WRRoom.getMapID());
         AddBlock(3);
            AddBlock(2);
            AddBlock(0);
            AddBlock(WRRoom.getRoomMode());
            AddBlock(4);
            AddBlock(1);
            AddBlock(0);
            AddBlock(0);//Supermaster ->1
            AddBlock(WRRoom.getRoomType()); //Knife (2 ->Knife only)
            AddBlock(WRRoom.getLevelLimit());
            AddBlock(WRRoom.getPremiumOnly());// ??
            AddBlock(WRRoom.getVoteKick());
            AddBlock(0); // autostart
            AddBlock(46);
            AddBlock(WRRoom.getPing());
            AddBlock(-1);

        }
    }
  class SP_SpawnCount : cServerPacketHandler
  {
      public SP_SpawnCount(cWRClient Client)
      {
          newPacket(30016);
          AddBlock(Client.FuckPacket);
          AddBlock(Client.FuckPacket2);
          AddBlock(0);
          AddBlock(0);
          AddBlock(1);
          AddBlock(1);
          AddBlock(2);
          AddBlock(0);
          AddBlock(30); 
          Client.FuckPacket+=1000;
          Client.FuckPacket2 -= 1000;
                 

      }
  }
    class SP_ROOM_LIST : cServerPacketHandler
    {
        public SP_ROOM_LIST(cWRClient Client, int Page)
        {
            newPacket(29184);
            ArrayList Rooms = Program.WRServer.getRoomsInChannel(Client.getChannelID());

            AddBlock(Rooms.Count);
            AddBlock(Page);
            AddBlock(0);

            foreach (cWRRoom Room in Rooms)
            {
                AddRoomInfo(Room);
            }
        }
    }

    class SP_JOIN_ROOM : cServerPacketHandler
    {
        public enum ErrorCodes
        {   
            GenericError = 94010,
            InvalidPassword = 94030,
            BadLevel = 94300,
            OnlyPremium = 94301
        }

        public SP_JOIN_ROOM(cWRClient Client, cWRRoom Room)
        {
            newPacket(29456);
            AddBlock(1);
            AddBlock(Room.getIDOfPlayer(Client));
            AddRoomInfo(Room);
        }

        public SP_JOIN_ROOM(ErrorCodes ErrCode)
        {
            newPacket(29456);
            AddBlock((int)ErrCode);
        }
    }

    class SP_UNKNOW : cServerPacketHandler
    {
        public SP_UNKNOW()
        {
            newPacket(30032);
            AddBlock(1);
            AddBlock(0);
            AddBlock(0);
            AddBlock(1);
            AddBlock(1);
            AddBlock(2);
            AddBlock(0);
            AddBlock(0);
            AddBlock(0);
            AddBlock(0);
            AddBlock(0);
            AddBlock(0);
            AddBlock(4);
            AddBlock(0);
            AddBlock(0);
            AddBlock(0);
            AddBlock(0);
            AddBlock(0);

        }
    }
    class SP_PLAYER_NUMBER : cServerPacketHandler
    {
        public SP_PLAYER_NUMBER(ArrayList Players, cWRRoom WRRoom)
        {
           newPacket(29968);
            AddBlock(1);
            AddBlock(2);
            AddBlock(1);
            AddBlock(0);
            AddBlock(882);
            AddBlock(WRRoom.getValueofPlayers());
          
           foreach (cWRClient _Client in Players)
                {
                    AddBlock(WRRoom.getIDOfPlayer(_Client));
                    AddBlock(-1);
                    AddBlock(0);
                    AddBlock(0);
                    AddBlock(0);
                    AddBlock(0);
                    AddBlock(1000);
                    AddBlock(-1);
                    AddBlock(-1);
             }
         
            

         AddBlock(0);

    

    
        }
    }
    class SP_CHANGE_ROOM_DATA : cServerPacketHandler
    {
        public SP_CHANGE_ROOM_DATA(int tType, params int[] Params)
        {  
            
      
            newPacket(30000);
            AddBlock(1);
            AddBlock(Params[0]); // Place from the Player who sends the packet
            AddBlock(Params[1]); // Place?
            AddBlock(Params[2]); // Place?
            AddBlock(tType);
            AddBlock(Params[3]);
            AddBlock(Params[4]);
            AddBlock(Params[5]);
            AddBlock(Params[6]);
            AddBlock(Params[7]);
            AddBlock(Params[8]);
            AddBlock(Params[9]);
            AddBlock(Params[10]);
            AddBlock(Params[11]);
            AddBlock(Params[12]);
        }
    }

    class SP_PLAYER_LIST : cServerPacketHandler
    {
        public SP_PLAYER_LIST(ArrayList PlayerList,cWRRoom Room, bool Self)
        {
            newPacket(29952);
            AddBlock(PlayerList.Count);

            foreach (cWRClient _Client in PlayerList)
            {
                AddBlock(_Client.getUserID());
                AddBlock(_Client.getSessionID());
                AddBlock(Room.getIDOfPlayer(_Client));
                AddBlock(0); //Room Ready State of Player(0 = not ready, 1 = ready)
                AddBlock(1); // Ändert sich immer aber kA was es ist -.-
                AddBlock(0);
                AddBlock(0);
                AddBlock(0);
                AddBlock(1000);
                AddBlock(_Client.getNickname());
                AddBlock(-1); // ? Clan
                AddBlock(-1); // ? Clan
                AddBlock(-1); // ? Clan
                AddBlock(0);
                AddBlock(19); // ??
                AddBlock(910); // ??
                AddBlock(_Client.getPremium());
                AddBlock(0);
                AddBlock(_Client.getKills());
                AddBlock(_Client.getDeaths());
                AddBlock(551513); // wtf is this? >> mini idea: how many minutes who played warrock xD
                AddBlock(_Client.getExp());
                AddBlock(-1);
                AddBlock(-1);
                AddBlock(_Client.getNetworkIP()); //network ip
                AddBlock(_Client.getNetworkPort()); //network port
                AddBlock(_Client.getLocalIP()); // local ip lol? wtf, how they get this ???
                AddBlock(_Client.getLocalPort()); // local port ?!
                AddBlock(0);
            }
        }
    }

    class SP_INVITE : cServerPacketHandler
    {
        public enum ErrorCodes
        {
            GenericError = 93020,
            IsPlaying = 93030
        }

        public SP_INVITE(ErrorCodes ErrCode)
        {
            newPacket(29520);
            AddBlock((int)ErrCode);
        }

        public SP_INVITE(cWRClient Client, string Message)
        {
            //1454817889 29520 1 0 -1 13949431 19 gn0m3x -1 -1 -1 -1 0 19 68066 0 0 LassunseineRundezusammenspielen.Kommrein 3 NULL 
            newPacket(29520);
            AddBlock(1);
            AddBlock(0);
            AddBlock(-1);
            AddBlock(Client.getUserID());
            AddBlock(107); // Ping ?!
            AddBlock(Client.getNickname());
            // Clan
            AddBlock(-1);
            AddBlock(-1);
            AddBlock(-1);
            AddBlock(-1);
            // End Clan
            AddBlock(0);
            AddBlock(19);
            AddBlock(Client.getExp());
            AddBlock(0);
            AddBlock(0);
            AddBlock(Message);
            AddBlock(Client.getRoom().getRoomID());
            AddBlock(Client.getRoom().getPassword());
        }
    }

    class SP_ROOM_KICK : cServerPacketHandler
    {
        public SP_ROOM_KICK(int Place)
        {
            newPacket(29505);
            AddBlock(1);
            AddBlock(Place);
        }
    }
}
