﻿using System;
using System.Text;
using System.Runtime.InteropServices;

namespace GameServer
{
    class cConfig
    {
        [DllImport("kernel32.dll")]
        public static extern uint GetPrivateProfileString(string lpAppName, string lpKeyName, string lpDefault, StringBuilder lpReturnedString, uint nSize, string lpFileName);

        StringBuilder sValue = new StringBuilder(255);
        private string ConfigPath = Environment.CurrentDirectory + @"\Data\GameServer.ini";

        public ushort Server_Port;
        public string ISC_Ip;
        public ushort ISC_Port;
        public string ISC_Pw;
        public string DSN_Login;
        public string Server_IP;
        public int Server_ID;
        public string Server_Name;
        public int CurrentPlayer = 0;
        public int iExpFaktor = 0;
        public int iExpRate = 0;
        public int iZombieEvent = 0;

        public void LoadConfig()
        {

            try
            {

                Console.ForegroundColor = ConsoleColor.Yellow;
                Console.WriteLine("################################################");
                Console.Write("#  ");
                Console.ForegroundColor = ConsoleColor.Green;
                Console.Write("Coded by hypeR and Help from Insomnia Team  ");
                Console.ForegroundColor = ConsoleColor.Yellow;
                Console.Write("#\n");
                Console.WriteLine("################################################");
                Console.Write("\n");
                GetPrivateProfileString("SERVER", "Server_ID", "", sValue, 255, ConfigPath);
                Server_ID = int.Parse(sValue.ToString());

                GetPrivateProfileString("SERVER", "Server_Name", "", sValue, 255, ConfigPath);
                Server_Name = sValue.ToString();

                GetPrivateProfileString("SERVER", "Server_IP", "", sValue, 255, ConfigPath);
                Server_IP = sValue.ToString();

                GetPrivateProfileString("SERVER", "Server_Port", "", sValue, 255, ConfigPath);
                Server_Port = ushort.Parse(sValue.ToString());

                GetPrivateProfileString("ISC", "ISC_IP", "", sValue, 255, ConfigPath);
                ISC_Ip = sValue.ToString();

                GetPrivateProfileString("ISC", "ISC_PORT", "", sValue, 255, ConfigPath);
                ISC_Port = ushort.Parse(sValue.ToString());

                GetPrivateProfileString("ISC", "ISC_PASSWORD", "", sValue, 255, ConfigPath);
                ISC_Pw = sValue.ToString();

                GetPrivateProfileString("DATABASE", "DSN", "", sValue, 255, ConfigPath);
                DSN_Login = sValue.ToString();

                GetPrivateProfileString("INGAME", "EXPRate", "", sValue, 255, ConfigPath);
                iExpRate = int.Parse(sValue.ToString());

                GetPrivateProfileString("INGAME", "EXPFaktor", "", sValue, 255, ConfigPath);
                iExpFaktor = int.Parse(sValue.ToString());

                GetPrivateProfileString("INGAME", "ZombieEvent", "", sValue, 255, ConfigPath);
                iZombieEvent = int.Parse(sValue.ToString());
            }
            catch
            {
                new cLog(C.MSG_ERROR, "Loading Config File '" + ConfigPath + "' failed");
                Console.Read();
            }

            if (Server_ID > 0 && Server_Name.Length > 0 && Server_IP.Length > 0 && Server_Port > 0 && ISC_Ip.Length > 0 && ISC_Port > 0 && ISC_Pw.Length > 0 && DSN_Login.Length > 0)
            {
                Program.SQLClass.ConnectSQL();
            }
            else
            {
                new cLog(C.MSG_ERROR, "Loading Config File '" + ConfigPath + "' failed");
                Console.Read();
            }
        }
    }
}
