﻿using System;
using System.Net.Sockets;
using System.Collections;

namespace GameServer
{
    class cWRRoom
    {
        private int RoomID = 0;
        private string Name = "";
        private int Passworded = 0;
        private string Password = "";
        private int PremiumOnly = 0;
        private int MapID = 0;
        private int VoteKick = 0;
        private int RoomType = 0;
        private int MaxPlayer = 0;
        private int LevelLimit = 0;
        private int RoomStatus = 1; // 1 = Waiting, 0 & 2 = Playing
        private int RoomMode = 0; // Mode : 0 = Explosive, 1 = FFA, 2 = Deathmatch, 3 = Conquest
        private int Ping = 0;
        private int Rounds = 0;
        private bool ZombieStarted = false;
        private int ZombieWave = 0;
        public int ActualKills = 0;
        public int WaveKills = 0;

        private cWRClient RoomMaster;
        private cWRClient[] Players = new cWRClient[0];


        public bool isSpawned = false;

        public int[] Flag = new int[32];

        public int RoomTimeLeft = 165000;
        

        public int getSide(cWRClient Client)
        {
            if (Client.RoomSlot < (this.getMaxPlayer() / 2))
                return 0;
            else
                return 1;
        }

        public void Send(cServerPacketHandler Packet)
        {
            foreach (cWRClient _Client in getPlayers())
            {
                _Client.Send(Packet);
            }
        }

        public void setStart() { RoomStatus = 2; } 
        public int getRoomID() { return RoomID; }
        public void setRoomID(int sID) { RoomID = sID; }

        public void setRoomName(string sName) { Name = sName; }
        public string getRoomName() { return Name; }

        public void setPassword(int IsPW, string PW) { Passworded = IsPW; Password = PW; }
        public string getPassword() { return Password; }
        public int HasPassword() { return Passworded; }

        public void setPremiumOnly(int POnly) { PremiumOnly = POnly; }
        public int getPremiumOnly() { return PremiumOnly; }

        public void setMapID(int ID) { MapID = ID; }
        public int getMapID() { return MapID; }

        public void setWave(int tWID) { ZombieWave = tWID; }
        public int getWave() { return ZombieWave; }

        public void setZombieStarted(bool tResult) { ZombieStarted = tResult; }
        public bool getZombieStarted() { return ZombieStarted; }

        public void setVoteKick(int vKick) { VoteKick = vKick; }
        public int getVoteKick() { return VoteKick; }

        public void setRoomType(int tType) { RoomType = tType; }
        public int getRoomType() { return RoomType; }

        public void setMaxPlayer(int mPlayer)
        {
            MaxPlayer = mPlayer;
            Array.Resize(ref Players, MaxPlayer);
            for (int i = 0; i < MaxPlayer; i++)
            { Players.SetValue(null, i); }
        }

        public int getMaxPlayer() { return MaxPlayer; }

        public void setLevelLimit(int lLimit) { LevelLimit = lLimit; }
        public int getLevelLimit() { return LevelLimit; }

        public void setRoomStatus(int Status) { RoomStatus = Status; }
        public int getRoomStatus() { return RoomStatus; }

        public void setRoomMode(int Mode) { RoomMode = Mode; }
        public int getRoomMode() { return RoomMode; }

        public void setPing(int iPing) { Ping = iPing; }
        public int getPing() { return Ping; }

        public void AddPlayer(cWRClient tPlayer)
        {
            for (int i = 0; i < MaxPlayer; i++)
            {
                if (!(Players.GetValue(i) is cWRClient))
                {
                    Players.SetValue(tPlayer, i);
                    break;
                }
            }
        }
        public void RemovePlayer(cWRClient tPlayer)
        {
            for (int i = 0; i < MaxPlayer; i++)
            {
                if ((Players.GetValue(i) is cWRClient) && Players.GetValue(i).Equals(tPlayer))
                {
                    Players.SetValue(null, i);
                    break;
                }
            }
        }

        public void setRounds(int tRounds) { Rounds = tRounds; }
        public int getRounds() { return Rounds; }

        public int getValueofPlayers()
        {
            ArrayList PlayerList = new ArrayList();
            int ValuePlayers = 0;
            for (int i = 0; i < MaxPlayer; i++)
            {
                if (Players.GetValue(i) is cWRClient)
                {
                    ValuePlayers++;
                }
            }
            return ValuePlayers;
        }
        public ArrayList getPlayers() 
        {
            ArrayList PlayerList = new ArrayList();

            for(int i = 0; i < MaxPlayer; i++)
            {
                if(Players.GetValue(i) is cWRClient)
                {
                    PlayerList.Add(Players.GetValue(i));
                }
            }
            return PlayerList; 
        }

        public int getIDOfPlayer(cWRClient tPlayer)
        {
            for (int i = 0; i < MaxPlayer; i++)
            {
                if ((Players.GetValue(i) is cWRClient) && Players.GetValue(i).Equals(tPlayer))
                {
                    return i;
                }
            }
            return -1;
        }

        public cWRClient getPlayerByID(int ID)
        {
            if (Players.GetValue(ID) is cWRClient)
            {
                return (cWRClient)Players.GetValue(ID);
            }
            return (cWRClient)null;
        }

       
        public ArrayList getPlayersFromTeam(cWRClient _Client)
        {
            ArrayList PlayerList = new ArrayList();
            int ID = getIDOfPlayer(_Client);
 
            if (ID < (MaxPlayer / 2))
            {
                //NIU
                for (int i = (MaxPlayer / 2); i < (MaxPlayer); i++)
                {
                    
                  PlayerList.Add(Players.GetValue(i));
                    
                }
            }
            else
            {
                //Derbaran
                for (int i = 0; i < (MaxPlayer / 2 - 1); i++)
                {

                    PlayerList.Add(Players.GetValue(i));
                }
            }
            return PlayerList;
        }

        public int ChangeSide(cWRClient _Client)
        {
            int ID = getIDOfPlayer(_Client);

            if (ID < (MaxPlayer/ 2))
            {
                //NIU
                for (int i = (MaxPlayer / 2); i < (MaxPlayer - 1); i++)
                {
                    if (!(Players.GetValue(i) is cWRClient))
                    {
                        Players.SetValue(_Client, i);
                        Players.SetValue(null, ID);
                        _Client.RoomSlot = i;
                        return i;
                    }
                }
            }
            else
            {
                //Derbaran
                for (int i = 0; i < (MaxPlayer / 2 - 1); i++)
                {
                    if(!(Players.GetValue(i) is cWRClient))
                    {
                        Players.SetValue(_Client, i);
                        Players.SetValue(null, ID);
                        _Client.RoomSlot = i;
                        return i;
                    }
                }
            }
            return -1;
        }

        public void setRoomMaster(cWRClient _Client) { RoomMaster = _Client; }
        public cWRClient getRoomMaster() { return RoomMaster; }
    }
}
