﻿using System;
using System.Net.Sockets;
using System.Collections;
using System.Data.Odbc;

namespace GameServer
{
    class CP_ISC_LOGIN_PACKET : cClientPacketHandler
    {
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {
            if (Convert.ToInt32(Packet.getBlock()) == 77)
            {
                Program.UDPClass.StartUDPServer();
            }
            else
            {
                Environment.Exit(0);
            }
        }
    }

    class CP_WELCOME_PACKET : cClientPacketHandler
    {
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {
            Client.setMac(Packet.getBlockByIndex(2));
            Client.Send(new SP_WELCOME_PACKET());

        }
    }

    class CP_LEAVE_SERVER : cClientPacketHandler
    {
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {
            new cLog(C.MSG_INFO, "Client<" + Client.getNickname() + "> left the Server! #IP : " + Client.getNetworkIP());
            Program.SQLClass.runSQL("UPDATE ACCOUNT_TBL SET online = '0' WHERE userID = '" + Client.getUserID().ToString() + "'");
            Client.Send(new SP_LEAVE_SERVER());
            
        }
    }
    class CP_CHARACTER_INFO : cClientPacketHandler
    {
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {
            Client.setUserID(long.Parse(Packet.getBlock()));
            Client.getUserData();
            Client.loadItems();
            Client.GetAllWeapon();

            //Client.uniqIDisCRC = int.Parse(Packet.getBlockByIndex(5));
            if (Client.getAccesslevel() == 4)
            {
                Client.setNickname("[GM]" + Client.getNickname());
                Client.setExp(2147483647);
                Client.setLevel(101); 
                Client.setPremium(4);// remove it... What setexp setlevel and setpremium because is bugged...some gm can test from lvl 1. wait
            }
            else if (Client.getAccesslevel() == 3)
            {
                Client.setNickname("[GM]" + Client.getNickname());
            }
            else if (Client.getAccesslevel() == 2)
            {
                Client.setNickname("[TESTER]" + Client.getNickname());
            }
            else if (Client.getAccesslevel() == 1.5)
            {
                Client.setNickname("[MOD]" + Client.getNickname());
            }
            else if (Client.getAccesslevel() == 1)
            {
                Client.setNickname("[TESTER]" + Client.getNickname()); // i ma
            }
            Client.Send(new SP_CHARACTER_INFO(Client));
            //Program.SQLClass.runSQL("UPDATE ACCOUNT_TBL SET online = '1' WHERE userID = '" + Client.getUserID().ToString() + "'");
            //Only for Debugging :D
           
            Client.Send(new SP_CHAT(1, 1, 1));
            Client.Send(new SP_PREMIUM_LEFT(Client));
            Client.Send(new SP_ROOM_LIST(Client, Client.getRoomPage()));
           // Client.Send(new SP_CHAT(Client, SP_CHAT.ChatType.Notice1,"Welcome on Insomnia Project Server,the server is in open beta,only testers or higher people have access,visit wWw.InsomniaProject.tk",100,"SYSTEM"));
            Client.Send(new SP_SHOW_MSG("Welcome on the Insomania Server Back!                This Server is Developed in C#!                             Our Teamspeak IP is: Offline"));

        }
    }

    class CP_CHANGE_CHANNEL : cClientPacketHandler
    {
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {
            int Channel = int.Parse(Packet.getBlock());
            if (Client.getAccesslevel() > 1)
            {
                Client.setChannelID(Channel);
            }
            else
            {
                if (Channel == 1 || Channel == 2 || Channel == 3)
                {
                    Client.Send(new SP_CHAT(3,3,3,3,int.Parse(Packet.getBlock())));
                }
                Client.setChannelID(4);
            }
            Client.Send(new SP_CHANGE_CHANNEL(Client));
            Client.Send(new SP_ROOM_LIST(Client, 0));
        }
    }

    class CP_ZOMBIE_HANDLE : cClientPacketHandler
    {
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {
            
            Client.Send(new SP_ZOMBIE_HANDLE(20));
            
        }
    }

    class CP_LUCKY_SHOT : cClientPacketHandler
    {
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {

            Client.Send(new SP_LUCKY_SHOT());

        }
    }
    class CP_LUCKY_SHOT_WIN : cClientPacketHandler
    {
        public string[] WeaponsOnLoose = new string[] { "DF35", "DC93", "DF65", "DC33", "DB33", "DU01", "BA0E", "BA0F", "BA08", "BA09", "BA10", "DB16", "DB08", "DB09", "DA04", "DA06", "DQ02", "DQ03", "DV01" };
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {
            int AlreadyHave = 0;
            //3777520 30258 0 DA08 3000 3 
            Packet.getBlock();
            string Item = Packet.getBlock();
            int Dinar = int.Parse(Packet.getBlock());
            int Bets = int.Parse(Packet.getBlock());
            Random random = new Random();
            int win = random.Next(2);
           
            if (win == 0)
            {
                int weapon2 = random.Next(20);
                Item = WeaponsOnLoose[weapon2];
            }
            foreach (cWRClient.tItem pItem in Client.getItems())
            {
                if (pItem.itemCode == Item)
                {
                    AlreadyHave = 1;
                }
            }
            if (AlreadyHave != 1)
            {

                Client.Send(new SP_LUCKY_SHOT(Client, Bets, Item, win));
                Client.setDinar(Client.getDinar() - (1200 * Bets));
                Program.SQLClass.runSQL("UPDATE ACCOUNT_TBL_DETAIL SET dinar = '" + Client.getDinar().ToString() + "' WHERE userID = '" + Client.getUserID().ToString() + "'").ToString();
                Program.SQLClass.runSQL("INSERT INVENTORY_TBL (userID, itemCode, expireDate, class_0, class_1, class_2, class_3, class_4) VALUES (" + Client.getUserID().ToString() + ", '" + Item + "',22020609, -1, -1, -1, -1, -1)");
                Client.loadItems();
            }
            else
            {
                Client.Send(new SP_LUCKY_SHOT(Client, Bets, Item, win));
            }
                
           
        }
    }
    class CP_DELETE_WEAPON : cClientPacketHandler
    {
         public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {
            string WeaponCode = Packet.getBlock();
            int DaysRemaining = int.Parse(Packet.getBlock());

            Program.SQLClass.runSQL("DELETE * FROM INVENTORY_TBL WHERE itemCode = '" + WeaponCode + "'");
            Client.Send(new SP_DELETE_WEAPON(Client,WeaponCode));
            Client.loadItems();
        }
    }
    class CP_ZOMBIE_HANDLE2 : cClientPacketHandler
    {
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {

           

        }
    }

    class CP_COUPON_EVENT : cClientPacketHandler
    {
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {

            Client.Send(new SP_COUPON_EVENT(Client));

        }
    }


    class CP_CHAT : cClientPacketHandler
    {
        public void CheckCommand(string Message,cWRClient _Client)
        {
            int MessageLen = Message.Length;
            int Privilegs = _Client.getAccesslevel();

            // TODO : AddCommands :P
            if (Privilegs == 1.5)
            {
                //MOD
                //Tester
                if (Message.Contains("/waveup"))
                {
                    _Client.Send(new SP_ZOMBIE_HANDLE((_Client.getRoom().getWave() +1))); // Get up of 1 wavei
                }
                if (Message.Contains("/lastwave"))
                {
                    _Client.Send(new SP_ZOMBIE_HANDLE(21)); // Go to last wave
                }
            }
            else if (Privilegs == 2)
            {
                //GM
                //Tester
                if (Message.Contains("/waveup"))
                {
                    _Client.Send(new SP_ZOMBIE_HANDLE((_Client.getRoom().getWave() + 1))); // Get up of 1 wavei
                }
                if (Message.Contains("/lastwave"))
                {
                    _Client.Send(new SP_ZOMBIE_HANDLE(21)); // Go to last wave
                }
            }
            else if (Privilegs == 3)
            {
                //ADMIN
                //Tester
                if (Message.Contains("/waveup"))
                {
                    _Client.Send(new SP_ZOMBIE_HANDLE((_Client.getRoom().getWave() + 1))); // Get up of 1 wavei
                }
                if (Message.Contains("/lastwave"))
                {
                    _Client.Send(new SP_ZOMBIE_HANDLE(21)); // Go to last wave
                }
                
            }
            else if (Privilegs == 4)
            {
                //HeadAdmin
                //Tester
                if (Message.Contains("/waveup"))
                {
                    _Client.Send(new SP_ZOMBIE_HANDLE((_Client.getRoom().getWave() + 1))); // Get up of 1 wavei
                }
                if (Message.Contains("/lastwave"))
                {
                    _Client.Send(new SP_ZOMBIE_HANDLE(21)); // Go to last wave
                }
            }
            else if (Privilegs == 1)
            {
                //Tester
                if (Message.Contains("/waveup"))
                {
                    _Client.Send(new SP_ZOMBIE_HANDLE((_Client.getRoom().getWave() +1))); // Get up of 1 wavei
                }
                if (Message.Contains("/lastwave"))
                {
                    _Client.Send(new SP_ZOMBIE_HANDLE(21)); // Go to last wave
                }
            }
            else if (Privilegs > 0) 
            { 
                //Global

                //messenger
                if (Message.Contains("/add")) // /add-anksel 
                {
                    string Name = Message;
                    string toAdd = Name.Split(new char[] { '-' })[1];

                    if (_Client.getID(toAdd) != 0)
                    {
                        Program.SQLClass.runSQL("INSERT FRIENDS_TBL (userID,friendID) VALUES (" + _Client.getUserID().ToString() + ", '" + _Client.getID(toAdd).ToString() + "') ");
                    }
                }
                if (Message.Contains("/friendlist"))
                {
                    bool isOnline = false;
                    string Name = String.Empty;

                    
                }
                
            }
            else if (Privilegs > 1)
            {
                if (Message.Contains("/ban"))
                {
                    string Name = Message;
                    string toAdd = Name.Split(new char[] { '-' })[1];

                    cWRClient tPlayer = Program.WRServer.getPlayerByNickname(toAdd);
                    if (tPlayer is cWRClient && tPlayer.getSessionID() > 0) // && tPlayer.getAccesslevel() != 3
                    {
                        Program.WRServer.RemoveClient(tPlayer);
                        Program.SQLClass.runSQL("UPDATE ACCOUNT_TBL SET online = '0' WHERE userID = '" + tPlayer.getUserID().ToString() + "'");
                        Program.SQLClass.runSQL("UPDATE ACCOUNT_TBL SET accesslevel = '0' WHERE userID = '" + tPlayer.getUserID().ToString() + "'");
                        Program.ConfigClass.CurrentPlayer--;


                        tPlayer.Send(new SP_LEAVE_SERVER());
                        tPlayer = null;
                    }


                }
            }
        }
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {
            int ChatType = int.Parse(Packet.getBlock());
            int TargetID = int.Parse(Packet.getBlock());
            string TargetName = Packet.getBlock();
            string Message = Packet.getBlock();
            cWRRoom WRRoom = Client.getRoom();
           // 25602778 29696 1 2 [GM]UnknownHype 3 0 NULL [GM]UnknownHype>>hi  

            CheckCommand(Message,Client);

            if (Message.Contains("/shutdown"))
            {
                foreach (cWRClient myPlayer in Program.WRServer.getAllPlayers())
                {
                    myPlayer.Send(new SP_CHAT(myPlayer, SP_CHAT.ChatType.Notice1, "[Insomnia Team] Server is Going down for Maintance!", 100, "SYSTEM"));
                    myPlayer.Send(new SP_CHAT(0, 0, 0, 5));
                    myPlayer.Send(new SP_CHAT(0, 0, 0, 4));
                    myPlayer.Send(new SP_CHAT(0, 0, 0, 3));
                    myPlayer.Send(new SP_CHAT(0, 0, 0, 2));
                    myPlayer.Send(new SP_CHAT(0, 0, 0, 1));
                    Program.WRServer.RemoveClient(myPlayer);
                    Program.ConfigClass.CurrentPlayer--;
                    myPlayer.Send(new SP_LEAVE_SERVER());
                }

            }
            if (Client.getAccesslevel() > 2)
            {
                if (Message.Contains("NOTICE"))
                {
                    Message = Message.Remove(Message.Length - 6, 0);
                    ChatType = 30;
                    foreach (cWRClient _Client in Program.WRServer.getAllPlayers())
                    {
                        _Client.Send(new SP_CHAT(Client, SP_CHAT.ChatType.Notice1, Message, 200, TargetName));
                    }
                    new cLog(C.MSG_INFO, Client.getNickname() + " sent this notice on the server: " + Message);
                }
            }
            if (Message.Contains("!fin"))
            {
                Client.Send(new SP_END_OF_GAME(Client,WRRoom.getRoomMaster().iKills,1)); //Yea but exp factor is already high...
            }

            switch (ChatType)
            {

                case 3:
                    if (Client.getAccesslevel() > 1)
                    {
                        TargetID = 100;
                    }


                    foreach (cWRClient _Client in Program.WRServer.getPlayerInChannel(Client.getChannelID()))
                    {
                        if (_Client.getRoom() == null)
                        {
                            _Client.Send(new SP_CHAT(Client, SP_CHAT.ChatType.Lobby_ToChannel, Message, TargetID, TargetName));
                        }
                    }

                    break;
                case 4:
                    TargetID = -1;

                    if (Client.getAccesslevel() > 1)
                    {
                        TargetID = 999; // Yellow GM Chat(Only in Rooms)
                    }


                    foreach (cWRClient _Client in WRRoom.getPlayers())
                    {
                        _Client.Send(new SP_CHAT(Client, SP_CHAT.ChatType.Room_ToAll, Message, TargetID, TargetName));
                    }

                    break;
                case 5:

                    TargetID = -1;

                    if (Client.getAccesslevel() > 1)
                    {
                        TargetID = 999;
                    }

                    foreach (cWRClient _Client in WRRoom.getPlayersFromTeam(Client))
                    {


                        _Client.Send(new SP_CHAT(Client, SP_CHAT.ChatType.Room_ToTeam, Message, TargetID, TargetName));


                    }

                    break;
                case 6:
                    cWRClient TargetClient = Program.WRServer.getPlayerByNickname(TargetName);
                    if (TargetClient is cWRClient && TargetClient.getSessionID() > 0)
                    {
                        Client.Send(new SP_CHAT(Client, SP_CHAT.ChatType.Whisper, Message, TargetClient.getSessionID(), TargetClient.getNickname()));
                        if (!Client.Equals(TargetClient))
                        {
                            TargetClient.Send(new SP_CHAT(Client, SP_CHAT.ChatType.Whisper, Message, TargetClient.getSessionID(), TargetClient.getNickname()));
                        }
                    }
                    else
                    {
                        Client.Send(new SP_CHAT(SP_CHAT.ErrorCodes.ErrorUser, TargetName + Convert.ToChar(0x1D)));
                    }
                    break;
                case 8:
                    foreach (cWRClient _Client in Program.WRServer.getPlayers(false))
                    {
                        _Client.Send(new SP_CHAT(Client, SP_CHAT.ChatType.Room_ToAll, Message, TargetID, TargetName));
                    }
                    break;
            }
        }
    }
    class CP_UNKNOW : cClientPacketHandler
    {
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {
            ArrayList tPlayer = new ArrayList();
            tPlayer = Client.getRoom().getPlayers();
            if (Client.getChannelID() == 4)
            {
                Client.Send(new SP_UNKNOW(tPlayer));
            }
            else
            {
                //1176596062 30032 1 0 0 94 98 2 0 0 0 2 1 0 8 0 0 3 3 0 
                Client.Send(new SP_UNKNOW(tPlayer));
            }
        }
    }

    class CP_COUPON_BUY : cClientPacketHandler
    {
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {
            int Vorhanden = 0;
            string WeaponToBuy = Packet.getBlock();
            string WeaponCode = string.Empty;
            //DF05-1-0-12050209-0-0-0-0-0,DB12-1-0-12042717-0-0-0-0-0,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^
            WeaponCode = WeaponToBuy;

            foreach (cWRClient.tItem pItem in Client.getItems())
            {
                if (pItem.itemCode == WeaponToBuy)
                {
                    //Nothing
                    Vorhanden = 1; 
                }
                else
                {
                    
                }
            }
            if (Vorhanden != 1)
            {
                Client.setCoupons(Client.getCoupons() - 5);
                Program.SQLClass.runSQL("INSERT INVENTORY_TBL (userID, itemCode, expireDate, class_0, class_1, class_2, class_3, class_4) VALUES (" + Client.getUserID().ToString() + ", '" + WeaponToBuy + "', " + Client.TimeAdd(3) + ", -1, -1, -1, -1, -1)");
                Program.SQLClass.runSQL("UPDATE ACCOUNT_TBL_DETAIL (coupons) VALUES (" + Client.getCoupons() + ")");
                Client.loadItems();
                Client.Send(new SP_COUPON_BUY(WeaponCode, Client));
            }
         
           
                
            
        }
    }
    class CP_BUY_WEAPON : cClientPacketHandler
    {
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {
            Packet.getBlock(); //  1110   
            string Weapon = Packet.getBlock();//DC04 
            int WeaponID = int.Parse(Packet.getBlock());//22 
            int kp = int.Parse(Packet.getBlock());//-1 
            int Time = int.Parse(Packet.getBlock());//3 
            int Error = 1;
            long Dinar = 0;
            string Items = "";
            int DTime = 0;
            int Vorhanden = 0;

            foreach (cWRClient.bItem lItem in Client.getItemList())
            {
                if (lItem.WaffenName == Weapon)
                {

                    if (lItem.Premium == 1 && Client.getPremium() < 1) Error = 98010;
                    if (lItem.Level > Client.getLevel()) Error = 97020;
                    switch (Time)
                    {
                        case 0: if (lItem.Tage3 > Client.getDinar()) { Error = 97040; } else { Dinar = lItem.Tage3; DTime = 3; } break;//die sache ndann acuh
                        case 1: if (lItem.Tage7 > Client.getDinar()) { Error = 97040; } else { Dinar = lItem.Tage7; DTime = 7; } break;
                        case 2: if (lItem.Tage15 > Client.getDinar()) { Error = 97040; } else { Dinar = lItem.Tage15; DTime = 15; } break;
                        case 3: if (lItem.Tage30 > Client.getDinar()) { Error = 97040; } else { Dinar = lItem.Tage30; DTime = 30; } break;
                    }


                }
            }


            if (Error == 1)
            {


                foreach (cWRClient.tItem pItem in Client.getItems())
                {
                    if (pItem.itemCode == Weapon)
                    {

                        Vorhanden = 1;

                    }
                    else { Items += pItem.itemCode + "-1-1-" + pItem.expireDate.ToString() + "-0-0-0-0-0,"; }


                }
            }
            if (Vorhanden == 1)
            {
                Error = 97020;
            }
            else
            {
                if (Error == 1)
                {
                    Program.SQLClass.runSQL("INSERT INVENTORY_TBL (userID, itemCode, expireDate, class_0, class_1, class_2, class_3, class_4) VALUES (" + Client.getUserID().ToString() + ", '" + Weapon + "', " + Client.TimeAdd(DTime) + ", -1, -1, -1, -1, -1)");
                    Client.loadItems();
                }
            }

            for (int i = 0; i < (31 - (Client.getItems().Count + Vorhanden)); i++)
            {

                Items += "^,";

                Items = Items.Substring(0, Items.Length - 1);
            }


            string Weaponstring = Weapon + "-1-1-" + Client.TimeAdd(DTime) + "-0-0-0-0-0," + Items;


            if (Error == 1)
            {
                if (Client.getAccesslevel() == 3)
                {
                    Client.Send(new SP_BUY_WEAPON(Client, 1, (Client.getDinar()), Weaponstring));
                    Client.setDinar(Client.getDinar() - Dinar);
                }
                else
                {
                    Client.Send(new SP_BUY_WEAPON(Client, 1, (Client.getDinar() - Dinar), Weaponstring));
                    Client.setDinar(Client.getDinar() - Dinar);
                }
            }
            else
            {
                Client.Send(new SP_BUY_WEAPON(Client, Error, 0, ""));
            }
        }
    }


    class CP_PREMIUM_LEFT : cClientPacketHandler
    {
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {
            Packet.getBlock();
            long iTime = long.Parse(Packet.getBlock());
            //kA ?

            
           // new cLog(C.MSG_SUCCESS, "SENDET" + Client.FuckPacket.ToString() + Client.FuckPacket2.ToString());
        }
    }

    class CP_USER_LIST : cClientPacketHandler
    {
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {
            int Operation = int.Parse(Packet.getBlock());
            ArrayList PlayerList = new ArrayList();

            if (Operation == 0) // All
            {
                PlayerList = Program.WRServer.getAllPlayers();
            }
            else if (Operation == 1) // by Name
            {
                string Nickname = Packet.getBlock();
                cWRClient tPlayer = Program.WRServer.getPlayerByNickname(Nickname);
                if (tPlayer is cWRClient && tPlayer.getSessionID() > 0)
                {
                    PlayerList.Add(tPlayer);
                }
            }
            else if (Operation == 2) // by Clan
            {
                // Not ready
            }
            else if (Operation == 3) // by Level
            {
                string Range = Packet.getBlock();
                int Range1 = int.Parse(Range.Split(new char[] { '-' })[0]);
                int Range2 = int.Parse(Range.Split(new char[] { '-' })[1]);

                foreach (cWRClient _Client in Program.WRServer.getAllPlayers())
                {
                    if (_Client.getLevel() >= Range1 && _Client.getLevel() <= Range2)
                    {
                        PlayerList.Add(_Client);
                    }
                }

            }

            Client.Send(new SP_USER_LIST(PlayerList));
        }
    }

    class CP_CHANGE_WEAPON : cClientPacketHandler
    {
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {

            int Unequip = int.Parse(Packet.getBlock());
            int _Class = int.Parse(Packet.getBlock());
            Packet.getBlock();
            Packet.getBlock();
            string WeaponCode = Packet.getBlock();
            int Slot = int.Parse(Packet.getBlock());

            string WeaponString = "";
            Program.SQLClass.runSQL("UPDATE INVENTORY_TBL SET class_" + _Class.ToString() + " = '-1' WHERE userID = '" + Client.getUserID().ToString() + "' AND class_" + _Class.ToString() + " = '" + Slot.ToString() + "'");
            Client.loadItems();
            foreach (cWRClient.tItem pItem in Client.getItems())
            {

                switch (pItem.SlotEngineer)
                {

                    case 0: Client.slot1E = pItem.itemCode; break;
                    case 1: Client.slot2E = pItem.itemCode; break;
                    case 2: Client.slot3E = pItem.itemCode; break;
                    case 3: Client.slot4E = pItem.itemCode; break;
                    case 4: Client.slot5E = pItem.itemCode; break;
                    case 5: Client.slot6E = pItem.itemCode; break;


                }
                switch (pItem.SlotMedic)
                {
                    case 0: Client.slot1M = pItem.itemCode; break;
                    case 1: Client.slot2M = pItem.itemCode; break;
                    case 2: Client.slot3M = pItem.itemCode; break;
                    case 3: Client.slot4M = pItem.itemCode; break;
                    case 4: Client.slot5M = pItem.itemCode; break;
                    case 5: Client.slot6M = pItem.itemCode; break;
                }
                switch (pItem.SlotSniper)
                {
                    case 0: Client.slot1S = pItem.itemCode; break;
                    case 1: Client.slot2S = pItem.itemCode; break;
                    case 2: Client.slot3S = pItem.itemCode; break;
                    case 3: Client.slot4S = pItem.itemCode; break;
                    case 4: Client.slot5S = pItem.itemCode; break;
                    case 5: Client.slot6S = pItem.itemCode; break;
                }
                switch (pItem.SlotAssault)
                {
                    case 0: Client.slot1A = pItem.itemCode; break;
                    case 1: Client.slot2A = pItem.itemCode; break;
                    case 2: Client.slot3A = pItem.itemCode; break;
                    case 3: Client.slot4A = pItem.itemCode; break;
                    case 4: Client.slot5A = pItem.itemCode; break;
                    case 5: Client.slot6A = pItem.itemCode; break;
                }
                switch (pItem.SlotHeavyTrooper)
                {
                    case 0: Client.slot1H = pItem.itemCode; break;
                    case 1: Client.slot2H = pItem.itemCode; break;
                    case 2: Client.slot3H = pItem.itemCode; break;
                    case 3: Client.slot4H = pItem.itemCode; break;
                    case 4: Client.slot5H = pItem.itemCode; break;
                    case 5: Client.slot6H = pItem.itemCode; break;
                }

            }


            if (Unequip == 0)
                Program.SQLClass.runSQL("UPDATE INVENTORY_TBL SET class_" + _Class.ToString() + " = '" + Slot.ToString() + "' WHERE userID = '" + Client.getUserID().ToString() + "' AND itemCode = '" + WeaponCode + "'");
            else
                Program.SQLClass.runSQL("UPDATE INVENTORY_TBL SET class_" + _Class.ToString() + " = '-1' WHERE userID = '" + Client.getUserID().ToString() + "' AND itemCode = '" + WeaponCode + "'");

            switch (_Class)
            {
                case 0:

                    switch (Slot)
                    {
                        case 0: if (Unequip == 0) Client.slot1E = WeaponCode; else Client.slot1E = "^"; break;
                        case 1: if (Unequip == 0) Client.slot2E = WeaponCode; else Client.slot2E = "^"; break;
                        case 2: if (Unequip == 0) Client.slot3E = WeaponCode; else Client.slot3E = "^"; break;
                        case 3: if (Unequip == 0) Client.slot4E = WeaponCode; else Client.slot4E = "^"; break;
                        case 4: if (Unequip == 0) Client.slot5E = WeaponCode; else Client.slot5E = "^"; break;
                        case 5: if (Unequip == 0) Client.slot6E = WeaponCode; else Client.slot6E = "^"; break;
                    }
                    if (Client.slot3E == Client.slot5E) Client.slot5E = "^";
                    WeaponString = Client.slot1E + "," + Client.slot2E + "," + Client.slot3E + "," + Client.slot4E + "," + Client.slot5E + "," + Client.slot6H + ",^,^";
                    break;
                case 1:

                    switch (Slot)
                    {
                        case 0: if (Unequip == 0) Client.slot1M = WeaponCode; else Client.slot1M = "^"; break;
                        case 1: if (Unequip == 0) Client.slot2M = WeaponCode; else Client.slot2M = "^"; break;
                        case 2: if (Unequip == 0) Client.slot3M = WeaponCode; else Client.slot3M = "^"; break;
                        case 3: if (Unequip == 0) Client.slot4M = WeaponCode; else Client.slot4M = "^"; break;
                        case 4: if (Unequip == 0) Client.slot5M = WeaponCode; else Client.slot5M = "^"; break;
                        case 5: if (Unequip == 0) Client.slot6M = WeaponCode; else Client.slot6M = "^"; break;
                    }
                    if (Client.slot3M == Client.slot5M) Client.slot5M = "^";
                    WeaponString = Client.slot1M + "," + Client.slot2M + "," + Client.slot3M + "," + Client.slot4M + "," + Client.slot5M + "," + Client.slot6M + ",^,^";
                    break;
                case 2:

                    switch (Slot)
                    {
                        case 0: if (Unequip == 0) Client.slot1S = WeaponCode; else Client.slot1S = "^"; break;
                        case 1: if (Unequip == 0) Client.slot2S = WeaponCode; else Client.slot2S = "^"; break;
                        case 2: if (Unequip == 0) Client.slot3S = WeaponCode; else Client.slot3S = "^"; break;
                        case 3: if (Unequip == 0) Client.slot4S = WeaponCode; else Client.slot4S = "^"; break;
                        case 4: if (Unequip == 0) Client.slot5S = WeaponCode; else Client.slot5S = "^"; break;
                        case 5: if (Unequip == 0) Client.slot6S = WeaponCode; else Client.slot6S = "^"; break;
                    }
                    if (Client.slot3S == Client.slot5S) Client.slot5S = "^";
                    WeaponString = Client.slot1S + "," + Client.slot2S + "," + Client.slot3S + "," + Client.slot4S + "," + Client.slot5S + "," + Client.slot6S + ",^,^";

                    break;
                case 3:

                    switch (Slot)
                    {
                        case 0: if (Unequip == 0) Client.slot1A = WeaponCode; else Client.slot1A = ""; break;
                        case 1: if (Unequip == 0) Client.slot2A = WeaponCode; else Client.slot2A = ""; break;
                        case 2: if (Unequip == 0) Client.slot3A = WeaponCode; else Client.slot3A = ""; break;
                        case 3: if (Unequip == 0) Client.slot4A = WeaponCode; else Client.slot4A = ""; break;
                        case 4: if (Unequip == 0) Client.slot5A = WeaponCode; else Client.slot5A = "^"; break;
                        case 5: if (Unequip == 0) Client.slot6A = WeaponCode; else Client.slot6A = "^"; break;
                    }
                    if (Client.slot3A == Client.slot5A) Client.slot5A = "^";
                    WeaponString = Client.slot1A + "," + Client.slot2A + "," + Client.slot3A + "," + Client.slot4A + "," + Client.slot5A + "," + Client.slot6A + ",^,^";
                    break;

                case 4:

                    switch (Slot)
                    {
                        case 0: if (Unequip == 0) Client.slot1H = WeaponCode; else Client.slot1H = "^"; break;
                        case 1: if (Unequip == 0) Client.slot2H = WeaponCode; else Client.slot2H = "^"; break;
                        case 2: if (Unequip == 0) Client.slot3H = WeaponCode; else Client.slot3H = "^"; break;
                        case 3: if (Unequip == 0) Client.slot4H = WeaponCode; else Client.slot4H = "^"; break;
                        case 4: if (Unequip == 0) Client.slot5H = WeaponCode; else Client.slot5H = "^"; break;
                        case 5: if (Unequip == 0) Client.slot6H = WeaponCode; else Client.slot6H = "^"; break;
                    }
                    if (Client.slot3H == Client.slot5H) Client.slot5H = "^";
                    WeaponString = Client.slot1H + "," + Client.slot2H + "," + Client.slot3H + "," + Client.slot4H + "," + Client.slot5H + "," + Client.slot6H + ",^,^";
                    break;
            }



            if (Client.slot3E == Client.slot5E) Client.slot5E = "^";
            Client.Send(new SP_CHANGE_WEAPON(_Class, WeaponString)); // Must adding Weapon shitt string
        }
    }

    class CP_CREATE_ROOM : cClientPacketHandler
    {
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {
            if (Client.getChannelID() != 4)
            {
                if (Client.getAccesslevel() > 1)
                {
                    cWRRoom WRRoom = new cWRRoom();


                    WRRoom.setRoomID(Program.WRServer.getRoomsInChannel(Client.getChannelID()).Count);
                    WRRoom.setRoomName(Packet.getBlock());
                    WRRoom.setPassword(int.Parse(Packet.getBlock()), Packet.getBlock());
                    WRRoom.setMaxPlayer(8 * (int.Parse(Packet.getBlock()) + 1));
                    //WRRoom.setMaxPlayer(4);
                    WRRoom.setMapID(int.Parse(Packet.getBlock()));
                    Packet.getBlock();
                    Packet.getBlock();
                    WRRoom.setRoomType(int.Parse(Packet.getBlock()));
                    WRRoom.setLevelLimit(int.Parse(Packet.getBlock()));
                    WRRoom.setPremiumOnly(int.Parse(Packet.getBlock()));
                    WRRoom.setVoteKick(int.Parse(Packet.getBlock()));
                    WRRoom.setRoomMaster(Client);

                    if (Client.getChannelID() == 1)
                    {
                        WRRoom.setRoomMode(0);
                    }
                    else
                    {
                        WRRoom.setRoomMode(2);
                    }

                    WRRoom.AddPlayer(Client);
                    Client.setRoom(WRRoom);
                    Program.WRServer.AddRoom(WRRoom, Client.getChannelID());
                    Client.Send(new SP_CREATE_ROOM(WRRoom));

                    foreach (cWRClient _Client in Program.WRServer.getPlayerInChannel(Client.getChannelID()))
                    {
                        _Client.Send(new SP_ROOM_LIST(_Client, _Client.getRoomPage()));

                    }
                }
                else
                {
                    //WORK?
                    Client.setChannelID(4);
                    Client.Send(new SP_CHANGE_CHANNEL(Client));
                    Client.Send(new SP_ROOM_LIST(Client, 0));
                    Client.Send(new SP_CHAT(Client, SP_CHAT.ChatType.Notice1, "[Insomnia Team] You can't create a room in this mode yet.", 100, "SYSTEM"));
                   
                }
            }
            else
            {


                cWRRoom WRRoom = new cWRRoom();


                WRRoom.setRoomID(Program.WRServer.getRoomsInChannel(Client.getChannelID()).Count);
                WRRoom.setRoomName(Packet.getBlock());
                WRRoom.setPassword(int.Parse(Packet.getBlock()), Packet.getBlock());
                //WRRoom.setMaxPlayer(8 * (int.Parse(Packet.getBlock()) + 1));
                WRRoom.setMaxPlayer(4);
                WRRoom.setMapID(int.Parse(Packet.getBlock()));
                Packet.getBlock();
                Packet.getBlock();
                WRRoom.setRoomType(int.Parse(Packet.getBlock()));
                WRRoom.setLevelLimit(int.Parse(Packet.getBlock()));
                WRRoom.setPremiumOnly(int.Parse(Packet.getBlock()));
                WRRoom.setVoteKick(int.Parse(Packet.getBlock()));
                WRRoom.setRoomMaster(Client);

                if (Client.getChannelID() == 1)
                {
                    WRRoom.setRoomMode(0);
                }
                else
                {
                    WRRoom.setRoomMode(7);
                }

                WRRoom.AddPlayer(Client);
                Client.setRoom(WRRoom);
                Program.WRServer.AddRoom(WRRoom, Client.getChannelID());
                Client.Send(new SP_CREATE_ROOM(WRRoom));

             
                foreach (cWRClient _Client in Program.WRServer.getPlayerInChannel(Client.getChannelID()))
                {
                    _Client.Send(new SP_ROOM_LIST(_Client, _Client.getRoomPage()));

                }
            }
            
       
        }
    }

    class CP_LEAVE_ROOM : cClientPacketHandler
    {
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {
            cWRRoom WRRoom = Client.getRoom();
            int oldPlace = WRRoom.getIDOfPlayer(Client);
            int newMaster = -1;
            WRRoom.RemovePlayer(Client);
            Client.setRoom(null);

            if (WRRoom.getPlayers().Count <= 0)
            {
                Program.WRServer.RemoveRoom(WRRoom, Client.getChannelID());
            }
            else
            {
                foreach (cWRClient _Client in WRRoom.getPlayers())
                {
                    newMaster = WRRoom.getIDOfPlayer(_Client);
                    WRRoom.setRoomMaster(_Client);
                    break;
                }
            }

            foreach (cWRClient _Client in WRRoom.getPlayers())
            {
                _Client.Send(new SP_LEAVE_ROOM(Client, WRRoom, oldPlace, newMaster));
            }

            Client.Send(new SP_LEAVE_ROOM(Client, WRRoom, oldPlace, newMaster));

            //Update roominfos to all Players(Das ist nur prowisorisch!!)
            foreach (cWRClient _Client in Program.WRServer.getPlayerInChannel(Client.getChannelID()))
            {
                _Client.Send(new SP_ROOM_LIST(_Client, _Client.getRoomPage()));
                _Client.Send(new SP_ROOMSTATE2(WRRoom));
            }
           
        }
    }

    class CP_ROOM_LIST : cClientPacketHandler
    {
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {
            int Page = int.Parse(Packet.getBlock());
            Client.setRoomPage(Page);
            Client.Send(new SP_ROOM_LIST(Client, Page));
        }
    }

    class CP_PLANT_BOMB : cClientPacketHandler
    {
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {
            cWRRoom WRRoom = Client.getRoom();
            foreach (cWRClient _Client in WRRoom.getPlayers())
            {
            

                _Client.Send(new SP_PLANT_BOMB(0,
                        int.Parse(Packet.getBlockByIndex(0)),
                        int.Parse(Packet.getBlockByIndex(1)),
                        int.Parse(Packet.getBlockByIndex(2)),
                        int.Parse(Packet.getBlockByIndex(3)),
                        int.Parse(Packet.getBlockByIndex(4)),
                        Packet.getBlockByIndex(5),
                        Packet.getBlockByIndex(6),
                        Packet.getBlockByIndex(7),
                        Packet.getBlockByIndex(8), // Value
                        Packet.getBlockByIndex(9), // New Place
                        Packet.getBlockByIndex(10), // Master Place
                        int.Parse(Packet.getBlockByIndex(11))
                  ));
            }
        }
    }


    class CP_JOIN_ROOM : cClientPacketHandler
    {
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {
            int roomID = int.Parse(Packet.getBlock());
            string Password = Packet.getBlock();
            cWRRoom WRRoom = Program.WRServer.getRoomByID(roomID, Client.getChannelID());

            if (WRRoom is cWRRoom && WRRoom.getRoomID() >= 0)
            {
                if (WRRoom.getPassword() != Password)
                {
                    Client.Send(new SP_JOIN_ROOM(SP_JOIN_ROOM.ErrorCodes.InvalidPassword));
                }
                else if (WRRoom.getPremiumOnly() == 1 && Client.getPremium() <= 0)
                {
                    Client.Send(new SP_JOIN_ROOM(SP_JOIN_ROOM.ErrorCodes.OnlyPremium));
                }
                else
                {
                    WRRoom.AddPlayer(Client);
                    Client.setRoom(WRRoom);
                    Client.Send(new SP_JOIN_ROOM(Client, WRRoom));

                    //hypers BOOOOOOSSSLIKE stuff

                    ArrayList PlayerList = new ArrayList();

                    foreach (cWRClient _Client in WRRoom.getPlayers())
                    {
                        PlayerList.Add(_Client);
                        WRRoom.Send(new SP_PLAYER_LIST(_Client, PlayerList));
                        PlayerList.Clear();
                    }


                }
            }
            else
            {
                Client.Send(new SP_JOIN_ROOM(SP_JOIN_ROOM.ErrorCodes.GenericError));
            }
        }
    }

    class CP_CHANGE_ROOM_DATA : cClientPacketHandler
    {
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {
            cWRRoom WRRoom = Client.getRoom();
            int tType = int.Parse(Packet.getBlockByIndex(3));
            int tValue = int.Parse(Packet.getBlockByIndex(6));
            int Value = int.Parse(Packet.getBlockByIndex(9));
            int Place1 = int.Parse(Packet.getBlockByIndex(6));
            int Place2 = int.Parse(Packet.getBlockByIndex(7));
            int Zombie1 = 5;
            int[] Spawn = new int[Packet.Blocks.Length];

   

            switch (tType)
            {
                case 1:

                    tType += 3;
                    tValue = WRRoom.getMapID();
                    WRRoom.setStart();
                    break;
                case 156:
                    {
                        if (WRRoom.Flag[Value] == -1)
                        {
                            Value = Place1 = WRRoom.Flag[Value] = WRRoom.getSide(Client);
                            Client.iFlags++;
                            Client.iPoints += 5;
                        }
                        else
                        {
                            Place1 = WRRoom.Flag[Value] = -1;
                            Value = 0;
                        }
                    }
                    break;

                case 500:
                    {
                        Place2 = (Client.Life-100);
                    }
                    break;
                case 54:
                    {
                        WRRoom.RoomTimeLeft = tValue * 10;
                        //TimeLimitChange
                    }
                    break;
                case 101:
                    {
                        if (Client.Life != 1000 && Client.Life > 0)
                        {
                            Client.Life += 350;
                        }
                        else
                        {
                            Client.Send(new SP_CHAT(Client,SP_CHAT.ChatType.Whisper,"SYSTEM >> Your Life is full You Cant Heal!",Client.getSessionID(),Client.getNickname()));
                        }

                        Place1 = Client.Life;

                    }
                    break;
                case 102:
                    {
                       // Client.Send(new SP_CHAT(Client, SP_CHAT.ChatType.Room_ToAll, "Server >> Repairing: " + tValue + " Other Value: " + Value, 999, "Server"));
                    }
                    break;
                case 402:
                   tType += 1;
                    tValue = 3;
                    Place1 = 882;
                    Value = 1;

                    break;

                case 50: // Ready State
                    if (Client.getReadyState() == 1)
                    {
                        Client.setReadyState(0);
                        tValue = 0;
                    }
                    else
                    {
                        Client.setReadyState(1);
                        tValue = 1;
                    }
                    break;
                case 51: // Map Change
                    WRRoom.setMapID(tValue);
                    break;
                case 52: // Room Mode(Explosive, etc)
                    WRRoom.setRoomMode(tValue);
                    break;
                case 53: // Rounds/Kills
                    WRRoom.setRounds(tValue);
                    break;
                case 59: // ping
                    WRRoom.setPing(tValue);
                    break;
                case 62: // Autostart
                    break;
                case 56: // Change Side
                    Place1 = WRRoom.ChangeSide(Client);
                    Client.RoomSlot = Place1;
                    Place2 = WRRoom.getIDOfPlayer(WRRoom.getRoomMaster());
                    break;
                

                case 150:
                    Client.Life = 1000;
                    Place1 = int.Parse(Packet.getBlockByIndex(7));
                    Place2 = int.Parse(Packet.getBlockByIndex(8));
                    Client.isLiving = true;
                    if (Client.getChannelID() == 4)
                    {
                        Client.getRoom().setWave(0);
                        Client.Send(new SP_ZOMBIE_HANDLE(Client.getRoom().getWave()));
                        Client.getRoom().setWave((Client.getRoom().getWave() + 1));
                        Client.FuckPacket = 1000;
                        Client.getRoom().setZombieStarted(true);
                    }

                    break;
                case 103:
                    // 30000 0 22 2 103 0 1 1 21 0 8 0 8 1 0 0 1259 0 0 4005.1926 136.7833 4191.7803 2.0000 0 11.0000 4.0000 0 DB011199 
                    // 30000 0 22 2 152 0 1 1 21 0 8 0 8 1 0 0 1259 -214 224 4005.1926 136.7833 4191.7803 2.0000 0 11.0000 4.0000 0 DB01 

                    break;
                default:
                    //new cLog(C.MSG_INFO, tType.ToString());
                    break;

            }


            ArrayList Players = WRRoom.getPlayers();
            if (tType != 403 && tType != 103 && tType != 104 && tType != 101 && tType != 400 && tType != 150 && tType != 200)
            {
                foreach (cWRClient _Client in Players)
                {

                    _Client.Send(new SP_CHANGE_ROOM_DATA(tType,
                        int.Parse(Packet.getBlockByIndex(0)),
                        int.Parse(Packet.getBlockByIndex(1)),
                        int.Parse(Packet.getBlockByIndex(2)),
                        int.Parse(Packet.getBlockByIndex(4)),
                        int.Parse(Packet.getBlockByIndex(5)),
                        tValue, // Value
                        Place1, // New Place
                        Place2, // Master Place
                        Value,
                        int.Parse(Packet.getBlockByIndex(10)),
                        int.Parse(Packet.getBlockByIndex(11)),
                        int.Parse(Packet.getBlockByIndex(12)),
                        int.Parse(Packet.getBlockByIndex(13))
                        ));
             
                }
            }
            else if (tType == 104)
            {
              // 30000 0 0 2 104 0 1 1 11 0 11 0 43 2 0 1 100 0 0 3782.3088 218.2119 3739.2190 0 0 13.0000 5.0000 0 DF051299 
              // 30000 0 0 2 104 0 1 1 11 0 11 0 43 2 0 1 100 550 450 3782.3088 218.2119 3739.2190 0 0 13.0000 5.0000 0 DF05 
                foreach (cWRClient _Client in WRRoom.getPlayers())
                {
                    try
                    {

                        _Client.Send(new SP_CHANGE_ROOM_DATA(tType,
                            int.Parse(Packet.getBlockByIndex(0)),
                            int.Parse(Packet.getBlockByIndex(1)),
                            int.Parse(Packet.getBlockByIndex(2)),
                            int.Parse(Packet.getBlockByIndex(4)),
                            int.Parse(Packet.getBlockByIndex(5)),
                            int.Parse(Packet.getBlockByIndex(6)),
                            int.Parse(Packet.getBlockByIndex(7)),
                            int.Parse(Packet.getBlockByIndex(8)),
                            int.Parse(Packet.getBlockByIndex(9)),
                            int.Parse(Packet.getBlockByIndex(10)),
                            int.Parse(Packet.getBlockByIndex(11)),
                            int.Parse(Packet.getBlockByIndex(12)),
                            int.Parse(Packet.getBlockByIndex(13)),
                            int.Parse(Packet.getBlockByIndex(14)),
                            int.Parse(Packet.getBlockByIndex(15)),
                            int.Parse(Packet.getBlockByIndex(16)),
                            int.Parse(Packet.getBlockByIndex(17)),
                            Packet.getBlockByIndex(18), // X
                            Packet.getBlockByIndex(19), // Z
                            Packet.getBlockByIndex(20), // Y
                            Packet.getBlockByIndex(21), // 2.0000
                            int.Parse(Packet.getBlockByIndex(22)),
                            Packet.getBlockByIndex(23), // 93.0000
                            Packet.getBlockByIndex(24), // 1.0000
                            Packet.getBlockByIndex(25), // 0
                           Packet.getBlockByIndex(26)// ITEM
                                                    ));
                    }
                    catch (Exception ex)
                    {
                        new cLog(C.MSG_ERROR, ex.Message);
                    }

                }
            }
            else if (tType == 400)
            {
                foreach (cWRClient _Client in WRRoom.getPlayers())
                {
                    try
                    {
                        _Client.Send(new SP_CHANGE_ROOM_DATA(400,
                          int.Parse(Packet.getBlockByIndex(0)),
                          int.Parse(Packet.getBlockByIndex(1)),
                          int.Parse(Packet.getBlockByIndex(2)),
                          int.Parse(Packet.getBlockByIndex(4)),
                          int.Parse(Packet.getBlockByIndex(5)),
                          int.Parse(Packet.getBlockByIndex(6)),
                          int.Parse(Packet.getBlockByIndex(7)),
                          int.Parse(Packet.getBlockByIndex(8)),
                          int.Parse(Packet.getBlockByIndex(9)),
                          int.Parse(Packet.getBlockByIndex(10)),
                          int.Parse(Packet.getBlockByIndex(11)),
                          int.Parse(Packet.getBlockByIndex(12)),
                          int.Parse(Packet.getBlockByIndex(13)),
                          int.Parse(Packet.getBlockByIndex(14)),
                          int.Parse(Packet.getBlockByIndex(15)),
                          int.Parse(Packet.getBlockByIndex(16)),
                          int.Parse(Packet.getBlockByIndex(17)),
                          Packet.getBlockByIndex(18), // X
                          Packet.getBlockByIndex(19), // Z
                          Packet.getBlockByIndex(20), // Y
                          Packet.getBlockByIndex(21), // 2.0000
                          int.Parse(Packet.getBlockByIndex(22)),
                          Packet.getBlockByIndex(23), // 93.0000
                          Packet.getBlockByIndex(24), // 1.0000
                          Packet.getBlockByIndex(25), // 0
                         Packet.getBlockByIndex(26)// ITEM
                                                  ));
                    }
                    catch
                    {

                    }
                }
            }
            else if (tType == 103)
            {
             //   new cLog(C.MSG_INFO, "Person Damage Packet.");
                foreach (cWRClient _Client in WRRoom.getPlayers())
                {
                    try
                    {
                        if (Client.getChannelID() == 4)
                        {
                            bool able = true;
                            int ObjectID = int.Parse(Packet.getBlockByIndex(7));
                            if (Client.Life < 1) { able = false; }
                            //Client.Send(new SP_CHAT(SP_CHAT.ErrorMessages.MessageX, Client, "ZombieHP: " + WRRoom.RoomZombieHP[ObjectID].ToString() + "!"));
                            if (Client.isLiving && able != false)//Client.isLiving && 
                            {
                                  if (ObjectID == 0)
                                {
                                    Client.Life = (Client.Life - 150);
                                    if (Client.Life < 3)
                                    {
                                        _Client.Send(new SP_CHANGE_ROOM_DATA(152,
                                     int.Parse(Packet.getBlockByIndex(0)),
                                     int.Parse(Packet.getBlockByIndex(1)),
                                     int.Parse(Packet.getBlockByIndex(2)),
                                     int.Parse(Packet.getBlockByIndex(4)),
                                     int.Parse(Packet.getBlockByIndex(5)),
                                     int.Parse(Packet.getBlockByIndex(6)),
                                     int.Parse(Packet.getBlockByIndex(7)),
                                     int.Parse(Packet.getBlockByIndex(8)),
                                     int.Parse(Packet.getBlockByIndex(9)),
                                     int.Parse(Packet.getBlockByIndex(10)),
                                     int.Parse(Packet.getBlockByIndex(11)),
                                     int.Parse(Packet.getBlockByIndex(12)),
                                     int.Parse(Packet.getBlockByIndex(13)),
                                     int.Parse(Packet.getBlockByIndex(14)),
                                     int.Parse(Packet.getBlockByIndex(15)),
                                     Client.Life,
                                     (Client.Life + 150),
                                     Packet.getBlockByIndex(18), // X
                                     Packet.getBlockByIndex(19), // Z
                                     Packet.getBlockByIndex(20), // Y
                                     Packet.getBlockByIndex(21), // 2.0000
                                     int.Parse(Packet.getBlockByIndex(22)),
                                     Packet.getBlockByIndex(23), // 93.0000
                                     Packet.getBlockByIndex(24), // 1.0000
                                     Packet.getBlockByIndex(25), // 0
                                    Packet.getBlockByIndex(26)// ITEM
                                                             ));
                                        Client.isLiving = false;
                                        Client.iDeaths++;
                                    }
                                    else
                                    {
                                        _Client.Send(new SP_CHANGE_ROOM_DATA(103,
                                      int.Parse(Packet.getBlockByIndex(0)),
                                      int.Parse(Packet.getBlockByIndex(1)),
                                      int.Parse(Packet.getBlockByIndex(2)),
                                      int.Parse(Packet.getBlockByIndex(4)),
                                      int.Parse(Packet.getBlockByIndex(5)),
                                      int.Parse(Packet.getBlockByIndex(6)),
                                      int.Parse(Packet.getBlockByIndex(7)),
                                      int.Parse(Packet.getBlockByIndex(8)),
                                      int.Parse(Packet.getBlockByIndex(9)),
                                      int.Parse(Packet.getBlockByIndex(10)),
                                      int.Parse(Packet.getBlockByIndex(11)),
                                      int.Parse(Packet.getBlockByIndex(12)),
                                      int.Parse(Packet.getBlockByIndex(13)),
                                      int.Parse(Packet.getBlockByIndex(14)),
                                      int.Parse(Packet.getBlockByIndex(15)),
                                      Client.Life,
                                      (Client.Life + 150),
                                      Packet.getBlockByIndex(18), // X
                                      Packet.getBlockByIndex(19), // Z
                                      Packet.getBlockByIndex(20), // Y
                                      Packet.getBlockByIndex(21), // 2.0000
                                      int.Parse(Packet.getBlockByIndex(22)),
                                      Packet.getBlockByIndex(23), // 93.0000
                                      Packet.getBlockByIndex(24), // 1.0000
                                      Packet.getBlockByIndex(25), // 0
                                     Packet.getBlockByIndex(26)// ITEM
                                                              ));
                                    }
                                }
                                else
                                {

                                    _Client.Send(new SP_CHANGE_ROOM_DATA(152,
                                    int.Parse(Packet.getBlockByIndex(0)),
                                    int.Parse(Packet.getBlockByIndex(1)),
                                    int.Parse(Packet.getBlockByIndex(2)),
                                    int.Parse(Packet.getBlockByIndex(4)),
                                    int.Parse(Packet.getBlockByIndex(5)),
                                    int.Parse(Packet.getBlockByIndex(6)),
                                    int.Parse(Packet.getBlockByIndex(7)),
                                    int.Parse(Packet.getBlockByIndex(8)),
                                    int.Parse(Packet.getBlockByIndex(9)),
                                    int.Parse(Packet.getBlockByIndex(10)),
                                    int.Parse(Packet.getBlockByIndex(11)),
                                    int.Parse(Packet.getBlockByIndex(12)),
                                    int.Parse(Packet.getBlockByIndex(13)),
                                    int.Parse(Packet.getBlockByIndex(14)),
                                    int.Parse(Packet.getBlockByIndex(15)),
                                    int.Parse(Packet.getBlockByIndex(16)),
                                    int.Parse(Packet.getBlockByIndex(17)),
                                    Packet.getBlockByIndex(18), // X
                                    Packet.getBlockByIndex(19), // Z
                                    Packet.getBlockByIndex(20), // Y
                                    Packet.getBlockByIndex(21), // 2.0000
                                    int.Parse(Packet.getBlockByIndex(22)),
                                    Packet.getBlockByIndex(23), // 93.0000
                                    Packet.getBlockByIndex(24), // 1.0000
                                    Packet.getBlockByIndex(25), // 0
                                   Packet.getBlockByIndex(26)// ITEM
                                                            ));
                                    Client.iKills++;
                                    WRRoom.WaveKills++;
                                    _Client.DoubleKill++;
                                    _Client.TrippleKill++;
                                    if (WRRoom.ActualKills == 1)
                                    {

                                    }
                                    if (_Client.DoubleKill == 2)
                                    {

                                        _Client.DoubleKill = 0;
                                    }
                                    if (_Client.TrippleKill == 3)
                                    {
                                        _Client.TrippleKill = 0;
                                    }
                                }
                                if (Client.isLiving == false)
                                {
                                    Client.Send(new SP_END_OF_GAME(_Client, WRRoom.ActualKills, 1));
                                    WRRoom.ActualKills = 0;
                                    Client.isLiving = false;
                                    Client.Life = 0;
                                    WRRoom.setZombieStarted(false);
                                    WRRoom.setWave(0);
                                }
                            }
                        }
                        else
                        {
                            Client.Life = (Client.Life - 200);
                            if (Client.Life > 5)
                            {
                                _Client.Send(new SP_CHANGE_ROOM_DATA(103,
                                         int.Parse(Packet.getBlockByIndex(0)),
                                         int.Parse(Packet.getBlockByIndex(1)),
                                         int.Parse(Packet.getBlockByIndex(2)),
                                         int.Parse(Packet.getBlockByIndex(4)),
                                         int.Parse(Packet.getBlockByIndex(5)),
                                         int.Parse(Packet.getBlockByIndex(6)),
                                         int.Parse(Packet.getBlockByIndex(7)),
                                         int.Parse(Packet.getBlockByIndex(8)),
                                         int.Parse(Packet.getBlockByIndex(9)),
                                         int.Parse(Packet.getBlockByIndex(10)),
                                         int.Parse(Packet.getBlockByIndex(11)),
                                         int.Parse(Packet.getBlockByIndex(12)),
                                         int.Parse(Packet.getBlockByIndex(13)),
                                         int.Parse(Packet.getBlockByIndex(14)),
                                         int.Parse(Packet.getBlockByIndex(15)),
                                         Client.Life,
                                         (Client.Life + 150),
                                         Packet.getBlockByIndex(18), // X
                                         Packet.getBlockByIndex(19), // Z
                                         Packet.getBlockByIndex(20), // Y
                                         Packet.getBlockByIndex(21), // 2.0000
                                         int.Parse(Packet.getBlockByIndex(22)),
                                         Packet.getBlockByIndex(23), // 93.0000
                                         Packet.getBlockByIndex(24), // 1.0000
                                         Packet.getBlockByIndex(25), // 0
                                        Packet.getBlockByIndex(26)// ITEM
                                                                 ));
                            }
                            else
                            {
                                if (_Client.RoomSlot != Client.RoomSlot)
                                {
                                    //WAIT ITS IMPORTANT

                                    ArrayList PlayerPoints = new ArrayList();
                                    foreach(cWRClient cClient in Client.getRoom().getPlayers())
                                    {
                                        PlayerPoints.Add(cClient.iKills);
                                    }

                                    if (((int)Program.WRServer.GetMaxValue(PlayerPoints)) == 0)
                                    {
                                        WRRoom.Send(new SP_SEND_BADGE()); // FIRST BLOOD :D
                                    }
                                    Client.iKills++;
                                    Client.iPoints += 10;

                                    
                                }
                                _Client.Send(new SP_CHANGE_ROOM_DATA(152,
                                 int.Parse(Packet.getBlockByIndex(0)),
                                 int.Parse(Packet.getBlockByIndex(1)),
                                 int.Parse(Packet.getBlockByIndex(2)),
                                 int.Parse(Packet.getBlockByIndex(4)),
                                 int.Parse(Packet.getBlockByIndex(5)),
                                 int.Parse(Packet.getBlockByIndex(6)),
                                 int.Parse(Packet.getBlockByIndex(7)),
                                 int.Parse(Packet.getBlockByIndex(8)),
                                 int.Parse(Packet.getBlockByIndex(9)),
                                 int.Parse(Packet.getBlockByIndex(10)),
                                 int.Parse(Packet.getBlockByIndex(11)),
                                 int.Parse(Packet.getBlockByIndex(12)),
                                 int.Parse(Packet.getBlockByIndex(13)),
                                 int.Parse(Packet.getBlockByIndex(14)),
                                 int.Parse(Packet.getBlockByIndex(15)),
                                 Client.Life,
                                 (Client.Life + 150),
                                 Packet.getBlockByIndex(18), // X
                                 Packet.getBlockByIndex(19), // Z
                                 Packet.getBlockByIndex(20), // Y
                                 Packet.getBlockByIndex(21), // 2.0000
                                 int.Parse(Packet.getBlockByIndex(22)),
                                 Packet.getBlockByIndex(23), // 93.0000
                                 Packet.getBlockByIndex(24), // 1.0000
                                 Packet.getBlockByIndex(25), // 0
                                Packet.getBlockByIndex(26)// ITEM
                                                         ));
                                
                                //_Client.isLiving = false;
                                _Client.iDeaths++;
                            }
                        }
                    }
                    catch (Exception ex)
                    {
                        new cLog(C.MSG_ERROR, ex.Message);
                    }
                }
            }
            else if (tType == 500)
            {
                foreach (cWRClient _Client in WRRoom.getPlayers())
                {
                    try
                    {
                        //18466636 30000 1 2 0 2 500 0 1 1 2 2 629 1191580 629 371 0 0 0 0 0 0 0 0 0 0 0 0 0 $ 
                        int Damage = int.Parse(Packet.getBlockByIndex(9));
                        Client.Life = (Client.Life - Damage);
                        //F1 F3 F4 F6 F1 E3 x x x x x x x x x E3 C9
                        _Client.Send(new SP_CHANGE_ROOM_DATA(tType,
                        int.Parse(Packet.getBlockByIndex(0)),
                        int.Parse(Packet.getBlockByIndex(1)),
                        int.Parse(Packet.getBlockByIndex(2)),
                        int.Parse(Packet.getBlockByIndex(5)),
                        int.Parse(Packet.getBlockByIndex(6)),
                         int.Parse(Packet.getBlockByIndex(7)),
                        int.Parse(Packet.getBlockByIndex(8)),
                        int.Parse(Packet.getBlockByIndex(9)),
                        int.Parse(Packet.getBlockByIndex(10)),
                        int.Parse(Packet.getBlockByIndex(11)),
                        int.Parse(Packet.getBlockByIndex(12)),
                        Client.Life,
                        int.Parse(Packet.getBlockByIndex(14)),
                        int.Parse(Packet.getBlockByIndex(15)),
                        int.Parse(Packet.getBlockByIndex(16)),
                        int.Parse(Packet.getBlockByIndex(17)),
                        int.Parse(Packet.getBlockByIndex(18)),
                        int.Parse(Packet.getBlockByIndex(19)),
                        int.Parse(Packet.getBlockByIndex(20)),
                        int.Parse(Packet.getBlockByIndex(21)),
                        int.Parse(Packet.getBlockByIndex(22)),
                        int.Parse(Packet.getBlockByIndex(23)),
                        int.Parse(Packet.getBlockByIndex(24)),
                        int.Parse(Packet.getBlockByIndex(25)),
                        int.Parse(Packet.getBlockByIndex(26))
                                                ));
                    }
                    catch
                    {

                    }
                }
            }
            else if (tType == 200)
            {
                foreach (cWRClient _Client in WRRoom.getPlayers())
                {
                    try
                    {
                        int CurrentHP = 2700;
                        int MaxHP = 2700;
                                _Client.Send(new SP_CHANGE_ROOM_DATA(tType,
                                    int.Parse(Packet.getBlockByIndex(0)),
                                    int.Parse(Packet.getBlockByIndex(1)),
                                    int.Parse(Packet.getBlockByIndex(2)),
                                    int.Parse(Packet.getBlockByIndex(4)),
                                    int.Parse(Packet.getBlockByIndex(5)),
                                    int.Parse(Packet.getBlockByIndex(6)),
                                    int.Parse(Packet.getBlockByIndex(7)),
                                   CurrentHP,
                                    MaxHP,
                                   int.Parse(Packet.getBlockByIndex(10)),
                                    int.Parse(Packet.getBlockByIndex(11)),
                                    int.Parse(Packet.getBlockByIndex(12)),
                                    int.Parse(Packet.getBlockByIndex(13)),
                                    int.Parse(Packet.getBlockByIndex(14)),
                                    int.Parse(Packet.getBlockByIndex(15)),
                                    int.Parse(Packet.getBlockByIndex(16)),
                                    int.Parse(Packet.getBlockByIndex(17)),
                                   int.Parse(Packet.getBlockByIndex(18)),
                                   int.Parse(Packet.getBlockByIndex(19)),
                                   int.Parse(Packet.getBlockByIndex(20)),
                                   int.Parse(Packet.getBlockByIndex(21)),
                                   int.Parse(Packet.getBlockByIndex(22)),
                                   int.Parse(Packet.getBlockByIndex(23)),
                                   int.Parse(Packet.getBlockByIndex(24)),
                                   int.Parse(Packet.getBlockByIndex(25)),
                                 Packet.getBlockByIndex(26)// ITEM
                                                    ));
                    }
                    catch (Exception Ex)
                    {
                        Console.WriteLine(Ex);
                    }
                }
            }
            else if (tType == 101)
            {
                foreach (cWRClient _Client in WRRoom.getPlayers())
                {
                    // 30000 0 0 2 101 0 0 0 0 0 0 0 0 0 0 
                    // 30000 0 0 2 101 0 0 0 1000 0 0 0 0 0 0 
                    try
                    {
                        Client.Life = (Client.Life + 310);
                        if (Client.Life > 999)
                        {
                            Client.Life = 1000;
                        }
                        _Client.Send(new SP_CHANGE_ROOM_DATA(tType,
                            int.Parse(Packet.getBlockByIndex(0)),
                            int.Parse(Packet.getBlockByIndex(1)),
                            int.Parse(Packet.getBlockByIndex(2)),
                            int.Parse(Packet.getBlockByIndex(4)),
                            int.Parse(Packet.getBlockByIndex(5)),
                            int.Parse(Packet.getBlockByIndex(6)),
                            Client.Life,
                            int.Parse(Packet.getBlockByIndex(8)),
                            int.Parse(Packet.getBlockByIndex(9)),
                            int.Parse(Packet.getBlockByIndex(10)),
                            int.Parse(Packet.getBlockByIndex(11)),
                            int.Parse(Packet.getBlockByIndex(12)),
                            int.Parse(Packet.getBlockByIndex(13))
                                                    ));
                    }
                    catch
                    {

                    }
                }
            }
            else if (tType == 150)
            {
                // 30000  2 0 2 150 0 1 7 3 2 0 2 4 5 0 0 0 0 0 0 0 0 0 0 0 0 0 ÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿ  
                foreach (cWRClient _Client in WRRoom.getPlayers())
                {
                    try
                    {
                        new cLog(C.MSG_NETWORK, "Player Spawns");
                     // Client.chooseClass = int.Parse(Packet.getBlockByIndex(26));
                       // Client.SpawnPlace1 = int.Parse(Packet.getBlockByIndex(6));
                        _Client.Send(new SP_CHANGE_ROOM_DATA(150,
                                    int.Parse(Packet.getBlockByIndex(0)),
                                    int.Parse(Packet.getBlockByIndex(1)),
                                    int.Parse(Packet.getBlockByIndex(2)),
                                    int.Parse(Packet.getBlockByIndex(4)),
                                    int.Parse(Packet.getBlockByIndex(5)),
                                    int.Parse(Packet.getBlockByIndex(6)),
                                    int.Parse(Packet.getBlockByIndex(7) + new Random().Next(4)),
                                    int.Parse(Packet.getBlockByIndex(8)),
                                    int.Parse(Packet.getBlockByIndex(9)),
                                    int.Parse(Packet.getBlockByIndex(10)),
                                    int.Parse(Packet.getBlockByIndex(11)),
                                    int.Parse(Packet.getBlockByIndex(12)),
                                    int.Parse(Packet.getBlockByIndex(13)),
                                    int.Parse(Packet.getBlockByIndex(14)),
                                    int.Parse(Packet.getBlockByIndex(15)),
                                    int.Parse(Packet.getBlockByIndex(16)),
                                    int.Parse(Packet.getBlockByIndex(17)),
                                   int.Parse(Packet.getBlockByIndex(18)),
                                   int.Parse(Packet.getBlockByIndex(19)),
                                   int.Parse(Packet.getBlockByIndex(20)),
                                   int.Parse(Packet.getBlockByIndex(21)),
                                   int.Parse(Packet.getBlockByIndex(22)),
                                   int.Parse(Packet.getBlockByIndex(23)),
                                   int.Parse(Packet.getBlockByIndex(24)),
                                   int.Parse(Packet.getBlockByIndex(25)),
                                   Packet.getBlockByIndex(26)//trenncode WICHTIG
                                    
                                   ));

                     
               
                                

                        
                            //30000 0 1 2 200 0 1 6 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
                            //30000 1 0 1 2 200 0 1 6 0 3500 3500 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 $ 

                            //30000 0 1 2 200 0 1 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
                            //30000 1 0 1 2 200 0 1 3 0 2500 2500 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 $ 
                        //_Client.Send(new SP_CHANGE_ROOM_DATA(200,
                        //         int.Parse(Packet.getBlockByIndex(0)),
                        //         int.Parse(Packet.getBlockByIndex(1)),
                        //         int.Parse(Packet.getBlockByIndex(2)),
                        //         int.Parse(Packet.getBlockByIndex(4)),
                        //         int.Parse(Packet.getBlockByIndex(5)),
                        //         Client.SpawnPlace1,
                        //         int.Parse(Packet.getBlockByIndex(7)),
                        //         int.Parse(Packet.getBlockByIndex(8)),
                        //         int.Parse(Packet.getBlockByIndex(9)),
                        //         int.Parse(Packet.getBlockByIndex(10)),
                        //         int.Parse(Packet.getBlockByIndex(11)),
                        //         int.Parse(Packet.getBlockByIndex(12)),
                        //         int.Parse(Packet.getBlockByIndex(13)),
                        //         int.Parse(Packet.getBlockByIndex(14)),
                        //         int.Parse(Packet.getBlockByIndex(15)),
                        //         int.Parse(Packet.getBlockByIndex(16)),
                        //         int.Parse(Packet.getBlockByIndex(17)),
                        //         int.Parse(Packet.getBlockByIndex(18)),
                        //         int.Parse(Packet.getBlockByIndex(19)),
                        //         int.Parse(Packet.getBlockByIndex(20)),
                        //         int.Parse(Packet.getBlockByIndex(21)),
                        //         int.Parse(Packet.getBlockByIndex(22)),
                        //         int.Parse(Packet.getBlockByIndex(23)),
                        //         int.Parse(Packet.getBlockByIndex(24)),
                        //         "$"

                        //                                 ));
                    }
                    catch
                    {

                    }
                }
            }
            else if (tType == 902)
            {
                //18134516 30000 0 38 2 902 0 0 0 2 2920 0 0 0 0 0  

                // Just Redicting
                foreach (cWRClient _Client in WRRoom.getPlayers())
                {
                    try
                    {
                        _Client.Send(new SP_CHANGE_ROOM_DATA(tType, int.Parse(Packet.getBlockByIndex(0)),
                        int.Parse(Packet.getBlockByIndex(1)), 
                        int.Parse(Packet.getBlockByIndex(2)),
                        int.Parse(Packet.getBlockByIndex(4)),
                        int.Parse(Packet.getBlockByIndex(5)),
                        int.Parse(Packet.getBlockByIndex(6)),
                        int.Parse(Packet.getBlockByIndex(7)),
                        int.Parse(Packet.getBlockByIndex(8)),
                        int.Parse(Packet.getBlockByIndex(9)),
                        int.Parse(Packet.getBlockByIndex(10)),
                        int.Parse(Packet.getBlockByIndex(11)),
                        int.Parse(Packet.getBlockByIndex(12)),
                        int.Parse(Packet.getBlockByIndex(13)),
                        int.Parse(Packet.getBlockByIndex(14))
                        ));
                        Console.WriteLine("Zombie Dropped Item!");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex);
                    }
                }
            }
            else
            {
                Client.Send(new SP_CHANGE_ROOM_DATA(tType, int.Parse(Packet.getBlockByIndex(0)),
                        int.Parse(Packet.getBlockByIndex(1)),
                        int.Parse(Packet.getBlockByIndex(2)),
                        int.Parse(Packet.getBlockByIndex(4)),
                        int.Parse(Packet.getBlockByIndex(5)),
                        tValue, // Value
                        Place1, // New Place
                        Place2, // Master Place
                        Value,
                        int.Parse(Packet.getBlockByIndex(10)),
                        int.Parse(Packet.getBlockByIndex(11)),
                        int.Parse(Packet.getBlockByIndex(12)),
                        int.Parse(Packet.getBlockByIndex(13))
                        ));
                Client.Send(new SP_PLAYER_NUMBER(Players, WRRoom));

            }
        
        }
    }
    class CP_CREDITS : cClientPacketHandler
    {
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {
            int ErrCode = int.Parse(Packet.getBlock());
            if (ErrCode == 1113)
            {
                Client.Send(new SP_ITEM_SHOP());
            }
        }
    }
    class CP_INVITE : cClientPacketHandler
    {
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {
            string TargetName = Packet.getBlock();
            string Message = Packet.getBlock();
            cWRClient iPlayer = (cWRClient)null;

            if (TargetName == "NULL")
            {
                ArrayList Players = Program.WRServer.getPlayers(false);

                foreach (cWRClient _Client in Players)
                {
                    if (_Client.getChannelID() == Client.getChannelID())
                    {
                        iPlayer = _Client;
                        break;
                    }
                }
            }
            else
            {
                cWRClient tPlayer = Program.WRServer.getPlayerByNickname(TargetName);
                if (tPlayer is cWRClient && tPlayer.getSessionID() > 0)
                {
                    iPlayer = tPlayer;
                }
                else
                {
                    Client.Send(new SP_INVITE(SP_INVITE.ErrorCodes.GenericError));
                }
            }

            if (iPlayer is cWRClient && iPlayer.getSessionID() > 0 && iPlayer.getRoom() == null)
            {
                iPlayer.Send(new SP_INVITE(Client, Message));
                Client.Send(new SP_INVITE(Client, Message));
            }
            else
            {
                Client.Send(new SP_INVITE(SP_INVITE.ErrorCodes.IsPlaying));
            }
        }
    }

    class CP_ROOM_KICK : cClientPacketHandler
    {
        public override void HandlePacket(cClientPacketHandler Packet, cWRClient Client)
        {
            int Place = int.Parse(Packet.getBlock());
            cWRClient tPlayer = Client.getRoom().getPlayerByID(Place);

            if (tPlayer is cWRClient && tPlayer.getSessionID() > 0 && tPlayer.getAccesslevel() != 3)
            {
                tPlayer.Send(new SP_ROOM_KICK(Place));
            }
        }
    }
}


