﻿using System;
using System.Collections;


namespace GameServer
{
    class SP_ISC_LOGIN_PACKET : cServerPacketHandler
    {
        public SP_ISC_LOGIN_PACKET()
        {
            newPacket(1199);
            AddBlock("1"); // 0 = GameServer | 1 = GameServer
            AddBlock(Program.ConfigClass.ISC_Pw); // Auth PW
            AddBlock(Program.ConfigClass.Server_ID);
            AddBlock(Program.ConfigClass.Server_IP);
            AddBlock(Program.ConfigClass.Server_Port);
            AddBlock(Program.ConfigClass.Server_Name);
            AddBlock(77);
        }
    }

    class SP_ISC_PLAYERUPDATE : cServerPacketHandler
    {
        public SP_ISC_PLAYERUPDATE()
        {
            newPacket(5555);
            AddBlock(Program.ConfigClass.Server_ID);
            AddBlock(Program.ConfigClass.CurrentPlayer);
        }
    }

    class SP_WELCOME_PACKET : cServerPacketHandler
    {
        public SP_WELCOME_PACKET()
        {
            newPacket(24832);
            AddBlock(1);
            AddBlock(DateTime.Now.ToString(@"ss\/mm\/HH\/dd\/MM\/110") + "/3/356/0");

        }
    }

    class SP_CHARACTER_INFO : cServerPacketHandler
    {
        public SP_CHARACTER_INFO(cWRClient Client)
        {

            //25088 1 GameServer22 1 22037657 30 4wesome2kill 405721 AwesomeConnection 1 5 0 3 9 -1 0 15 134876 73548 0 107033 2147 2686 0 0 0 0 0 T,T,F,T 
            //DA02,DB01,I009,DR01,I012,I020,^,I016 DA02,DB01,I009,DQ01,I012,I011,^,I023 DA02,DB01,I022,DN01,I005,I004,^,I017 DA02,DB01,DC02,DN01,I013,I004,^,DC04 DA02,DB01,DJ01,DL01,I003,I004,^,I001 DC64-3-0-22020609-0-0-0-0-0-9999-9999,D901-3-0-12071114-0-0-0-0-0-9999-9999,^,DJ03-1-1-12050413-0-0-0-0-0,DS01-3-0-22013014-0-0-0-0-0-9999-9999,DO01-3-0-22013014-0-0-0-0-0-9999-9999,DG01-1-3-12051506-0-0-0-0-0,D902-3-0-12091217-0-0-0-0-0-9999-9999,DU02-3-3-12050214-0-0-0-0-0-0-0,DF05-1-3-12051912-0-0-0-0-0,^,DV01-3-0-22043014-0-0-0-0-0-9999-9999,DF04-3-0-22030914-0-0-0-0-0-9999-9999,DC31-3-0-22021412-0-0-0-0-0-9999-9999,^,CA04-3-0-16061015-0-0-0-0-0-9999-9999,D501-3-0-13022615-0-0-0-0-0-9999-9999,D701-3-0-13032815-0-0-0-0-0-9999-9999,^,^,DU01-3-0-22031115-0-0-0-0-0-9999-9999,CC05-3-0-12051214-0-0-0-0-0-9999-9999,DG40-3-0-12050818-0-0-0-0-0-9999-9999,D602-3-0-13070218-0-0-0-0-0-9999-9999,CD01-3-0-12051214-0-0-0-0-0-9999-9999,CD02-3-0-12051214-0-0-0-0-0-9999-9999,^,^,^,^ BA01,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ BA02,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ BA03,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ BA04,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ BA05,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ ^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ 0 1 

            //967231963 25088 1 GameServer36 45[SESSION] 98 45[SESSION] LuTrattore -1 NULL -1 -1 0 0 0 -1 0 0 0 0 0 1000000 0 0 0 0 0 0 0 T,T,F,F DA02,DB01,DF01,DR01,^,^,^,^ DA02,DB01,DF01,DQ01,^,^,^,^ DA02,DB01,DG05,DN01,^,^,^,^ DA02,DB01,DC02,DN01,^,^,^,^ DA02,DB01,DJ01,DL01,^,^,^,^ ^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ BA11,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ BA12,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ BA13,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ BA14,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ BA15,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ ^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ 0 0 0 Mankej_12@o2.pl  

            //963966232 25088 1 GameServer36 1 4308 1 xlExcept1oN -1 NULL -1 -1 0 0 0 -1 0 0 25884 0 0 1004217 47 84 0 0 0 0 0 T,F,F,F DA02,I006,I005,DR01,I004,I003,^,^ DA02,I006,I017,DQ01,I018,I014,^,^ DA02,I006,I008,DN01,I009,I002,^,^ DA02,I006,I011,DN01,I000,I002,^,^ DA02,I006,DJ01,DL01,I010,I002,^,^ DC12-1-3-12082921-0-0-0-0-0,DC04-1-3-12082921-0-0-0-0-0,DS03-1-1-12080621-0-0-0-0-0,DU01-1-1-12080621-0-0-0-0-0,DF13-1-3-12082921-0-0-0-0-0,DD03-1-3-12082921-0-0-0-0-0,DB08-1-3-12082921-0-0-0-0-0,DG10-1-3-12083008-0-0-0-0-0,DG08-1-3-12083008-0-0-0-0-0,DG19-1-3-12083008-0-0-0-0-0,DT06-1-1-12080708-0-0-0-0-0,DC05-1-3-12083008-0-0-0-0-0,DF06-1-3-12083009-0-0-0-0-0,DF11-1-3-12083009-0-0-0-0-0,DV01-1-1-12080709-0-0-0-0-0,DF10-1-3-12083009-0-0-0-0-0,D101-1-1-12080709-0-0-0-0-0,DF05-1-3-12083009-0-0-0-0-0,DF07-1-3-12083009-0-0-0-0-0,^,^,^,^,^,^,^,^,^,^,^ BA11,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ BA12,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ BA13,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ BA14,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ BA15,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ ^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ 0 0 0 Mankej_12@o2.pl  

            newPacket(25088);
            AddBlock(1);
            AddBlock("GameServer" + Program.ConfigClass.Server_ID.ToString());
            AddBlock(Client.getSessionID());
            AddBlock(Client.getUserID());
            AddBlock(Client.getSessionID());
            AddBlock(Client.getNickname());
            //Clan
            if (Client.getAccesslevel() > 1)
            {
                AddBlock(405721);
                AddBlock("Insomnia_Team");
                AddBlock(1);
                AddBlock(5);
            }
            else
            {
                AddBlock(5);
                AddBlock("NULL");
                AddBlock(1);
                AddBlock(5);
            }
            //END Clan
            AddBlock(0);
            AddBlock(Client.getPremium());
            AddBlock(0);
            AddBlock(-1);
            AddBlock(0);
            AddBlock(0);
            AddBlock(Client.getExp());
            AddBlock(0);
            AddBlock(0);
            AddBlock(Client.getDinar());
            AddBlock(Client.getKills());
            AddBlock(Client.getDeaths());
            AddBlock(0);
            AddBlock(0);
            AddBlock(0);
            AddBlock(0);
            AddBlock(0);
            AddBlock("T,T,F,T");

            string WeaponE = "";
            string WeaponM = "";
            string WeaponS = "";
            string WeaponA = "";
            string WeaponH = "";


            foreach (cWRClient.tItem pItem in Client.getItems())
            {

                switch (pItem.SlotEngineer)
                {
                    case 0: Client.slot1E = pItem.itemCode; break;
                    case 1: Client.slot2E = pItem.itemCode; break;
                    case 2: Client.slot3E = pItem.itemCode; break;
                    case 3: Client.slot4E = pItem.itemCode; break;
                    case 4: Client.slot5E = pItem.itemCode; break;
                    case 5: Client.slot6E = pItem.itemCode; break;
                    case 6: Client.slot7E = pItem.itemCode; break;
                    case 7: Client.slot8E = pItem.itemCode; break;
                }
                switch (pItem.SlotMedic)
                {
                    case 0: Client.slot1M = pItem.itemCode; break;
                    case 1: Client.slot2M = pItem.itemCode; break;
                    case 2: Client.slot3M = pItem.itemCode; break;
                    case 3: Client.slot4M = pItem.itemCode; break;
                    case 4: Client.slot5M = pItem.itemCode; break;
                    case 5: Client.slot6M = pItem.itemCode; break;
                    case 6: Client.slot7M = pItem.itemCode; break;
                    case 7: Client.slot8M = pItem.itemCode; break;
                }
                switch (pItem.SlotSniper)
                {
                    case 0: Client.slot1S = pItem.itemCode; break;
                    case 1: Client.slot2S = pItem.itemCode; break;
                    case 2: Client.slot3S = pItem.itemCode; break;
                    case 3: Client.slot4S = pItem.itemCode; break;
                    case 4: Client.slot5S = pItem.itemCode; break;
                    case 5: Client.slot6S = pItem.itemCode; break;
                    case 6: Client.slot7S = pItem.itemCode; break;
                    case 7: Client.slot8S = pItem.itemCode; break;
                }
                switch (pItem.SlotAssault)
                {
                    case 0: Client.slot1A = pItem.itemCode; break;
                    case 1: Client.slot2A = pItem.itemCode; break;
                    case 2: Client.slot3A = pItem.itemCode; break;
                    case 3: Client.slot4A = pItem.itemCode; break;
                    case 4: Client.slot5A = pItem.itemCode; break;
                    case 5: Client.slot6A = pItem.itemCode; break;
                    case 6: Client.slot7A = pItem.itemCode; break;
                    case 7: Client.slot8A = pItem.itemCode; break;
                }
                switch (pItem.SlotHeavyTrooper)
                {
                    case 0: Client.slot1H = pItem.itemCode; break;
                    case 1: Client.slot2H = pItem.itemCode; break;
                    case 2: Client.slot3H = pItem.itemCode; break;
                    case 3: Client.slot4H = pItem.itemCode; break;
                    case 4: Client.slot5H = pItem.itemCode; break;
                    case 5: Client.slot6H = pItem.itemCode; break;
                    case 6: Client.slot7H = pItem.itemCode; break;
                    case 7: Client.slot8H = pItem.itemCode; break;

                }

            }

            WeaponE = Client.slot1E + "," + Client.slot2E + "," + Client.slot3E + "," + Client.slot4E + "," + Client.slot5E + "," + Client.slot6E + "," + Client.slot7E + "," + Client.slot8E + ",^,^";
            WeaponM = Client.slot1M + "," + Client.slot2M + "," + Client.slot3M + "," + Client.slot4M + "," + Client.slot5M + "," + Client.slot6M + "," + Client.slot7M + "," + Client.slot8M + ",^,^";
            WeaponS = Client.slot1S + "," + Client.slot2S + "," + Client.slot3S + "," + Client.slot4S + "," + Client.slot5S + "," + Client.slot6S + "," + Client.slot7S + "," + Client.slot8S + ",^,^";
            WeaponA = Client.slot1A + "," + Client.slot2A + "," + Client.slot3A + "," + Client.slot4A + "," + Client.slot5A + "," + Client.slot6A + "," + Client.slot7A + "," + Client.slot8A + ",^,^";
            WeaponH = Client.slot1H + "," + Client.slot2H + "," + Client.slot3H + "," + Client.slot4H + "," + Client.slot5H + "," + Client.slot6H + "," + Client.slot7H + "," + Client.slot8H + ",^,^";

            AddBlock(WeaponE);//scheis noooooobs -.-
            AddBlock(WeaponM);
            AddBlock(WeaponS);
            AddBlock(WeaponA);
            AddBlock(WeaponH);

            string Items = "";

            foreach (cWRClient.tItem pItem in Client.getItems())
            {
                Items += pItem.itemCode + "-3-0-" + pItem.expireDate.ToString() + "-0-0-0-0-0-9999-9999,";
            }

            for (int i = 0; i < (31 - Client.getItems().Count); i++)
            {
                Items += "^,";
            }

            Items = Items.Substring(0, Items.Length - 1);

            AddBlock(Items); // Inventory (Weapons/PX-Items)

            //BA11,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ BA12,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ BA13,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ BA14,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ BA15,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ ^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ 0 

            string CostumeE = "BA11,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^";
            string CostumeM = "BA12,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^";
            string CostumeS = "BA13,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^";
            string CostumeA = "BA14,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^";
            string CostumeH = "BA15,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^";

            string CostumeInventory = "^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^";

            AddBlock(CostumeE);
            AddBlock(CostumeM);
            AddBlock(CostumeS);
            AddBlock(CostumeA);
            AddBlock(CostumeH);

            AddBlock(CostumeInventory);

            AddBlock(0);
            AddBlock(1); // 0 = No Zombie 1 = All Channel 2 = Only Zombie all above = Fucked
            AddBlock(0);
            // works now!

             AddBlock("YouAreAnFucking@sniffer.STFU#21");
        }
    }

    class SP_ITEM_SHOP : cServerPacketHandler
    {
        public SP_ITEM_SHOP()
        {
            newPacket(30720);
            AddBlock(1113);
            AddBlock(1);
            AddBlock(10000);
        }
    }
    class SP_LUCKY_SHOT : cServerPacketHandler
    {


        public SP_LUCKY_SHOT()
        {
            //500792453 30257 7 1 DC67 0 18 1 DF17 0 18 1 DC68 0 12 1 DG23 0 12 1 DG24 0 18 0 DA09 6523 1200 0 DA08 1335 1000 
            newPacket(30257);
            AddBlock(8); // HowMuch
            AddBlock(1); // Dinar / G1
            AddBlock("DC67"); // Arma
            AddBlock(1000); // Dinari
            AddBlock(20); // Quantità
            /////////////////////////////////////
            AddBlock(1); // Dinar / G1
            AddBlock("DF17"); // Arma
            AddBlock(1000); // Dinari
            AddBlock(20); // Quantità
            /////////////////////////////////////
            AddBlock(1); // Dinar / G1
            AddBlock("DC68"); // Arma
            AddBlock(1000); // Dinari
            AddBlock(20); // Quantità
            /////////////////////////////////////
            AddBlock(1); // Dinar / G1
            AddBlock("DG23"); // Arma
            AddBlock(1000); // Dinari
            AddBlock(20); // Quantità
            /////////////////////////////////////
            AddBlock(1); // Dinar / G1
            AddBlock("DG24"); // Arma
            AddBlock(1000); // Dinari
            AddBlock(20); // Quantità
            /////////////////////////////////////
            AddBlock(0); // Dinar / G1
            AddBlock("DA09"); // Arma
            AddBlock(2000); // Dinari
            AddBlock(1200); // Quantità
            /////////////////////////////////////
            AddBlock(0); // Dinar / G1
            AddBlock("DA08"); // Arma
            AddBlock(2000); // Dinari
            AddBlock(1200); // Quantità
            /////////////////////////////////////
            AddBlock(0); // Dinar / G1 
            AddBlock("DC64"); // Arma Italian hahaha :D arma = weapon
            AddBlock(2000); // Dinari dinari = dinars
            AddBlock(1200); // Quantità quantità = muchs
            /////////////////////////////////////

            //table luckyshot_tbl itemcode,count,price
        }
        public SP_LUCKY_SHOT(cWRClient Client, int Bets, string Item, int win)
        {
            // 736644874 30258 1 0 0 DF05 3 DF05-1-0-12050509-0-0-0-0-0,DB12-1-0-12042717-0-0-0-0-0,DG07-1-0-12042717-0-0-0-0-0,DB02-1-0-12051313-0-0-0-0-0,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ 277243 F,F,F,F
            //1077463421 30258 1 1 0 DA09 7 DC64-3-0-22020609-0-0-0-0-0-9999-9999,D901-3-0-12071114-0-0-0-0-0-9999-9999,DA09-1-1-12050809-0-0-0-0-0,DJ03-1-1-12050413-0-0-0-0-0,DS01-3-0-22013014-0-0-0-0-0-9999-9999,DO01-3-0-22013014-0-0-0-0-0-9999-9999,DG01-1-3-12051506-0-0-0-0-0,D902-3-0-12091217-0-0-0-0-0-9999-9999,DU02-3-3-12050214-0-0-0-0-0-0-0,DF05-1-3-12051912-0-0-0-0-0,^,DV01-3-0-22043014-0-0-0-0-0-9999-9999,DF04-3-0-22030914-0-0-0-0-0-9999-9999,DC31-3-0-22021412-0-0-0-0-0-9999-9999,^,CA04-3-0-16061015-0-0-0-0-0-9999-9999,D501-3-0-13022615-0-0-0-0-0-9999-9999,D701-3-0-13032815-0-0-0-0-0-9999-9999,^,^,DU01-3-0-22031115-0-0-0-0-0-9999-9999,CC05-3-0-12051214-0-0-0-0-0-9999-9999,DG40-3-0-12050818-0-0-0-0-0-9999-9999,D602-3-0-13070218-0-0-0-0-0-9999-9999,CD01-3-0-12051214-0-0-0-0-0-9999-9999,CD02-3-0-12051214-0-0-0-0-0-9999-9999,^,^,^,^ 101033 T,T,F,T 

            newPacket(30258);
            AddBlock(1);
            AddBlock(win);
            AddBlock(0);
            AddBlock(Item);
            AddBlock(Bets);
            string Items = "";
            Items += Item + "-3-0-22020609-0-0-0-0-0-9999-9999,";
            foreach (cWRClient.tItem pItem in Client.getItems())
            {
                Items += pItem.itemCode + "-3-0-" + pItem.expireDate.ToString() + "-0-0-0-0-0-9999-9999,";
            }

            for (int i = 0; i < (31 - Client.getItems().Count); i++)
            {
                Items += "^,";
            }

            Items = Items.Substring(0, Items.Length - 1);

            AddBlock(Items); // Inventory (Weapons/PX-Items)
            AddBlock(Client.getDinar());
            AddBlock("T,T,F,T");


        }
    }

    class SP_COUPON : cServerPacketHandler
    {
        public SP_COUPON(cWRClient Client, int ErrorCode, string CouponID)
        {

            newPacket(30992);
            AddBlock(CouponID);
            AddBlock(0);
        }
    }

    class SP_CHG_NICK : cServerPacketHandler
    {

        public SP_CHG_NICK(cWRClient Client, string nickname)
        {
            newPacket(30720);
            AddBlock(1111);
            AddBlock(4);
            AddBlock(20);
            AddBlock("CB01");
            AddBlock(Client.getNickname());
        }
    }
    class SP_DELETE_WEAPON : cServerPacketHandler
    {
        public SP_DELETE_WEAPON(cWRClient Client, string WeaponCode)
        {
            //30224 DB04 10 
            //30224 1 DB04 DC64-3-0-22020609-0-0-0-0-0-9999-9999,D901-3-0-12071114-0-0-0-0-0-9999-9999,DA09-1-1-12050809-0-0-0-0-0,DJ03-1-1-12050413-0-0-0-0-0,DS01-3-0-22013014-0-0-0-0-0-9999-9999,DO01-3-0-22013014-0-0-0-0-0-9999-9999,DG01-1-3-12051506-0-0-0-0-0,D902-3-0-12091217-0-0-0-0-0-9999-9999,DU02-3-3-12050214-0-0-0-0-0-0-0,DF05-1-3-12051912-0-0-0-0-0,^,DV01-3-0-22043014-0-0-0-0-0-9999-9999,DF04-3-0-22030914-0-0-0-0-0-9999-9999,DC31-3-0-22021412-0-0-0-0-0-9999-9999,^,CA04-3-0-16061015-0-0-0-0-0-9999-9999,D501-3-0-13022615-0-0-0-0-0-9999-9999,D701-3-0-13032815-0-0-0-0-0-9999-9999,^,^,DU01-3-0-22031115-0-0-0-0-0-9999-9999,CC05-3-0-12051214-0-0-0-0-0-9999-9999,DG40-3-0-12050818-0-0-0-0-0-9999-9999,D602-3-0-13070218-0-0-0-0-0-9999-9999,CD01-3-0-12051214-0-0-0-0-0-9999-9999,CD02-3-0-12051214-0-0-0-0-0-9999-9999,^,^,^,^ T,T,F,T DA02,DB01,I009,DR01,I012,I020,^,I016 DA02,DB01,I009,DQ01,I012,I011,^,I023 DA02,DB01,I022,DN01,I005,I004,^,I017 DA02,DB01,DC02,DN01,I013,I004,^,DC04 DA02,DB01,DJ01,DL01,I003,I004,^,I001 
            newPacket(30224);
            AddBlock(1);
            AddBlock(WeaponCode);
            string Items = "";
            foreach (cWRClient.tItem pItem in Client.getItems())
            {
                Items += pItem.itemCode + "-3-0-" + pItem.expireDate.ToString() + "-0-0-0-0-0-9999-9999,";
            }

            for (int i = 0; i < (31 - Client.getItems().Count); i++)
            {
                Items += "^,";
            }

            Items = Items.Substring(0, Items.Length - 1);

            AddBlock(Items); // Inventory (Weapons/PX-Items)
        }
    }
    class SP_COUPON_EVENT : cServerPacketHandler
    {
        public SP_COUPON_EVENT(cWRClient _Client)
        {
            //499110624 25605 0 0 13 0 0 0-0-0 
            newPacket(25605);
            AddBlock(0);
            AddBlock(0);
            AddBlock(_Client.getCoupons());
            AddBlock(0);
            AddBlock(0);
            AddBlock("0-0-0");
        }
    }
    class SP_COUPON_BUY : cServerPacketHandler
    {
        public SP_COUPON_BUY(string WeaponCode, cWRClient _Client)
        {
            //500787421 25606 0 F,F,F,F DF05-1-0-12050209-0-0-0-0-0,DB12-1-0-12042717-0-0-0-0-0,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ ^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^ 298903 0 8 

            newPacket(25606);
            AddBlock(0);
            AddBlock("T,T,F,T");
            string Items = "";
            Items += WeaponCode + "-3-0-12050209-0-0-0-0-0-9999-9999,";
            foreach (cWRClient.tItem pItem in _Client.getItems())
            {
                Items += pItem.itemCode + "-3-0-" + pItem.expireDate.ToString() + "-0-0-0-0-0-9999-9999,";
            }

            for (int i = 0; i < (31 - _Client.getItems().Count); i++)
            {
                Items += "^,";
            }

            Items = Items.Substring(0, Items.Length - 1);
            AddBlock("^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^,^");
            AddBlock(_Client.getDinar());
            AddBlock(0);
            AddBlock(_Client.getCoupons());



        }
    }

    class SP_LEAVE_SERVER : cServerPacketHandler
    {
        public SP_LEAVE_SERVER()
        {
            newPacket(24576);
            AddBlock(0);
        }
    }
    class SP_PREMIUM_LEFT : cServerPacketHandler
    {
        public SP_PREMIUM_LEFT(cWRClient Client)
        {
            newPacket(25600);
            //25600 5000 175 0 -1 4 0 0 2686060 150 
            AddBlock(5000);
            AddBlock(0);
            AddBlock(0);
            AddBlock(175);
            AddBlock(0);
            AddBlock(-1);
            AddBlock(4);
            AddBlock(0);
            AddBlock(0);
            AddBlock(Client.getPremiumLeftTime());
            AddBlock(150);
        }
    }

    class SP_CHANGE_CHANNEL : cServerPacketHandler
    {
        public SP_CHANGE_CHANNEL(cWRClient Client)
        {
            newPacket(28673);
            AddBlock(1);
            AddBlock(Client.getChannelID());
        }
    }

    class SP_CHAT : cServerPacketHandler
    {
        public enum ChatType : int
        {
            Notice1 = 1,
            Notice2,
            Lobby_ToChannel,
            Room_ToAll,
            Room_ToTeam,
            Whisper,
            Lobby_ToAll = 8,
            Clan
        }

        public enum ErrorCodes : int
        {
            ErrorUser = 95040
        }

        public SP_CHAT(int wayne, int wayne2, int wayne3)
        {
            DateTime time = new DateTime();
            time = DateTime.Now;
            //29696 1 -1 SYSTEM 4 998 NULL SYSTEM>>CurrentServer-Time:23.Apr2012,21:17GMT+02
            newPacket(29696);
            AddBlock(1);
            AddBlock(-1);
            AddBlock("SYSTEM");
            AddBlock(4);
            AddBlock(998);
            AddBlock("NULL");
            AddBlock("SYSTEM >> Current ServerTime: " + time.Date.Day + "." + time.Date.Month + "." + time.Date.Year + ", " + time.Hour + ":" + time.Minute + " GMT+02");
            AddBlock("SYSTEM >> Please check our website for new updates.");
            foreach (cWRClient _Client in Program.WRServer.getAllPlayers())
            {
                _Client.Send(new SP_CHAT(_Client, SP_CHAT.ChatType.Notice1, "SYSTEM >> " + _Client.getNickname() + " logged in on server. Visit wWw.InsomniaProject.Tk", 100, "SYSTEM"));
            }
        }

        public SP_CHAT(int xD, int xD2, int xD3, int xD4, int ChannelID)
        {
            //29696 1 -1 SYSTEM 4 998 NULL SYSTEM>>Welcome<[GM]UnknownHype>!
            newPacket(29696);
            AddBlock(1);
            AddBlock(-1);
            AddBlock("SYSTEM");
            AddBlock(4);
            AddBlock(998);
            AddBlock("NULL");
            string ChanneltoGo = "";
            if (ChannelID == 1)
            {
                ChanneltoGo = "Closer Quarter Combat";
            }
            else if (ChannelID == 2)
            {
                ChanneltoGo = "Urban Ops";
            }
            else if (ChannelID == 3)
            {
                ChanneltoGo = "Battle Group";
            }
            AddBlock("SYSTEM >> Sorry " + ChanneltoGo + " isn't ready yet.");
        }
   
        public SP_CHAT(int wayne, int wayne2, int wayne3, int wayne4)
        {
            DateTime time = new DateTime();
            time = DateTime.Now;
            //29696 1 -1 SYSTEM 4 998 NULL SYSTEM>>CurrentServer-Time:23.Apr2012,21:17GMT+02
            newPacket(29696);
            AddBlock(1);
            AddBlock(-1);
            AddBlock("SYSTEM");
            AddBlock(4);
            AddBlock(998);
            AddBlock("NULL");
            AddBlock("SYSTEM >> Server is Going down in : " + wayne4);
        }
        public SP_CHAT(cWRClient Client, ChatType Type, string Message, long TargetID, string TargetName)
        {

            newPacket(29696);
            AddBlock(1);
            AddBlock(Client.getSessionID());
            AddBlock(Client.getNickname());
            AddBlock((int)Type);
            AddBlock(TargetID);
            AddBlock(TargetName);
            AddBlock(Message);
        }

        public SP_CHAT(ErrorCodes ErrCode, params object[] Params)
        {
            newPacket(29696);
            AddBlock((int)ErrCode);
            for (int i = 0; i < Params.Length; i++)
            {
                AddBlock(Params[i]);
            }
        }
    }
    class SP_ZOMBIE_HANDLE : cServerPacketHandler
    {
        public SP_ZOMBIE_HANDLE()
        {
            // WAVE_STATE
            newPacket(13431);
            AddBlock(1);
            AddBlock(13);
            AddBlock(0);
            AddBlock(0);
        }
        public SP_ZOMBIE_HANDLE(int Wave)
        {
            // WAVE_STATE
            // 591259937 13431 1 13 3 0 
            //13431 1 13 0 0
            newPacket(13431);
            AddBlock(1);
            AddBlock(13);
            AddBlock(Wave);
            AddBlock(0);
        }
    }
    class SP_SEND_BADGE : cServerPacketHandler
    {
        public SP_SEND_BADGE()
        {
            //25594627 31264 8 30 30 999212 242 57 0  
            newPacket(31264);
            AddBlock(9);
            AddBlock(1);
        }
    }
    class SP_SEND_DOUBLE : cServerPacketHandler
    {
        public SP_SEND_DOUBLE()
        {
            //25594627 31264 8 30 30 999212 242 57 0  
            newPacket(31264);
            AddBlock(9);
            AddBlock(2);
        }
    }
    class SP_SEND_TRIPPLE : cServerPacketHandler
    {
        public SP_SEND_TRIPPLE()
        {
            //25594627 31264 8 30 30 999212 242 57 0  
            newPacket(31264);
            AddBlock(9);
            AddBlock(3);
        }
    }

    class SP_USER_LIST : cServerPacketHandler
    {
        public SP_USER_LIST(ArrayList PlayerList)
        {
            //25594750 28960 3 -1 SYSTEM 0 -1 100 0 -1 0 2 [GM]Horiiizon 3 7206 56 4 -1 -1 11 [GM]UnknownHype 3 7206 1 4 -1 -1  

            //18409842 28960 1  78 supreme1337 3 -1 2 1 -1 -1 

            newPacket(28960);
            AddBlock(PlayerList.Count);

            foreach (cWRClient _Client in PlayerList)
            {
                AddBlock(_Client.getUserID());
                AddBlock(_Client.getNickname());
                AddBlock(_Client.getPremium());
                if (_Client.getAccesslevel() > 1)
                {
                    AddBlock(405721); // Clan
                }
                else
                {
                    AddBlock(5);//can i make an acc pls?
                }
                AddBlock(_Client.getLevel());
                AddBlock(_Client.getChannelID());
                if (_Client.getRoom() == null)
                {
                    AddBlock(-1); // -1 = Lobby
                }
                else
                {
                    AddBlock(_Client.getRoom().getRoomID());
                }
                AddBlock(-1);
            }
        }
    }

    class SP_CHANGE_WEAPON : cServerPacketHandler
    {
        public SP_CHANGE_WEAPON(int _Class, string Items)
        {
            //1115603592 29970 1 1 DA02,I003,I000,DQ01,^,I006,^,I005
            newPacket(29970);
            AddBlock(1);
            AddBlock(_Class);
            AddBlock(Items);



        }
    }


    class SP_BUY_WEAPON : cServerPacketHandler
    {
        public SP_BUY_WEAPON(cWRClient Client, int ErrorCode, long Dinar, string Waffenstring)
        {


            newPacket(30208);
            AddBlock(ErrorCode);
            AddBlock(1110);
            if (ErrorCode == 1)
            {
                AddBlock(-1);
                AddBlock(3);
                AddBlock(4);//nochmal nachschauen :)
                AddBlock(Waffenstring);
                AddBlock(Dinar);
                AddBlock("F,F,F,F");

                Program.SQLClass.runSQL("UPDATE ACCOUNT_TBL_DETAIL SET dinar = '" + Dinar + "' WHERE userID = '" + Client.getUserID().ToString() + "'").ToString();

            }


        }
    }

    class SP_CREATE_ROOM : cServerPacketHandler
    {
        public SP_CREATE_ROOM(cWRRoom Room)
        {
            newPacket(29440);
            AddBlock(1);
            AddBlock(0);
            AddRoomInfo(Room);
        }
    }

    class SP_LEAVE_ROOM : cServerPacketHandler
    {
        public SP_LEAVE_ROOM(cWRClient Client, cWRRoom Room, int oldPlace, int newMaster)
        {
            newPacket(29504);
            AddBlock(1);
            AddBlock(Client.getSessionID());
            AddBlock(oldPlace); // Position in Room
            AddBlock(0); // ?
            AddBlock(newMaster);
            AddBlock(Client.getExp());
            AddBlock(Client.getDinar());
        }
    }
    class SP_ROOMSTATE2 : cServerPacketHandler
    {
        public SP_ROOMSTATE2(cWRRoom WRRoom)
        {

            newPacket(29200);
            //18659662 29200 0 1 0 1 1 -1 Go!Go!Go! 0 32 0 27 0 2 4 2 4 0 3 0 0 0 0 1 0 34 0 -1  
            AddBlock(WRRoom.getRoomID());
            AddBlock(1);
            AddBlock(WRRoom.getRoomID());
            AddBlock(WRRoom.getRoomStatus());
            AddBlock(WRRoom.getRoomStatus());
            AddBlock(WRRoom.getIDOfPlayer(WRRoom.getRoomMaster()));
            AddBlock(WRRoom.getRoomName());
            AddBlock(WRRoom.HasPassword());
            AddBlock(WRRoom.getMaxPlayer());//das haben wir doch alles rausgfunden undjetzt nur noch neues packet anlegen ...^^
            AddBlock(WRRoom.getPlayers().Count);
            AddBlock(WRRoom.getMapID());
            AddBlock(3);
            AddBlock(2);
            AddBlock(0);
            AddBlock(WRRoom.getRoomMode());
            AddBlock(4);
            AddBlock(1);
            AddBlock(0);
            AddBlock(0);//Supermaster ->1
            AddBlock(WRRoom.getRoomType()); //Knife (2 ->Knife only)
            AddBlock(WRRoom.getLevelLimit());
            AddBlock(WRRoom.getPremiumOnly());// ??
            AddBlock(WRRoom.getVoteKick());
            AddBlock(0); // autostart
            AddBlock(46);
            AddBlock(WRRoom.getPing());
            AddBlock(-1);

        }
    }

    class SP_SPAWN_PLAYER : cServerPacketHandler
    {
        public SP_SPAWN_PLAYER()
        {
            // 30000 1 0 16 2 150 0 1 2 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 ÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿÿ 
        }
    }
    class SP_SpawnCount : cServerPacketHandler
    {
        public SP_SpawnCount(cWRClient Client)
        {
            ////486669374 30016 -1 1000 0 2 0 30 
            newPacket(30016);

            if (Client.getChannelID() == 4)
            {
                AddBlock(-1);
                AddBlock(Client.FuckPacket);
                if (Client.getRoom() != null)
                {
                    if (Program.ConfigClass.iZombieEvent == 1)
                    {
                        AddBlock((Client.getRoom().ActualKills * 100));
                    }
                    else
                    {
                        AddBlock((Client.getRoom().ActualKills * 2));
                    }

                }
                else
                {
                    AddBlock(0);
                }
                AddBlock(2);
                AddBlock(30);
                Client.FuckPacket += 1000;
            }
            else
            {
                AddBlock(Client.FuckPacket);
                AddBlock(Client.FuckPacket2);
                ArrayList PlayerPoints = new ArrayList();
                if (Client.getRoom() != null)
                {
                    foreach (cWRClient cClient in Client.getRoom().getPlayers())
                    {
                        PlayerPoints.Add(cClient.iKills);
                    }
                    AddBlock(Program.WRServer.GetMaxValue(PlayerPoints)); // BEst
                }
                else
                {
                    AddBlock(0);
                }
                
                AddBlock(Client.iKills); // ME
                AddBlock(1);
                AddBlock(1);
                AddBlock(2);
                AddBlock(0);
                AddBlock(30);
                Client.FuckPacket += 2000;
                Client.FuckPacket2 -= 2000;
            }


        }
    }
    class SP_ROOM_LIST : cServerPacketHandler
    {
        public SP_ROOM_LIST(cWRClient Client, int Page)
        {
            newPacket(29184);
            ArrayList Rooms = Program.WRServer.getRoomsInChannel(Client.getChannelID());

            AddBlock(Rooms.Count);
            AddBlock(Page);
            AddBlock(0);

            foreach (cWRRoom Room in Rooms)
            {
                AddRoomInfo(Room);
            }
        }
    }

    class SP_SHOW_MSG : cServerPacketHandler
    {
        public SP_SHOW_MSG(string Message)
        {
            //486686718 31264 64 E301CA44263ECF02CD7D5760D872E52E6E24B9E5A1A2BAB57FF7768095B23613CD97BE055B8800F3A506636B6350E78D527B53D9884A667400F53B2085C97F78 
            newPacket(31264);
            AddBlock(4);
            AddBlock(0);
            AddBlock(Message);
        }
    }

    class SP_JOIN_ROOM : cServerPacketHandler
    {
        public enum ErrorCodes
        {
            GenericError = 94010,
            InvalidPassword = 94030,
            BadLevel = 94300,
            OnlyPremium = 94301
        }

        public SP_JOIN_ROOM(cWRClient Client, cWRRoom Room)
        {
            newPacket(29456);
            AddBlock(1);
            AddBlock(Room.getIDOfPlayer(Client));
            AddRoomInfo(Room);
        }

        public SP_JOIN_ROOM(ErrorCodes ErrCode)
        {
            newPacket(29456);
            AddBlock((int)ErrCode);
        }
    }

    class SP_UNKNOW : cServerPacketHandler
    {
        public SP_UNKNOW(ArrayList tPlayer)
        {
            // 30032 1 0 0 0 0 2 0 0 0 1 1 0 8 0 0 0 0 0 
            // 30032 1 0 0 0 0 1 0 0 0 0 0 0 0 
            //1174909859 30032 1 0 0 97 98 2 0 0[Kills] 1[Deaths] 1[Flags] 2[points] 0[ping??] 8 1 0 2 6 0 
            //1176596062 30032 1 0 0 94 98 2 0 0 0 2 1 0 8 0 0 3 3 0 
            //1174883500 30032 1 0 0 10 98 2 0 0 0 1 1 0 8 0 0 0 0 0 
            newPacket(30032);
            AddBlock(1);
            AddBlock(0);
            AddBlock(0);
            AddBlock(94);
            AddBlock(98);
            AddBlock(tPlayer.Count);
            foreach (cWRClient cClient in tPlayer)
            {
                AddBlock(0);
                AddBlock(cClient.iKills);
                AddBlock(cClient.iDeaths);
                AddBlock(cClient.iFlags);
                AddBlock(cClient.iPoints);
                AddBlock(110);

            }

            //AddBlock(1);
            //AddBlock(0);
            //AddBlock(0);
            //AddBlock(94);
            //AddBlock(98);
            //AddBlock(2);
            //AddBlock(0);
            //AddBlock(Kills);
            //AddBlock(Deaths);
            //AddBlock(Flags);
            //AddBlock(Points);
            //AddBlock(0);
            //AddBlock(0);
        }
    }
    class SP_PLAYER_NUMBER : cServerPacketHandler
    {
        public SP_PLAYER_NUMBER(ArrayList Players, cWRRoom WRRoom)
        {
            //486668781 29968 1 2 0 1 355 1 0 -1 0 0 0 0 1000 -1 -1 0 
            newPacket(29968);
            AddBlock(1);
            AddBlock(2);
            AddBlock(0);
            AddBlock(1);
            AddBlock(355);
            AddBlock(WRRoom.getValueofPlayers());

            foreach (cWRClient _Client in Players)
            {
                AddBlock(WRRoom.getIDOfPlayer(_Client));
                AddBlock(-1);
                AddBlock(0);
                AddBlock(0);
                AddBlock(0);
                AddBlock(0);
                AddBlock(1000);
                AddBlock(-1);
                AddBlock(-1);
            }



            AddBlock(0);




        }
    }

    class SP_END_OF_GAME : cServerPacketHandler
    {

        int[] Level = new int[] {
        //1-10
        0,2250,6750,11250,16650,24750,32850,41625,50400,59175,
        //11-20
        67950,76725,94725,112725,130725,148725,166725,189225,211725,234225,
        //21-30
        256725,279225,306225,333225,360225,387225,414225,441225,497475,553725,
        //31-40
        609975,666225,722475,778725,857475,936225,1014975,1093725,1172475,1251225,
        //41-50
        1363725,1476225,1588725,1701225,1813725,1926225,2038725,2207475,2376225,2544975,
        //51-60
        2713725,2882475,3051225,3219975,3444975,3669975,3894975,4119975,4344975,4569975,
        //61-70
        4794975,5132475,5469975,5807475,6144975,6482475,6819975,7157475,7494975,7944975,
        //71-80
        8394975,8844975,9294975,9744975,10194975,10644975,11094975,11657475,12219975,12782475,
        //81-90
        13344975,13907475,14469975,15032475,15932475,17282475,18632475,19982475,21332475,22682475,
        //91-100
        24032475,25382475,26732475,28307475,29882475,31457475,33032475,34607475,36182475,37757475,
        //101
        2147483647
        };
        int CalculatePlayersLevel(long i)
        {
            int lvl = 0;
            //do
            //{
            //    if (i < Level[lvl]) break;
            //    lvl++;
            //} while (lvl < 101);
            for (int i2 = 0; i2 < 101; i2++)
            {
                if (i < Level[lvl]) { }
                else
                {
                    return lvl;
                }
            }
            return lvl;
        }

        public SP_END_OF_GAME(cWRClient _Client, int Kills, int Deaths)
        {
            //91286124 30048 1 0 304000 1 0 121 1 0 150 140 67 149406 0 
            newPacket(30048);
            AddBlock(1);
            AddBlock(0);
            AddBlock(_Client.FuckPacket);
            AddBlock(1);
            AddBlock(0);
            AddBlock(Kills);
            AddBlock(Deaths);
            AddBlock(0);
            AddBlock((Kills + Program.ConfigClass.iExpFaktor) * Program.ConfigClass.iExpRate);
            AddBlock((Kills + Program.ConfigClass.iExpFaktor));
            AddBlock((Kills + Program.ConfigClass.iExpFaktor));
            AddBlock(_Client.getExp());
            AddBlock(0);

            if (Level[_Client.getLevel() + 1] > _Client.getExp())
            {
                _Client.setLevel(_Client.getLevel() + 1);
                Program.SQLClass.runSQL("UPDATE ACCOUNT_TBL_DETAIL SET level = '" + _Client.getLevel().ToString() + "' WHERE userID = '" + _Client.getUserID().ToString() + "'").ToString();

            }
            _Client.setExp(_Client.getExp() + (Kills + Program.ConfigClass.iExpFaktor) * Program.ConfigClass.iExpRate * 7);
            _Client.setDinar(_Client.getDinar() + (Kills + Program.ConfigClass.iExpFaktor));

            Program.SQLClass.runSQL("UPDATE ACCOUNT_TBL_DETAIL SET dinar = '" + _Client.getDinar().ToString() + "' WHERE userID = '" + _Client.getUserID().ToString() + "'").ToString();
            Program.SQLClass.runSQL("UPDATE ACCOUNT_TBL_DETAIL SET exp = '" + _Client.getExp().ToString() + "' WHERE userID = '" + _Client.getUserID().ToString() + "'").ToString();

        }
    }
    class SP_PLANT_BOMB : cServerPacketHandler
    {
        public SP_PLANT_BOMB(int tType, params object[] Params)
        {
            // [ERROR]No Handler for OPC: 29984
            // [DEBUG]New Unknown Packet: 13329823 29984 0 0 0 91 1 3603.9736 85.3333 2490.9771
            //  235.4415 -34.7784 -182.6411 0
            AddBlock(29984);
            AddBlock(1);
            AddBlock(Params[0]);
            AddBlock(Params[1]);
            AddBlock(Params[2]);
            AddBlock(Params[3]);
            AddBlock(Params[4]);
            AddBlock(Params[5]);
            AddBlock(Params[6]);
            AddBlock(Params[7]);
            AddBlock(Params[8]);
            AddBlock(Params[9]);
            AddBlock(Params[10]);
            AddBlock(Params[11]);
        }
    }
    class SP_CHANGE_ROOM_DATA : cServerPacketHandler
    {
        public SP_CHANGE_ROOM_DATA(int tType, params object[] Params)
        {
            newPacket(30000);
            AddBlock(1);
            for (int i = 0; i < Params.Length; i++)
            {
                AddBlock(Params[i]);

                if (i == 2)
                {
                    AddBlock(tType);
                }
            }
        }
    }

    class SP_PLAYER_LIST : cServerPacketHandler
    {
        public SP_PLAYER_LIST(cWRClient Client, ArrayList ar) // <- Right?
        {
   
            newPacket(29952);

            AddBlock(ar.Count);

            foreach (cWRClient _Client in ar)
            {
                cWRRoom Room = _Client.getRoom();
                    AddBlock(_Client.getUserID());
                    AddBlock(_Client.getSessionID());
                    AddBlock(Room.getIDOfPlayer(_Client));
                    AddBlock(_Client.getReadyState()); //Room Ready State of Player(0 = not ready, 1 = ready)
                    AddBlock(Room.getSide(_Client)); // strona w pokoju
                    AddBlock(_Client.getReadyState());
                    AddBlock(0);
                    AddBlock(0);
                    AddBlock(1000);
                    AddBlock(_Client.getNickname());
                    AddBlock(7); // ? Clan
                    AddBlock(-1); // ? Clan
                    AddBlock(-1); // ? Clan
                    AddBlock(_Client.uniqID);//?
                    AddBlock(_Client.uniqID2); // ??
                    AddBlock(_Client.uniqIDisCRC); // ??
                    AddBlock(_Client.getPremium());//premium _Client.getPremium()
                    AddBlock(0);
                    AddBlock(-1);
                    AddBlock(_Client.getKills());//kille _Client.getKills()
                    AddBlock(_Client.getDeaths());//dedy _Client.getDeaths()
                    AddBlock(1000); ///g1 points
                    AddBlock(_Client.getExp()); // obecny exp _Client.getExp()
                    AddBlock(-1);
                    AddBlock(-1);
                    AddBlock(_Client.chooseClass);//klasa postaci ostatnio grana - pobierać z 30000 150 ?
                    AddBlock(_Client.getNetworkIP()); //network ip
                    AddBlock(_Client.getNetworkPort()); //network port
                    AddBlock(_Client.getLocalIP()); // local ip lol? wtf, how they get this ??? -> z udp :)
                    AddBlock(_Client.getLocalPort()); // local port ?!
                    AddBlock(0);
                }
            }
        }

        class SP_INVITE : cServerPacketHandler
        {
            public enum ErrorCodes
            {
                GenericError = 93020,
                IsPlaying = 93030
            }

            public SP_INVITE(ErrorCodes ErrCode)
            {
                newPacket(29520);
                AddBlock((int)ErrCode);
            }

            public SP_INVITE(cWRClient Client, string Message)
            {
                //1454817889 29520 1 0 -1 13949431 19 gn0m3x -1 -1 -1 -1 0 19 68066 0 0 LassunseineRundezusammenspielen.Kommrein 3 NULL 
                newPacket(29520);
                AddBlock(1);
                AddBlock(0);
                AddBlock(-1);
                AddBlock(Client.getUserID());
                AddBlock(107); // Ping ?!
                AddBlock(Client.getNickname());
                // Clan
                AddBlock(-1);
                AddBlock(-1);
                AddBlock(-1);
                AddBlock(-1);
                // End Clan
                AddBlock(0);
                AddBlock(19);
                AddBlock(Client.getExp());
                AddBlock(0);
                AddBlock(0);
                AddBlock(Message);
                AddBlock(Client.getRoom().getRoomID());
                AddBlock(Client.getRoom().getPassword());
            }
        }

        class SP_ROOM_KICK : cServerPacketHandler
        {
            public SP_ROOM_KICK(int Place)
            {
                newPacket(29505);
                AddBlock(1);
                AddBlock(Place);
            }
        }
        class SP_ZOMBIESPAWN_MADMAN : cServerPacketHandler
        {
            public SP_ZOMBIESPAWN_MADMAN(int i)
            {
                //13432 5 0 0 8 150 
                //13432 6 0 0 18 150 
                newPacket(13432);
                AddBlock(i);
                AddBlock(0);
                AddBlock(0);
                AddBlock(8);
                AddBlock(150);
            }
        }
        class SP_ZOMBIESPAWN_MANIC : cServerPacketHandler
        {
            public SP_ZOMBIESPAWN_MANIC(int i)
            {
                //1021043952 13432 7 0 1 5 250 
                //742138077 13432 8 0 1 16 250
                //742223077 13432 17 0 2 24 150
                newPacket(13432);
                AddBlock(i);
                AddBlock(0);
                AddBlock(1);
                AddBlock(16);
                AddBlock(250);
            }
        }
        class SP_ZOMBIESPAWN_GRINDER : cServerPacketHandler
        {
            public SP_ZOMBIESPAWN_GRINDER(int i)
            {
                //742138077 13432 8 0 1 16 250
                //742223077 13432 17 0 2 24 150
                newPacket(13432);
                AddBlock(i);
                AddBlock(0);
                AddBlock(2);
                AddBlock(24);
                AddBlock(150);
            }
        }
        class SP_ZOMBIESPAWN_GROUNDER : cServerPacketHandler
        {
            public SP_ZOMBIESPAWN_GROUNDER(int i)
            {
                //742138077 13432 8 0 1 16 250
                //742223077 13432 17 0 2 24 150
                newPacket(13432);
                AddBlock(i);
                AddBlock(0);
                AddBlock(3);
                AddBlock(24);
                AddBlock(150);
            }
        }
        class SP_ZOMBIESPAWN_HEAVY : cServerPacketHandler
        {
            public SP_ZOMBIESPAWN_HEAVY(int i)
            {
                //742138077 13432 8 0 1 16 250
                //742223077 13432 17 0 2 24 150
                newPacket(13432);
                AddBlock(i);
                AddBlock(0);
                AddBlock(4);
                AddBlock(24);
                AddBlock(150);
            }
        }
        class SP_ZOMBIESPAWN_GROWLER : cServerPacketHandler
        {
            public SP_ZOMBIESPAWN_GROWLER(int i)
            {
                //742138077 13432 8 0 1 16 250
                //742223077 13432 17 0 2 24 150
                newPacket(13432);
                AddBlock(i);
                AddBlock(0);
                AddBlock(5);
                AddBlock(24);
                AddBlock(150);
            }
        }
        class SP_ZOMBIESPAWN_LOVER : cServerPacketHandler
        {
            public SP_ZOMBIESPAWN_LOVER(int i)
            {
                //742138077 13432 8 0 1 16 250
                //742223077 13432 17 0 2 24 150
                newPacket(13432);
                AddBlock(i);
                AddBlock(0);
                AddBlock(6);
                AddBlock(24);
                AddBlock(150);
            }
        }
        class SP_ZOMBIESPAWN_HANDGEMAN : cServerPacketHandler
        {
            public SP_ZOMBIESPAWN_HANDGEMAN(int i)
            {
                //742138077 13432 8 0 1 16 250
                //742223077 13432 17 0 2 24 150
                newPacket(13432);
                AddBlock(i);
                AddBlock(0);
                AddBlock(7);
                AddBlock(24);
                AddBlock(150);
            }
        }
        class SP_ZOMBIESPAWN_CHARIOT : cServerPacketHandler
        {
            public SP_ZOMBIESPAWN_CHARIOT(int i)
            {
                //742138077 13432 8 0 1 16 250
                //742223077 13432 17 0 2 24 150
                newPacket(13432);
                AddBlock(i);
                AddBlock(0);
                AddBlock(8);
                AddBlock(24);
                AddBlock(150);
            }
        }
        class SP_ZOMBIESPAWN_CRUSHER : cServerPacketHandler
        {
            public SP_ZOMBIESPAWN_CRUSHER(int i)
            {
                //742138077 13432 8 0 1 16 250
                //742223077 13432 17 0 2 24 150
                newPacket(13432);
                AddBlock(i);
                AddBlock(0);
                AddBlock(9);
                AddBlock(24);
                AddBlock(150);
            }
        }
    }
