﻿using System;
using System.Net;
using System.Net.Sockets;
using System.Collections;

using System.Threading;
namespace GameServer
{
    class cWRServer
    {
        private ArrayList _Clients = new ArrayList();
        private ArrayList _CQCRooms = new ArrayList();
        private ArrayList _UORooms = new ArrayList();
        private ArrayList _BGRooms = new ArrayList();
        private ArrayList _AIRooms = new ArrayList();
        private ArrayList _TrainingRooms = new ArrayList();

        private static Thread _roomTick;
        private static Thread _pingThread;

        public bool setup()
        {
            try
            {
                if (SetupPing())
                {
                    _roomTick = new Thread(new ThreadStart(roomTick));
                    _roomTick.Priority = ThreadPriority.AboveNormal;
                    _roomTick.Start();
                }
                return true;
            }
            catch { }

            return false;
        }

        public bool SetupPing()
        {
            try
            {
                _pingThread = new Thread(new ThreadStart(pingThread));
                _pingThread.Priority = ThreadPriority.AboveNormal;
                _pingThread.Start();
                return true;
            }
            catch { }
            return false;
        }

        private void pingThread()
        {
            while (true)
            {
                foreach (cWRClient C in _Clients)
                {
                    C.setCoupons(C.getCoupons() + 1);
                    C.Send(new SP_SHOW_MSG("You received 1 Coupon for 15Minutes of Playing!"));
                    Program.SQL.conn.ExecuteQuery("UPDATE account_detail SET `Coupons`='" + C.getCoupons() + "'");
                }
                Thread.Sleep(60000*15);
            }
        }


        public cWRClient getPlayerByID(int tID)
        {
            foreach (cWRClient c in _Clients)
            {
                if (c.getUserID() == tID)
                {
                    return c;
                }
            }
            return null;
        }

        private void roomTick()
        {
            while (true)
            {

                foreach (cWRRoom Room in _CQCRooms)
                {
                    Room.update(); /* Update Room */
                }
                foreach (cWRRoom Room in _UORooms)
                {
                    Room.update(); /* Update Room */
                }
                foreach (cWRRoom Room in _BGRooms)
                {
                    Room.update(); /* Update Room */
                }
                foreach (cWRRoom Room in _AIRooms)
                {
                    Room.update(); /* Update Room */
                }
                foreach (cWRRoom Room in _TrainingRooms)
                {
                    Room.update();
                }


                Thread.Sleep(200);
            }
        }

        public void AddClient(cWRClient Client)
        {
            _Clients.Add(Client);
        }

        public void RemoveClient(cWRClient Client)
        {
            _Clients.Remove(Client);
        }

        public ArrayList getPlayerInChannel(int ChannelID)
        {
            ArrayList tList = new ArrayList();

            foreach (cWRClient Client in _Clients)
            {
                if (Client.getChannelID() == ChannelID)
                {
                    tList.Add(Client);
                }
            }
            return tList;
        }

        public ArrayList Players(bool inRoom)
        {
            ArrayList Players = new ArrayList();

            if (inRoom == false)
            {
                foreach (cWRClient tPlayer in _Clients)
                { if (tPlayer.getRoom() == null) { Players.Add(tPlayer); } }
            }
            else
            {
                foreach (cWRClient tPlayer in _Clients)
                { if (tPlayer.getRoom() is cWRRoom) { Players.Add(tPlayer); } }
            }
            return Players;
        }

        public ArrayList getAllPlayers()
        {
            return _Clients;
        }

        public cWRClient getPlayerByNickname(string Nickname)
        {
            foreach (cWRClient Client in _Clients)
            {
                if (Client.getNickname().ToLower() == Nickname.ToLower())
                {
                    return Client;
                }
            }
            return (cWRClient)null;
        }

        public void AddRoom(cWRRoom Room, int ChannelID)
        {
            switch (ChannelID)
            {
                case 1:
                    _CQCRooms.Add(Room);
                    break;
                case 2:
                    _UORooms.Add(Room);
                    break;
                case 3:
                    _BGRooms.Add(Room);
                    break;
                case 4:
                    _AIRooms.Add(Room);
                    break;
                case 9:
                    _TrainingRooms.Add(Room);
                    break;
            }
        }

        public void RemoveRoom(cWRRoom Room, int ChannelID)
        {
            switch (ChannelID)
            {
                case 1:
                    _CQCRooms.Remove(Room);
                    break;
                case 2:
                    _UORooms.Remove(Room);
                    break;
                case 3:
                    _BGRooms.Remove(Room);
                    break;
                case 4:
                    _AIRooms.Remove(Room);
                    break;
                case 9:
                    _TrainingRooms.Remove(Room);
                    break;
            }
        }

        public ArrayList getRoomsInChannel(int ChannelID)
        {
            switch (ChannelID)
            {
                case 1:
                    return _CQCRooms;
                case 2:
                    return _UORooms;
                case 3:
                    return _BGRooms;
                case 4:
                    return _AIRooms;
                default:
                    return new ArrayList();
            }
        }

        public cWRRoom getRoomByID(int ID, int ChannelID)
        {
            ArrayList Rooms = getRoomsInChannel(ChannelID);

            foreach (cWRRoom _Room in Rooms)
            {
                if (_Room.ID == ID)
                {
                    return _Room;
                }
            }
            return (cWRRoom)null;
        }
        public int getOpenID(int Channel)
        {

            for (int i = 0; i < 250; i++) { if (getRoomByID(i, Channel) == null) { return i; } }
           
            return -1;
        }
        public int PortToInt(int Port)
        {
            byte[] PortBytes = BitConverter.GetBytes(Port);
            byte[] PortBytesNew = new byte[2] { PortBytes[1], PortBytes[0] };
            ushort newPort = BitConverter.ToUInt16(PortBytesNew, 0);

            return newPort;
        }
        public long IPToInt(string addr)
        {


            return (long)(uint)IPAddress.NetworkToHostOrder((int)IPAddress.Parse(ReverseIP(addr)).Address);

        }
        public string IPToAddr(long address) { return IPAddress.Parse(address.ToString()).ToString(); }

        private string ReverseIP(string tString)
        {
            string[] bString = tString.Split(new char[] { '.' });
            string tNew = "";
            for (int i = (bString.Length - 1); i > -1; i--)
            { tNew += bString[i] + "."; }
            return tNew.Substring(0, tNew.Length - 1);
        }

        public object GetMaxValue(ArrayList arrList)
        {

            ArrayList sortArrayList = arrList;

            sortArrayList.Sort();

            sortArrayList.Reverse();

            return sortArrayList[0];

        }
    }
}
