﻿using System;
using System.Runtime.InteropServices;
using System.Text;

namespace GameServer
{
    class cServerPacketHandler
    {
        [DllImport("winmm.dll")]
        public static extern long timeGetTime();

        private int OPC;
        private string[] Blocks = new String[0];

        public void newPacket(int iOPC)
        {
            OPC = iOPC;
        }

        public void AddBlock(object Block)
        {
            Array.Resize(ref Blocks, Blocks.Length + 1);
            Blocks[Blocks.Length - 1] = Convert.ToString(Block);
        }

        public byte[] getPacket(bool isISC)
        {
            string sPacket = String.Empty;

            sPacket =
                Convert.ToString(timeGetTime()) +
                Convert.ToChar(0x20) +
                Convert.ToString(OPC) +
                Convert.ToChar(0x20);

            for (int i = 0; i < Blocks.Length; i++)
            {
                sPacket += Blocks[i].Replace(Convert.ToChar(0x20), Convert.ToChar(0x1D)) + Convert.ToChar(0x20);
            }

            //new cLog(C.MSG_DEBUG, sPacket);

            if (isISC)
            {
                sPacket = Crypt(sPacket + Convert.ToChar(0x20) + Convert.ToChar(0x0A));
            }
            else
            {
                sPacket = Crypt2(sPacket + Convert.ToChar(0x20) + Convert.ToChar(0x0A));
            }

            return Encoding.Default.GetBytes(sPacket);
        }

        public string Crypt(string sPacket)
        {
            byte[] tTemp = Encoding.Default.GetBytes(sPacket);

            for (int i = 0; i < tTemp.Length; i++)
            {
                tTemp[i] = Convert.ToByte(tTemp[i] ^ 0x96);
            }
            return Encoding.Default.GetString(tTemp);
        }

        public string Crypt2(string sPacket)
        {
            byte[] tTemp = Encoding.Default.GetBytes(sPacket);

            for (int i = 0; i < tTemp.Length; i++)
            {
                tTemp[i] = Convert.ToByte(tTemp[i] ^ 0x11); //45
            }
            return Encoding.Default.GetString(tTemp);
        }

       
        public void AddRoomInfo(cWRRoom Room)
        {
            AddBlock(Room.ID);
            AddBlock(1);
            AddBlock(Room.RoomStatus);
            AddBlock(Room.RoomMasterSlot);
            AddBlock(Room.Name);
            AddBlock(0);
            AddBlock(Room.MaxPlayers);
            AddBlock(Room.PlayerCount);
            AddBlock(Room.MapID);
            AddBlock(0);
            AddBlock(2);
            AddBlock(0);
            AddBlock(Room.RoomMode);//7
            AddBlock(4);
            if (Room.RoomMode != 7)
            {
                AddBlock(1);
            }
            else
            {
                if (Room.Players.Count == 4)
                {
                    AddBlock(0); // 0 = unjoinable(grey room)
                }
                else
                {
                    AddBlock(1);
                }
            }
            AddBlock(4);
            AddBlock(0); // 1 = Room has Supermaster
            AddBlock(Room.RoomType);
            AddBlock(Room.LevelLimit);
            AddBlock(Room.PremiumOnly);
            AddBlock(Room.VoteKick);
            AddBlock(0);//autostart
            AddBlock(0); // ??
            AddBlock(Room.Ping);
            AddBlock(-1);
        }
    }
}