﻿using System;

namespace GameServer
{
    class Program
    {
        public static string bannedips = "";
        public static string getBannedMacs = "";//"005056c00001";
        public static cConfig ConfigClass = new cConfig();
        public static cDatabase SQL = new cDatabase();
 
        public static cUDPServer UDPClass = new cUDPServer();
        public static cServer ServerClass = new cServer();
        public static cCore _Core = new cCore();
        public static cWRClient SystemClient = null;

        public static cWRServer WRServer = new cWRServer();
        public static int OpenChannels = 4;

        public static cWRServer rCollector = new cWRServer();
        public static cWRServer cCollector = new cWRServer();

        public static Collector.cUserCollector uCollcetor = new Collector.cUserCollector();

        public static cBans _BanManager = new cBans();
            
        public static void WriteLine(string Tag, string Message)
        {
            Console.ForegroundColor = ConsoleColor.Yellow;
            Console.Write("[");
            Console.ForegroundColor = ConsoleColor.DarkRed;
            Console.Write(Tag);
            Console.ForegroundColor = ConsoleColor.Yellow;
            Console.Write("] » ");//»
            Console.ForegroundColor = ConsoleColor.DarkRed;
            Console.Write(Message);
            Console.ForegroundColor = ConsoleColor.White;
            Console.WriteLine();
        }


        static void Main(string[] args)
        {
            Console.Title = "Insomnia GameServer is Loading!";
            if (ConfigClass.LoadConfig())
            {
                Logger.Debug("Read Config File [ Server.ini ]");
                if (SQL.Connect())
                {
                    Logger.Success("Succesfully connected to MySQL Server on [ localhost:3306 ]");
                    if (_BanManager.loadMacBans())
                    {
                        Logger.Notification("Load all Mac Bans!");
                        if (UDPClass.SetupUDPServer())
                        {
                            Logger.Notification("UDPSocket #1 Started");
                            Logger.Notification("UDPSocket #2 Started");
                            if (ServerClass.StartServer(99))
                            {
                                if (rCollector.setup())
                                {
                                    Logger.Success("Succesful started RoomTick!");

                                    Logger.Success("Succesful started PingThread!");
                                    Logger.Notification("Server Started succesful!");
                                    _Core.isRunning = true;

                                    Console.Title = "[ RamUsage: " + _Core.freeRam + "KB | Players : " + _Core.onlinePlayers + "] InsomniaCore - GameServer";

                                    System.Threading.Thread T = new System.Threading.Thread(MainLoop);
                                    T.Start();

                                }
                                else
                                {
                                    WriteLine("RoomCollector", "Error Settingup RoomTick");
                                    Console.Title = "Error Initializing Room Class!";
                                    Console.Read();
                                }
                            }
                            else
                            {
                                WriteLine("cMain", "Error Starting Server");
                                Console.Title = "Error Initializing Server Class!";
                                Console.Read();
                            }
                        }
                        else
                        {
                            WriteLine("UDPServer", "Failed to Start UDPSocket #1");
                            WriteLine("UDPServer", "Failed to Start UDPSocket #2");
                            Console.Title = "Error Initializing UDPServer Class!";
                            Console.Read();
                        }

                    }
                }
                else
                {
                    WriteLine("SQLClass", "Failed to Connect to [ localhost:3306 ]");
                    Console.Title = "Error Initializing MySQL Class!";
                    Console.Read();
                }
            }
            else
            {
                WriteLine("Config", "Failed to Read [ GameServer.ini ]!");
                Console.Title = "Error Initializing Config Class!";
                Console.Read();
            }

            
        }

        static void MainLoop()
        {
            if (_Core.isRunning)
            {
                Console.Title = "[ RamUsage: " + _Core.freeRam + "KB | Players : " + _Core.onlinePlayers + "] InsomniaCore - GameServer";

                string Command = Console.ReadLine();
                if (Command == "shutdown")
                {
                    foreach (cWRClient c in WRServer.getAllPlayers())
                    {
                        c.Send(new SP_CHAT(c, SP_CHAT.ChatType.Notice1, "Server is going down in 10Seconds", c.getSessionID(), "PETER"));
                        c.Disconnect();
                    }
                    System.Threading.Thread.Sleep(10000);

                }
                else
                {
                    foreach (cWRClient c in WRServer.getAllPlayers())
                    {
                        c.Send(new SP_CHAT(c, SP_CHAT.ChatType.Notice1, Command, c.getSessionID(), "PETER"));
                    }
                }
            }
            else { System.Threading.Thread.Sleep(200);  } 

            System.Threading.Thread.Sleep(2000);

        }
    }
}
