﻿using System;
using System.Collections;
using System.Text;

using System.Threading;

namespace GameServer.Collector
{
    class cRoomCollector
    {
        private Hashtable[] _Rooms = new Hashtable[Program.OpenChannels];
        private Hashtable[] _Clients = new Hashtable[Program.OpenChannels];
        public int OpenChannels = 4;

       
        public bool Setup()
        {
            try
            {
                for (int i = 1; i < OpenChannels; i++)
                {
                    _Rooms[i] = new Hashtable();
                }
                Thread _roomThread = new Thread(new ThreadStart(roomTick));
                _roomThread.Priority = ThreadPriority.AboveNormal;
                _roomThread.Start();
                return true;
            }
            catch { }

            return false;
        }

        private void roomTick()
        {
            while (true)
            {
                for (int I = 1; I < OpenChannels; I++)
                {
                    foreach (cWRRoom Room in ((Hashtable)_Rooms[I].Values))
                    {
                        Room.update(); /* Update Room */
                    }
                }

                Thread.Sleep(200);
            }
        }

        public int getOpenID(int Channel)
        {
            for (int I = 0; I < 250; I++)
            {
                if (_Rooms[Channel].ContainsKey(I) == false)
                {
                    return I;
                }
            }

            return -1;
        }

        public bool addRoom(int RoomID, int Channel, cWRRoom _Room)
        {
            try
            {
                _Rooms[Channel].Add(RoomID, _Room);
            }
            catch { }
            return false;
        }

        public bool removeRoom(int RoomID, int Channel, cWRRoom _Room)
        {
            try
            {
                if (_Rooms[Channel].ContainsKey(RoomID))
                {
                    _Rooms[Channel].Remove(_Room);
                }
            }
            catch { }
            return false;
        }

        public ArrayList getAllRooms(int Channel)
        {
            return ((ArrayList)_Rooms[Channel].Values);
        }

        public cWRRoom getRoom(int Channel, int RoomID)
        {
            try
            {
                foreach (cWRRoom r in _Rooms[Channel].Values)
                {
                    if (r.ID == RoomID)
                    {
                        return r;
                    }
                }
            }
            catch { }

            return null;
        }
        public ArrayList getRoomsInChannel(int Channel)
        {
            return ((ArrayList)_Rooms[Channel].Values);
        }
        public bool checkCrashedRoom(int Channel, int RoomID)
        {
            try
            {
                if(_Rooms[Channel].ContainsKey(RoomID))
                {
                    cWRRoom r = getRoom(Channel,RoomID);
                    if (r is cWRRoom)
                    {
                        int CrashedPlayers = 0;
                        foreach (cWRClient _c in r.Players)
                        {
                            if (_c.ClientPing == 999 || _c.ClientPing == 0)
                            {
                                _c.Disconnect();
                                CrashedPlayers++;
                            }
                        }
                        if (CrashedPlayers == r.Players.Count || r.Players.Count == 0)
                        {
                            removeRoom(RoomID, Channel, r);
                            return false;
                        }

                    }
                }
            }
            catch { }
            return true;
        }
    }
}
