﻿/* Copyright 2010 © by YeZZx aka Crunkx */

using System;
using System.Text;
using System.Runtime.InteropServices;

namespace LoginServer
{
    class cConfig
    {
        [DllImport("kernel32.dll")]
        private static extern uint GetPrivateProfileString(string lpAppName, string lpKeyName, string lpDefault, StringBuilder lpReturnedString, uint nSize, string lpFileName);

        private StringBuilder sBuffer = new StringBuilder(255);
        private string ConfigPath = Environment.CurrentDirectory + @"\..\Config\LoginServer.ini";

        public struct cfgTable
        {
            public string SERVER_BIND_IP;
            public ushort SERVER_BIND_PORT;
            public int    SERVER_CFG_TYPE;
            public string DB_NAME;
            public string DB_HOST;
            public string DB_USER;
            public string DB_PASSWORD;
            public string ISC_CFG_IP;
            public ushort ISC_CFG_PORT;
            public string ISC_CFG_PASSWORD;
            public string DB_PORT;
        }

        public cfgTable ConfigTable = new cfgTable();

        public cConfig()
        {
            try
            {
                // Get Config Data
                GetPrivateProfileString("SERVER", "SERVER_BIND_IP", string.Empty, sBuffer, 255, ConfigPath);
                ConfigTable.SERVER_BIND_IP = sBuffer.ToString();

                GetPrivateProfileString("SERVER", "SERVER_BIND_PORT", string.Empty, sBuffer, 255, ConfigPath);
                ConfigTable.SERVER_BIND_PORT = ushort.Parse(sBuffer.ToString());
               
                GetPrivateProfileString("DATABASE", "DB_NAME", string.Empty, sBuffer, 255, ConfigPath);
                ConfigTable.DB_NAME = sBuffer.ToString();

                GetPrivateProfileString("DATABASE", "DB_USER", string.Empty, sBuffer, 255, ConfigPath);
                ConfigTable.DB_USER = sBuffer.ToString();

                GetPrivateProfileString("DATABASE", "DB_PASSWORD", string.Empty, sBuffer, 255, ConfigPath);
                ConfigTable.DB_PASSWORD = sBuffer.ToString();

                GetPrivateProfileString("DATABASE", "DB_HOST", string.Empty, sBuffer, 255, ConfigPath);
                ConfigTable.DB_HOST = sBuffer.ToString();
                GetPrivateProfileString("DATABASE", "DB_PORT", string.Empty, sBuffer, 255, ConfigPath);
               
                ConfigTable.DB_PORT = sBuffer.ToString();
                GetPrivateProfileString("ISC", "ISC_CFG_IP", string.Empty, sBuffer, 255, ConfigPath);
                ConfigTable.ISC_CFG_IP = sBuffer.ToString();

                GetPrivateProfileString("ISC", "ISC_CFG_PORT", string.Empty, sBuffer, 255, ConfigPath);
                ConfigTable.ISC_CFG_PORT = ushort.Parse(sBuffer.ToString());

                GetPrivateProfileString("ISC", "ISC_CFG_PASSWORD", string.Empty, sBuffer, 255, ConfigPath);
                ConfigTable.ISC_CFG_PASSWORD = sBuffer.ToString();

                // Other Settings:
                ConfigTable.SERVER_CFG_TYPE = 1; // 1 = LoginServer
            }
            catch { }

            if (ConfigTable.SERVER_BIND_IP.Length <= 0 || ConfigTable.SERVER_BIND_PORT <= 0 || ConfigTable.ISC_CFG_IP.Length <= 0 
                || ConfigTable.ISC_CFG_PORT <= 0 || ConfigTable.ISC_CFG_PASSWORD.Length <= 0 || ConfigTable.DB_NAME.Length <= 0
                || ConfigTable.DB_USER.Length <= 0 ||  ConfigTable.DB_HOST.Length <= 0 || ConfigTable.DB_PORT.Length <= 0)
            {
                new cLog(C.MSG_ERROR, "Error reading Config");
                Console.Read();
                return;
            }
        }
    }
}
/* Copyright 2010 © by YeZZx aka Crunkx */
