﻿
using System;

using System.Net.NetworkInformation;

namespace LoginServer
{
    class SP_ISC_LOGIN_PACKET : cServerPacketHandler
    {
        public SP_ISC_LOGIN_PACKET()
        {
            newPacket(44441);
            addBlock(cMain.Config.ISC_CFG_PASSWORD);
            addBlock(cMain.Config.SERVER_CFG_TYPE);
            addBlock(cMain.Config.SERVER_BIND_PORT);
        }
    }

    class SP_CONNECT_PACKET : cServerPacketHandler
    {
        public SP_CONNECT_PACKET()
        {
            newPacket(4608);
            addBlock(new Random().Next(111111111, 999999999));
            addBlock(77);
        }
    }

    class SP_PATCHER_PACKET : cServerPacketHandler
    {
        public SP_PATCHER_PACKET()
        {
            newPacket(4112);
            addBlock(0);
            addBlock(17);
            addBlock(33);
            addBlock(37);
            addBlock(0);
            addBlock(0);
            addBlock("http://patch.warrock.net/k2network/warrock/");
        }
    }

    class SP_SERVER_LIST : cServerPacketHandler
    {
        public enum errorCodes : int
        {
            Nickname = 72000,
            WrongUser = 72010,
            WrongPW = 72020,
            AlreadyLoggedIn = 72030,
            Banned = 73050,
            BannedTime = 73020
        }

        public SP_SERVER_LIST(errorCodes errCode, params object[] oParams)
        {
            newPacket(4352);
            addBlock(((int)errCode));

            foreach (object tParam in oParams)
            {
                addBlock(tParam);
            }
        }

        public SP_SERVER_LIST(cClient Client)
        {
            newPacket(4352);
            addBlock(1);
            addBlock(Client.getUserID());
            addBlock(0);
            addBlock(Client.getUsername());
            addBlock(Client.getPassword());
            addBlock(Client.getNickname());
            addBlock(0);
            addBlock(1); // Client.getAge() -> 1 = over 18 , 0 = 14 or Younger
            addBlock(Client.getSessionID()); // UDP Session :(TODO)
            if (Client.getAccesslevel() > 2)
            {
                addBlock(123); // Spectate and Yellow Font
            }
            else
            {
                addBlock(0);
            }
            addBlock(Client.getPassword()); // SessionKey / PassPort

            addBlock(2);

            addBlock(36);
            
            addBlock("TESTv01 [ ONLINE ]");
           
            addBlock("46.37.175.96");
            addBlock(5340);
            addBlock(63);
            addBlock(0);

            addBlock(37);
            addBlock("TESTv02 [ ONLINE ]");
            addBlock("31.193.13.232");
            addBlock(5340);
            addBlock(66);
            addBlock(0);
            

            //Clan shit here :(TODO)
            addBlock(-1);
            addBlock(-1);
            addBlock(-1);
            addBlock(-1);
            addBlock(-1);
            addBlock(-1);
        }
    }
}
/* Copyright 2010 © by YeZZx aka Crunkx */