﻿/* Copyright 2010 © by YeZZx aka Crunkx */
using System;
using System.Runtime.InteropServices;
using System.Text;

namespace LoginServer
{
    class cServerPacketHandler
    {
        [DllImport("winmm.dll")]
        private static extern long timeGetTime();

        private int iOPC;
        private string[] sBlocks = new string[0];

        public void newPacket(int tOPC)
        {
            iOPC = tOPC;
        }

        public void addBlock(object oBlock)
        {
            Array.Resize(ref sBlocks, sBlocks.Length + 1);
            sBlocks[sBlocks.Length - 1] = Convert.ToString(oBlock);
        }

        public byte[] getPacket()
        {
            string sPacket = string.Empty;

            sPacket =
                Convert.ToString(timeGetTime()) + // Timestamp
                Convert.ToChar(0x20) + // Space
                Convert.ToString(iOPC) + // Operation Code
                Convert.ToChar(0x20); // Space

            for (int i = 0; i < sBlocks.Length; i++)
            {
                sPacket += sBlocks[i].Replace(Convert.ToChar(0x20), Convert.ToChar(0x1D)) + Convert.ToChar(0x20);
            }

            sPacket = Crypt(sPacket + Convert.ToChar(0x0A));

            return Encoding.Default.GetBytes(sPacket);
        }

        private string Crypt(string sPacket)
        {
            byte[] tBytes = Encoding.Default.GetBytes(sPacket);

            for (int i = 0; i < tBytes.Length; i++)
            {
                tBytes[i] = Convert.ToByte(tBytes[i] ^ 0x96);
            }

            return Encoding.Default.GetString(tBytes);
        }
    }
}
/* Copyright 2010 © by YeZZx aka Crunkx */