﻿/* Copyright 2010 © by YeZZx aka Crunkx */
using System;
using System.Net;
using System.Net.Sockets;
using System.Threading;
using System.Collections;

namespace LoginServer
{
    class cServer
    {
        private Socket ServerSocket = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
        private Hashtable hTable = new Hashtable();
        private Hashtable hISCTable = new Hashtable();
        public int ConnectionCount = 0;
        public bool startServer()
        {
            bool Result = false;
            try
            {
                ServerSocket.Bind(new IPEndPoint(IPAddress.Parse(cMain.Config.SERVER_BIND_IP), cMain.Config.SERVER_BIND_PORT));
                ServerSocket.Listen(0);
                Result = true;
            }
            catch 
            {
                Console.Read();
               
            }

            
            Thread acceptThread = new Thread(new ThreadStart(handleConnections));
            acceptThread.Start();
            return Result;
        }

        private void handleConnections()
        {
            while (true)
            {
                Socket ClientSocket = ServerSocket.Accept();
                ConnectionCount++;
                cClient WRClient = new cClient(ClientSocket, ConnectionCount);
                Thread.Sleep(5);
            }
        }

        public void SetUpHandlers()
        {

            addFunc(hTable, 4112, new CP_PATCHER_PACKET());
            addFunc(hTable, 4352, new CP_LOGIN_PACKET());
            addFunc(hTable, 4353, new CP_SET_NICKNAME());
        }

        private void addFunc(Hashtable tTable, int iOPC, object tFunction)
        {
            if (tTable.ContainsKey(iOPC) == false)
            {
                tTable.Add(iOPC, tFunction);
            }
            else
            {
                new cLog(C.MSG_ERROR, "Operation Code: " + iOPC.ToString() + " has already an Function!");
            }
        }

        public Hashtable getHandleTable()
        {
            return hTable;
        }

        public Hashtable getISCHandleTable()
        {
            return hISCTable;
        }
    }
}
/* Copyright 2010 © by YeZZx aka Crunkx */