﻿using System;
using System.Net.Sockets;
using System.Threading;
using System.Net;
using System.Text;

namespace GameServer
{
    class cUDP
    {
        private UdpClient UDPSocket_1;
        private UdpClient UDPSocket_2;

        public void StartUDPServer()
        {
            try
            {
                Thread RecvThread1 = new Thread(new ThreadStart(RecvUDP1));
                RecvThread1.Start();
                Thread RecvThread2 = new Thread(new ThreadStart(RecvUDP2));
                RecvThread2.Start();

                new cLog(C.MSG_SUCCESS, "UDP Sockets initialized");
                Program.ServerClass.StartServer();
            }
            catch
            {
                new cLog(C.MSG_ERROR, "Couldn't start UDP Sockets on Ports: 5350 | 5351");
                Console.Read();
            }
        }

        private void RecvUDP1()
        {
            byte[] btReceiveData;
            IPEndPoint GroupEP;
            IPAddress GroupIP;
            GroupIP = IPAddress.Parse("0.0.0.0");
            GroupEP = new IPEndPoint(GroupIP, 5350);
            UDPSocket_1 = new UdpClient(5350);

            for (; ; )
            {
                btReceiveData = UDPSocket_1.Receive(ref GroupEP);
                byte[] Response = AnalyzePacket(btReceiveData, GroupEP);
                UDPSocket_1.Send(Response, Response.Length, GroupEP);
            }
        }

        private void RecvUDP2()
        {
            byte[] btReceiveData;
            IPEndPoint GroupEP;
            IPAddress GroupIP;
            GroupIP = IPAddress.Parse("0.0.0.0");
            GroupEP = new IPEndPoint(GroupIP, 5351);
            UDPSocket_2 = new UdpClient(5351);

            for (; ; )
            {
                btReceiveData = UDPSocket_2.Receive(ref GroupEP);
                byte[] Response = AnalyzePacket(btReceiveData, GroupEP);
                UDPSocket_2.Send(Response, Response.Length, GroupEP);
            }
        }

        private byte[] AnalyzePacket(byte[] RecvPacket, IPEndPoint IPeo)
        {
            byte[] Response = new Byte[0];

            if (RecvPacket[0] == 0x10 && RecvPacket[1] == 0x10 && RecvPacket[2] == 0x00)
            {
                Response = new Byte[65] 
                {
                    0x10, 0x10, 
                    RecvPacket[2],
                    RecvPacket[3],
                    RecvPacket[4],
                    RecvPacket[5],
                    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x41,
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0x96, 0x94, 0x96,
                    0x7a, 0x8f, 0xc1, 0x34, 0x40, 0xc1, /* 2 Bytes changed every time [ 0x7a, 0x8f ]*/
                    0x96, 0x96, 0x96, 0x96, 0x96, 0x96, 0x96, 0x96, 0x86, 0x96, 0x94, 0x96, 
                    0x7a, 0x8f, 0x56, 0x3e, 0x24, 0x8d, /* 2 Bytes changed every time [ 0x7a, 0x8f ]*/
                    0x9e, 0x9e, 0x9e, 0x9e, 0x9e, 0x9e, 0x9e, 0x9e, 0x96
                };

                /*
                10 10 00 00 00 9f ff ff ff ff 00 00 00 00 21 00
                00 41 00 00 00 00 00 00 00 00 00 00 86 96 94 96
                7a 8f c1 34 40 c1 96 96 96 96 96 96 96 96 86 96
                94 96 7a 8f 56 3e 24 8d 9e 9e 9e 9e 9e 9e 9e 9e
                96*/
            }
            else if (RecvPacket[0] == 0x10 && RecvPacket[1] == 0x01 && RecvPacket[2] == 0x01)
            {
                Response = new Byte[14] { 0x10, 0x01, 0x01, 0x00, 0x14, 0xe7, 0x00, 0x00, 0x00, 0x00,
                    RecvPacket[RecvPacket.Length - 4], 
                    RecvPacket[RecvPacket.Length - 3],
                    RecvPacket[RecvPacket.Length - 2], 
                    RecvPacket[RecvPacket.Length - 1] };

                /*10 01 01 00 14 e7 00 00 00 00 00 d4 d9 f7*/

                //here get client shitt(id, ip, etc)
                int tID = (RecvPacket[RecvPacket.Length - 4] << 24) | (RecvPacket[RecvPacket.Length - 3] << 16) | (RecvPacket[RecvPacket.Length - 2] << 8) | RecvPacket[RecvPacket.Length - 1];

                foreach (cWRClient _Client in Program.WRServer.getPlayers(false))
                {
                    if (_Client.getUserID() == tID)
                    {
                        _Client.setNetwork(IPeo); // Set UDP EndPoint @Client, because it needs this Information(Network IP, Network Port, Local IP, Local Port)
                        break;
                    }
                }
            }
            else
            {
                Response = new Byte[1] { 0x00 };
            }

            return Response;
        }
    }
}
