﻿using System;
using System.Runtime.InteropServices;
using System.Text;

namespace GameServer
{
    class cServerPacketHandler
    {
        [DllImport("winmm.dll")]
        public static extern long timeGetTime();

        private int OPC;
        private string[] Blocks = new String[0];

        public void newPacket(int iOPC)
        {
            OPC = iOPC;
        }

        public void AddBlock(object Block)
        {
            Array.Resize(ref Blocks, Blocks.Length + 1);
            Blocks[Blocks.Length - 1] = Convert.ToString(Block);
        }

        public byte[] getPacket(bool isISC)
        {
            string sPacket = String.Empty;

            sPacket =
                Convert.ToString(timeGetTime()) +
                Convert.ToChar(0x20) +
                Convert.ToString(OPC) +
                Convert.ToChar(0x20);

            for (int i = 0; i < Blocks.Length; i++)
            {
                sPacket += Blocks[i].Replace(Convert.ToChar(0x20), Convert.ToChar(0x1D)) + Convert.ToChar(0x20);
            }

            //new cLog(C.MSG_DEBUG, sPacket);

            if (isISC)
            {
                sPacket = Crypt(sPacket + Convert.ToChar(0x20) + Convert.ToChar(0x0A));
            }
            else
            {
                sPacket = Crypt2(sPacket + Convert.ToChar(0x20) + Convert.ToChar(0x0A));
            }

            return Encoding.Default.GetBytes(sPacket);
        }

        public string Crypt(string sPacket)
        {
            byte[] tTemp = Encoding.Default.GetBytes(sPacket);

            for (int i = 0; i < tTemp.Length; i++)
            {
                tTemp[i] = Convert.ToByte(tTemp[i] ^ 0x96);
            }
            return Encoding.Default.GetString(tTemp);
        }

        public string Crypt2(string sPacket)
        {
            byte[] tTemp = Encoding.Default.GetBytes(sPacket);

            for (int i = 0; i < tTemp.Length; i++)
            {
                tTemp[i] = Convert.ToByte(tTemp[i] ^ 0x11);
            }
            return Encoding.Default.GetString(tTemp);
        }

       
        public void AddRoomInfo(cWRRoom Room)
        {
            AddBlock(Room.getRoomID());
            AddBlock(1);
            AddBlock(Room.getRoomStatus());
            AddBlock(Room.getIDOfPlayer(Room.getRoomMaster()));
            AddBlock(Room.getRoomName());
            AddBlock(Room.HasPassword());
            AddBlock(Room.getMaxPlayer());
            AddBlock(Room.getPlayers().Count);
            AddBlock(Room.getMapID());
            AddBlock(0);
            AddBlock(2);
            AddBlock(0);
            AddBlock(Room.getRoomMode());//7
            AddBlock(4);
            if (Room.getRoomMode() != 7)
            {
                AddBlock(1);
            }
            else
            {
                if (Room.getPlayers().Count == 1)
                {
                    AddBlock(0); // 0 = unjoinable(grey room)
                }
                else
                {
                    AddBlock(1);
                }
            }
            AddBlock(4);
            AddBlock(0); // 1 = Room has Supermaster
            AddBlock(Room.getRoomType());
            AddBlock(Room.getLevelLimit());
            AddBlock(Room.getPremiumOnly());
            AddBlock(Room.getVoteKick());
            AddBlock(0);//autostart
            AddBlock(0); // ??
            AddBlock(Room.getPing());
            AddBlock(-1);
        }
    }
}