﻿using System;
using System.Net;
using System.Net.Sockets;
using System.Collections;

namespace GameServer
{
    class cWRServer
    {
        private ArrayList _Clients = new ArrayList();
        private ArrayList _CQCRooms = new ArrayList();
        private ArrayList _UORooms = new ArrayList();
        private ArrayList _BGRooms = new ArrayList();
        private ArrayList _AIRooms = new ArrayList();

        public void AddClient(cWRClient Client)
        {
            _Clients.Add(Client);
        }

        public void RemoveClient(cWRClient Client)
        {
            _Clients.Remove(Client);
        }

        public ArrayList getPlayerInChannel(int ChannelID)
        {
            ArrayList tList = new ArrayList();

            foreach(cWRClient Client in _Clients)
            {
                if (Client.getChannelID() == ChannelID)
                {
                    tList.Add(Client);
                }
            }
            return tList;
        }

        public ArrayList getPlayers(bool inRoom)
        {
            ArrayList Players = new ArrayList();

            if (inRoom == false)
            {
                foreach (cWRClient tPlayer in _Clients)
                { if (tPlayer.getRoom() == null) { Players.Add(tPlayer); } }
            }
            else
            {
                foreach (cWRClient tPlayer in _Clients)
                { if (tPlayer.getRoom() is cWRRoom) { Players.Add(tPlayer); } }
            }
            return Players;
        }

        public ArrayList getAllPlayers()
        {
            return _Clients;
        }

        public cWRClient getPlayerByNickname(string Nickname)
        {
            foreach (cWRClient Client in _Clients)
            {
                if (Client.getNickname().ToLower() == Nickname.ToLower())
                {
                    return Client;
                }
            }
            return (cWRClient)null;
        }

        public void AddRoom(cWRRoom Room, int ChannelID)
        {
            switch (ChannelID)
            {
                case 1:
                    _CQCRooms.Add(Room);
                    break;
                case 2:
                    _UORooms.Add(Room);
                    break;
                case 3:
                    _BGRooms.Add(Room);
                    break;
                case 4:
                    _AIRooms.Add(Room);
                    break;
            }
        }

        public void RemoveRoom(cWRRoom Room, int ChannelID)
        {
            switch (ChannelID)
            {
                case 1:
                    _CQCRooms.Remove(Room);
                    break;
                case 2:
                    _UORooms.Remove(Room);
                    break;
                case 3:
                    _BGRooms.Remove(Room);
                    break;
                case 4:
                    _AIRooms.Remove(Room);
                    break;
            }
        }

        public ArrayList getRoomsInChannel(int ChannelID)
        {
            switch (ChannelID)
            {
                case 1:
                    return _CQCRooms;
                case 2:
                    return _UORooms;
                case 3:
                    return _BGRooms;
                case 4:
                    return _AIRooms;
                default:
                    return new ArrayList();
            }
        }

        public cWRRoom getRoomByID(int ID, int ChannelID)
        {
            ArrayList Rooms = getRoomsInChannel(ChannelID);

            foreach (cWRRoom _Room in Rooms)
            {
                if (_Room.getRoomID() == ID)
                {
                    return _Room;
                }
            }
            return (cWRRoom)null;
        }

        public int PortToInt(int Port)
        {
            byte[] PortBytes = BitConverter.GetBytes(Port);
            byte[] PortBytesNew = new byte[2] { PortBytes[1], PortBytes[0] };
            ushort newPort = BitConverter.ToUInt16(PortBytesNew, 0);

            return newPort; 
        }
        public long IPToInt(string addr) {
            
            
          return (long)(uint)IPAddress.NetworkToHostOrder((int)IPAddress.Parse(ReverseIP(addr)).Address); 
        
        }
        public string IPToAddr(long address) { return IPAddress.Parse(address.ToString()).ToString(); }

        private string ReverseIP(string tString)
        {
            string[] bString = tString.Split(new char[] { '.' });
            string tNew = "";
            for (int i = (bString.Length - 1); i > -1; i--)
            { tNew += bString[i] + "."; }
            return tNew.Substring(0, tNew.Length - 1);
        }

        public object GetMaxValue(ArrayList arrList)
        {

            ArrayList sortArrayList = arrList;

            sortArrayList.Sort();

            sortArrayList.Reverse();

            return sortArrayList[0];

        }
    }
}
