﻿using System;
using System.Net;
using System.Net.Sockets;
using System.Timers;
using System.Threading;
using System.Text;
using System.Collections;

namespace GameServer
{
    class cServer
    {
       
        public Hashtable hTable = new Hashtable();
        private Socket ServerSocket = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
        private Socket ClientSocket;
        private Socket ServerSocketISC = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
        private Socket ClientSocketISC;
        private System.Timers.Timer aTimer = new System.Timers.Timer();
        private System.Timers.Timer bTimer = new System.Timers.Timer();
        private int tID = 0;

        public void StartServer()
        {
            try
            {
                ServerSocket.Bind(new IPEndPoint(IPAddress.Parse("0.0.0.0"), Program.ConfigClass.Server_Port));
               
                ServerSocket.Listen(0);
                new cLog(C.MSG_SUCCESS, "GameServer started");
            }
            catch
            {
                new cLog(C.MSG_ERROR, "Starting Server on Port: " + Program.ConfigClass.Server_Port + " failed");
                Console.Read();
            }

            setTimer();
            Thread AcceptThread = new Thread(new ThreadStart(AcceptConnections));
            AcceptThread.Start();
            new cLog(C.MSG_INFO, "Waiting for Connections...");
        }

        private void AcceptConnections()
        {
            while (true)
            {
                ClientSocket = ServerSocket.Accept();
                
                Thread RecvThread = new Thread(new ThreadStart(RecvData));
                RecvThread.Start();
                Thread.Sleep(10);
            }
        }

        private void ZombieHandler()
        {

        }
        private void RecvData()
        {
            Socket cSocket = ClientSocket;
            byte[] RecvBytes = new Byte[1024];
            byte[] RecvPacket;

            Int32 RecvBytesLen = 0;
            tID++;
            Program.ConfigClass.CurrentPlayer++;
            cWRClient WRClient = new cWRClient(cSocket, tID);
            WRClient.setUpPing();
            Program.WRServer.AddClient(WRClient);
            int Zombie1 = 5;
            int Wave1 = 0;
            while (true)
            {
                try
                {
                    RecvBytesLen = cSocket.Receive(RecvBytes);
                    //Console.WriteLine("Connection!");
                    if (cSocket.Connected == true && RecvBytesLen > 0)
                    {
                        RecvPacket = new Byte[RecvBytesLen];
                        Array.Copy(RecvBytes, RecvPacket, RecvBytesLen);

                        //Console.WriteLine("now handle");
                        WRClient.pHandler.Handle(Encoding.Default.GetString(RecvPacket), WRClient, false);

                        if (WRClient.getRoom() != null)
                        {
                            cWRRoom Room = WRClient.getRoom();
                         
                            WRClient.setupSpawn();
                        }


                     

                    }
                    
                }
                catch(Exception ex)
                {
                    
                    WRClient.tTimer.Stop();
                    Program.WRServer.RemoveClient(WRClient);
                    Program.SQL.conn.ExecuteQuery("UPDATE account SET online = '0' WHERE userID = '" + WRClient.getUserID().ToString() + "'");
                    Program.ConfigClass.CurrentPlayer--;

                    new cLog(C.MSG_ISC,ex.Message.ToString());
                    WRClient = null;
                    break;
                }
            }
        }

        private void setTimer()
        {
           // aTimer.Interval = 30000;
           // aTimer.Elapsed += new System.Timers.ElapsedEventHandler(RefreshISC);
           // aTimer.Start();
        }



        //private void setTimer2()
        //{
        //    bTimer.Interval = 1000;
        //    bTimer.Elapsed += new System.Timers.ElapsedEventHandler(SpawnZombies);
        //    bTimer.Start();
        //}




        private void SpawnZombies(Object myObject, EventArgs myEventArgs)
        {
            for (int i = 0; i < 29; i++)
            {
                
            }
        }

        public void SetUpHandlers()
        {
            addFunc(44441, new CP_ISC_LOGIN_PACKET());
            addFunc(91337, new CP_WELCOME_PACKET()); // 24832
            addFunc(25088, new CP_CHARACTER_INFO());
            addFunc(28673, new CP_CHANGE_CHANNEL());
            addFunc(29696, new CP_CHAT());
            addFunc(25600, new CP_PREMIUM_LEFT()); //Unknown Received Packet
            addFunc(28960, new CP_USER_LIST());
            addFunc(29970, new CP_CHANGE_WEAPON());
            addFunc(29440, new CP_CREATE_ROOM());
            addFunc(29504, new CP_LEAVE_ROOM());
            addFunc(29184, new CP_ROOM_LIST());
            addFunc(29456, new CP_JOIN_ROOM());
            addFunc(30000, new CP_CHANGE_ROOM_DATA());
            addFunc(29520, new CP_INVITE());
            addFunc(29505, new CP_ROOM_KICK());
            addFunc(30208, new CP_BUY_WEAPON());//habs schon mal rein gemacht :D
            addFunc(30032, new CP_UNKNOW());
            addFunc(24576, new CP_LEAVE_SERVER());
            addFunc(30257, new CP_LUCKY_SHOT());
            addFunc(30258, new CP_LUCKY_SHOT_WIN());
            addFunc(25605, new CP_COUPON_EVENT());
            addFunc(25606, new CP_COUPON_BUY());
            addFunc(29984, new CP_PLANT_BOMB());
            addFunc(30720, new CP_CREDITS());
            addFunc(30224, new CP_DELETE_WEAPON());
            addFunc(29488, new CP_SPECTACE_ROOM());
            addFunc(201942, new CP_CHECKSUM());
            addFunc(30230, new CP_BUYCOSTUME());
            addFunc(29971, new CP_CHANGE_COSTUME());
        }

        private void addFunc(int OPC, object Function)
        {
            if (hTable.ContainsKey(OPC) == false)
            {
                hTable.Add(OPC, Function);
            }
            else
            {
                new cLog(C.MSG_ERROR, "Operation Code: " + OPC + " has already an Function!");
            }
        }
    }
}
