﻿using System;
using System.Collections.Generic;
using System.Text;

using System.Diagnostics;

using System.Threading;

namespace GameServer
{
    class cCore
    {
        public bool isRunning = false;
        public bool isInitialized = false;
        public long freeRam = 0;
        public long usedRam = 0;
        public int onlinePlayers = 0;
        Process currentProcess = System.Diagnostics.Process.GetCurrentProcess();

        public cCore()
        {
            isRunning = false;
            isInitialized = true;

            usedRam = (currentProcess.WorkingSet64 / 1024);
            freeRam = (GC.GetTotalMemory(false) / 1024);

            Thread T = new Thread(new ThreadStart(ActualizeRam));
            T.Start();
        }

        public void ActualizeRam()
        {
            if (isRunning)
            {
                usedRam = currentProcess.WorkingSet64;
                freeRam = (GC.GetTotalMemory(false) / 1024);
                onlinePlayers = Program.cCollector.getAllPlayers().Count;


                Console.Title = "[ RamUsage: " + freeRam + "KB | Players : " + onlinePlayers+1 + "] InsomniaCore - GameServer";
                          
            }
            Thread.Sleep(200);
        }
    }
}
