﻿using Microsoft.VisualBasic;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;
namespace GameServer
{
    public static class Logger
    {

        public static void Success(string Message)
        {
            Output(ConsoleColor.DarkGreen, ConsoleColor.Green, Message);
        }
        public static void Error(string Message)
        {
            Output(ConsoleColor.DarkRed, ConsoleColor.Red, Message);
        }
        public static void Notification(string Message)
        {
            Output(ConsoleColor.DarkYellow, ConsoleColor.Yellow, Message);
        }
        public static void None(string Message)
        {
            Output(ConsoleColor.DarkGray, ConsoleColor.Gray, Message);
        }
#if DEBUG
        public static void Debug(string Message)
        {
            Output(ConsoleColor.DarkMagenta, ConsoleColor.Magenta, Message);
#endif
        }

        private static void Output(ConsoleColor ColorA, ConsoleColor ColorB, string Message)
        {
            StackFrame SF = new StackTrace().GetFrame(2);
            Console.ForegroundColor = ConsoleColor.White;
            Console.Write("[");
            Console.ForegroundColor = ConsoleColor.Gray;
            Console.Write(DateTime.Now.ToString());
            Console.ForegroundColor = ConsoleColor.White;
            Console.Write("] [");
            Console.ForegroundColor = ColorA;
            Console.Write(SF.GetMethod().ReflectedType.Name + "." + SF.GetMethod().Name);
            Console.ForegroundColor = ConsoleColor.White;
            Console.Write("] » ");
            Console.ForegroundColor = ColorB;
            Console.WriteLine(Message);
            Console.ForegroundColor = ConsoleColor.White;
        }

    }
}
