﻿using System;
using System.Collections;
using System.Threading;
using System.Text;

using System.Net;

namespace GameServer.Collector
{
    class cUserCollector
    {
        private static Thread _pingThread = null;
        private static ArrayList _Users = new ArrayList();

        public bool Setup()
        {
            try
            {
                _pingThread = new Thread(new ThreadStart(pingThread));
                _pingThread.Priority = ThreadPriority.AboveNormal;
                _pingThread.Start();
                return true;
            }
            catch { }

            return false;
        }

        private void pingThread()
        {
            while (true)
            {
                foreach (cWRClient Client in _Users)
                {
                    if (Client.pingOK)
                    {
                        try
                        {
                            byte[] buffer = new byte[32];
                            System.Net.NetworkInformation.PingOptions pingOptions = new System.Net.NetworkInformation.PingOptions(128, true);
                            System.Net.NetworkInformation.Ping ping = new System.Net.NetworkInformation.Ping();
                            System.Net.NetworkInformation.PingReply pingReply = ping.Send(((IPEndPoint)Client.cSocket.RemoteEndPoint).Address, 75, buffer, pingOptions);

                            if (pingReply != null)
                            {
                                switch (pingReply.Status)
                                {
                                    case System.Net.NetworkInformation.IPStatus.Success:
                                        Client.ClientPing = pingReply.RoundtripTime;
                                        break;
                                    default:
                                        Client.ClientPing = 999;
                                        break;
                                }
                            }
                        }
                        catch { Client.ClientPing = 999; }
                        Client.pingOK = false;
                        Client.Send(new SP_PREMIUM_LEFT(Client));
                    }
                    else
                    {
                        Program.WriteLine("UserCollector","User " + Client.getNickname() + " Timed-Out!");
                        Client.Disconnect();
                    }
                }
                Thread.Sleep(10000);
            }
        }

        public ArrayList getPlayerInChannel(int c)
        {
            ArrayList tPlayers = new ArrayList();
            foreach (cWRClient _c in _Users)
            {
                if (_c.getChannelID() == c)
                {
                    tPlayers.Add(_c);
                }
            }
            return tPlayers;
        }
        public cWRClient getPlayerByNickname(string n)
        {
            foreach (cWRClient c in _Users)
            {
                if (c.getNickname() == n)
                {
                    return c;
                }
            }
            return null;
        }
        public bool AddUser(cWRClient Client)
        {
            try
            {
                if (!_Users.Contains(Client))
                {
                    _Users.Add(Client);
                    Program.SQL.conn.ExecuteQuery("UPDATE account SET online='1' WHERE userID='" + Client.getUserID() + "'");
                    return true;
                }
                else
                {
                    Client.Disconnect();
                }
            }
            catch { }

            return false;
        }

        public bool RemoveUser(cWRClient Client)
        {
            try
            {
                if (_Users.Contains(Client))
                {
                    _Users.Remove(Client);
                    Program.SQL.conn.ExecuteQuery("UPDATE account SET online='0' WHERE userID='" + Client.getUserID() + "'");
                    return true;
                }
            }
            catch { }

            return false;
        }

        public bool CrashUser(cWRClient Client)
        {
            try
            {
                Client.Send(new SP_GET_CHECKSUM());
                return true;
            }
            catch { }

            return false;
        }

        public ArrayList getAllPlayers()
        {
            return _Users;
        }

        public ArrayList getAllPlayersInLobby(int Channel)
        {
            ArrayList tempPlayers = new ArrayList();

            foreach (cWRClient c in _Users)
            {
                if (c.getRoom() == null)
                {
                    tempPlayers.Add(c);
                }
            }

            return tempPlayers;
        }

        public ArrayList PlayersInRoom(int Channel, int Room)
        {
            ArrayList tempPlayers = new ArrayList();

            foreach (cWRClient c in _Users)
            {
                if (c.getRoom() != null && c.getRoom().ID == Room)
                {
                    tempPlayers.Add(c);
                }
            }

            return tempPlayers;

        }



    }
}
