﻿/* Copyright 2010 © by YeZZx aka Crunkx */
using System;
using System.Text;
using System.Collections;

namespace LoginServer
{
    class cClientPacketHandler
    {

        private string[] sBlocks;
        private long lTimestamp;
        private int iOPC;
        private int iC;

        public virtual void Handle(cClientPacketHandler Packet, cClient Client)
        {
        }

        public void HandlePacket(byte[] rPacket, cClient WRClient)
        {
            string tPacket = deCrypt(rPacket);
            sBlocks = tPacket.Split(new char[] { ' ' });
            lTimestamp = long.Parse(sBlocks[0]);
            iOPC = int.Parse(sBlocks[1]);
            iC = 0;

            Array.Copy(sBlocks, 2, sBlocks, 0, sBlocks.Length - 2);
            Hashtable hTable = cMain.ServerClass.getHandleTable();

            if (hTable.ContainsKey(iOPC))
            {
                cClientPacketHandler tHandler = (cClientPacketHandler)hTable[iOPC];
                tHandler.Handle(this, WRClient);
            }
            else
            {
                new cLog(C.MSG_ERROR, "No Handler for OPC: " + iOPC.ToString());
                new cLog(C.MSG_DEBUG, "New Unknown Packet: " + tPacket);
            }
        }

        private string deCrypt(byte[] tBytes)
        {
            for (int i = 0; i < tBytes.Length; i++)
            {
                tBytes[i] = Convert.ToByte(tBytes[i] ^ 0xC3);
            }

            return Encoding.Default.GetString(tBytes);
        }

        public string getBlock()
        {
            string tBlock = sBlocks[iC];
            iC++;
            return tBlock;
        }

        public string getBlockByIndex(int iIndex)
        {
            return sBlocks[iIndex];
        }
    }
}
/* Copyright 2010 © by YeZZx aka Crunkx */