﻿/* Copyright 2010 © by YeZZx aka Crunkx */
using System;
using System.IO;
using System.Text;
using System.Security.Permissions;

namespace LoginServer
{
    class cLogSystem
    {
        private StreamWriter sWriter;

        [SecurityPermission(SecurityAction.Demand, Flags = SecurityPermissionFlag.ControlAppDomain)]
        public cLogSystem()
        {
            AppDomain currentDomain = AppDomain.CurrentDomain;

            createLog();
            currentDomain.UnhandledException += new UnhandledExceptionEventHandler(LogError);
        }

        private void createLog()
        {
            string sFileName = "LoginSystem_" + DateTime.Now.ToString("yyyyMMdd_HHmmss") + ".log";
            string sPath = Environment.CurrentDirectory + @"\..\Logs\SystemLogs\";

            sWriter = new StreamWriter((sPath + sFileName));
            addLog("Login Server Start");
        }

        private void addLog(string sValue)
        {
            string sPrefix = DateTime.Now.ToString("dd-MM HH:mm:ss");
            sWriter.WriteLine((sPrefix + "|" + sValue));
            sWriter.Flush();
        }

        private void LogError(object sender, UnhandledExceptionEventArgs eArgs)
        {
            Exception e = (Exception)eArgs.ExceptionObject;
            new cLog(C.MSG_ERROR, e.Message);
            addLog("Error: " + e.Message);
        }
    }
}
/* Copyright 2010 © by YeZZx aka Crunkx */