/*
 * Decompiled with CFR 0.152.
 */
package kreverse.krlib;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import kreverse.krlib.RemoteEndpoint;

public class KRClient
implements Runnable {
    private static Object groupChat;
    private static Method compress;
    private static Method decompress;
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    private byte[] decodeKey;
    private String passwordKey;
    private String nickname;
    private String password;
    private String channel;
    private boolean connected;

    private void start() {
        this.decodeKey = null;
        this.passwordKey = null;
        this.nickname = null;
        this.connected = true;
        new Thread(this).start();
    }

    public final boolean isConnected() {
        return this.connected;
    }

    public final void connect(String string, int n) throws IOException {
        this.socket = new Socket(string, n);
        this.start();
    }

    public final void connect(RemoteEndpoint remoteEndpoint) throws IOException {
        this.connect(remoteEndpoint.getHost(), remoteEndpoint.getPort());
    }

    public final void connect(String string, int n, String string2, int n2) throws IOException {
        this.socket = new Socket(new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(string2, n2)));
        this.socket.connect(new InetSocketAddress(string, n));
        this.start();
    }

    public final void connect(RemoteEndpoint remoteEndpoint, String string, int n) throws IOException {
        this.connect(remoteEndpoint.getHost(), remoteEndpoint.getPort(), string, n);
    }

    public final void login(String string, String string2, String string3) {
        this.send(String.format("n\u0000%s\u0000%s\u0000%s\u0000F", string3, string, string2));
    }

    public final void sendMessage(String string, String string2) {
        this.send(String.format("e\u0000%s\u0000%s", string2, string));
    }

    public void onReceive(String string) {
    }

    public void onDisconnect() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public final void run() {
        try {
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            this.out.write(0);
            this.send(String.format("t\u0000\u0000%s\u0000%d\u0000%s\u0000%s\u0000%d\u0000%s\u0000", " ", 0, System.getProperty("java.version"), "-", this.socket.getLocalPort(), System.getProperty("java.vm.name"), "-,null"));
            while (true) {
                String string;
                int n;
                int n2;
                int n3;
                if ((n3 = this.in.read()) == -1) {
                    return;
                }
                byte by = (byte)n3;
                if (by >= 0) {
                    n2 = by + 1;
                } else {
                    n2 = (by & 0x1F) + 1;
                    int n4 = (by & 0x60) >>> 5;
                    for (n = 0; n < n4; n2 += this.in.read() << (n << 3) + 5, ++n) {
                    }
                }
                byte[] byArray = new byte[n2];
                for (n = 0; n < n2; ++n) {
                    byArray[n] = (byte)((byte)this.in.read() ^ (this.decodeKey != null && n < this.decodeKey.length ? this.decodeKey[n] : (byte)0));
                }
                String[] stringArray = groupChat;
                // MONITORENTER : groupChat
                try {
                    string = (String)decompress.invoke(groupChat, new Object[]{byArray});
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    string = "";
                }
                if (string.startsWith("(\u0000")) {
                    stringArray = string.split("\u0000");
                    String string2 = stringArray[3].trim();
                    this.decodeKey = string2.getBytes();
                    this.passwordKey = stringArray[1] + string2.substring(1);
                    if (this.nickname != null) {
                        this.login(this.nickname, this.password, this.channel);
                        this.nickname = null;
                    }
                } else if (string.startsWith(",")) {
                    if (string.length() == 1) {
                        this.send("h\u0000-");
                    } else {
                        this.send(String.format("h\u0000%s", string.substring(2)));
                    }
                }
                this.onReceive(string);
            }
        }
        catch (IOException iOException) {
            if (this.socket == null) return;
            if (this.socket.isClosed()) return;
            iOException.printStackTrace();
            return;
        }
        finally {
            if (this.socket != null && !this.socket.isClosed()) {
                this.onDisconnect();
                this.disconnect();
            }
            this.connected = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void send(String string) {
        if (string.startsWith("n\u0000")) {
            if (this.passwordKey == null) {
                String[] stringArray = string.split("\u0000");
                this.nickname = stringArray[2];
                this.password = stringArray[3];
                this.channel = stringArray[1];
                return;
            }
            string = String.format("%s\u0000%s", string, this.passwordKey);
        }
        if (this.socket != null) {
            try {
                byte[] byArray;
                byte[] byArray2;
                Object object = groupChat;
                synchronized (object) {
                    try {
                        byArray2 = (byte[])compress.invoke(groupChat, string);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        byArray2 = new byte[]{};
                    }
                }
                int n = byArray2.length - 1;
                if (n < 128) {
                    byArray = new byte[]{(byte)n};
                } else {
                    int n2 = 0;
                    while (32 << (n2 + 1 << 3) <= n) {
                        ++n2;
                    }
                    byArray = new byte[++n2 + 1];
                    byArray[0] = (byte)(n2 << 5 | 0x80 | n & 0x1F);
                    for (int i = 1; i < byArray.length; ++i) {
                        byArray[i] = (byte)(n >>> 8 * (i - 1) + 5);
                    }
                }
                byte[] byArray3 = new byte[byArray.length + byArray2.length];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
                this.out.write(byArray3);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public final void disconnect() {
        if (this.socket != null) {
            try {
                if (this.out != null) {
                    this.out.close();
                }
                if (this.in != null) {
                    this.in.close();
                }
                this.socket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("GroupChat");
            groupChat = clazz.newInstance();
            compress = clazz.getMethod("compress", String.class);
            decompress = clazz.getMethod("decompress", byte[].class);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

