import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/**
 *
 * @author Flav
 */
public class Bridge {
	private ph groupChat;

	public Bridge() {
		groupChat = new ph("", 0);
		groupChat.init();
	}

	private void listen() {
		try {
			DataInputStream in = new DataInputStream(System.in);
			DataOutputStream out = new DataOutputStream(System.out);

			while (true) {
				byte action = in.readByte();
				int length = in.readInt();
				byte[] buffer = new byte[length];
				in.read(buffer, 0, length);

				switch (action) {
					case 0x01:
						buffer = groupChat.compress(buffer);
						break;
					case 0x02:
						buffer = groupChat.decompress(buffer);
						break;
				}

				out.writeInt(buffer.length);
				out.write(buffer);
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public static void main(String args[]) {
		new Bridge().listen();
	}
}
