import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;

/**
 *
 * @author Flav
 */
public class Manipulator {
	public static void main(String[] args) {
		ClassPool pool = ClassPool.getDefault();

		try {
			CtClass groupChat = pool.get("ph");

			groupChat.addField(CtField.make(
				"private String hello;"
			, groupChat));

			groupChat.addField(CtField.make(
				"private String password;"
			, groupChat));

			groupChat.addMethod(CtMethod.make(
				"public void init() {"
			+		"ag(this.dq);"
			+	"}"
			, groupChat));

			groupChat.getDeclaredMethod(
				"i", new CtClass[] { pool.get("java.lang.String") }
			).setBody(
				"{"
			+		"if ($1.startsWith(\"t\0\")) {"
			+			"hello = $1;"
			+			"return true;"
			+		"} else if ($1.startsWith(\"n\0\")) {"
			+			"password = $1.split(\"\0\")[3];"
			+			"return true;"
			+		"}"

			+		"return b($1, false);"
			+	"}"
			);

			groupChat.addMethod(CtMethod.make(
				"public byte[] compress(byte[] param1) {"
			+		"String token = new String($1, \"UTF-8\");"

			+		"if (token.startsWith(\"t\0\")) {"
			+			"ad();"
			+			"token = hello;"
			+		"} else if (token.startsWith(\"n\0\")) {"
			+			"String[] tokens = token.split(\"\0\");"

			+			"if (!d3.equals(tokens[5])) {"
			+				"ap();" // reset
			+				"d3 = tokens[5];" // key
			+			"}"

			+			"a(\"\", tokens[3], \"\", false);"
			+			"tokens[3] = password;"
			+			"StringBuilder buffer = new StringBuilder(tokens[0]);"

			+			"for (int i = 1; i < tokens.length - 1; i++) {"
			+				"buffer.append(\"\0\");"
			+				"buffer.append(tokens[i]);"
			+			"}"

			+			"token = buffer.toString();"
			+		"}"

			+		"return dr.a(token, 0);"
			+	"}"
			, groupChat));

			groupChat.addMethod(CtMethod.make(
				"public byte[] decompress(byte[] param1) {"
			+		"return dx.a($1).getBytes(\"UTF-8\");"
			+	"}"
			, groupChat));

			groupChat.writeFile();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
