/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;

class TransLabel
extends Component {
    public static final int LEFT = 131072;
    public static final int MIDDLE = 262144;
    public static final int RIGHT = 524288;
    public static final int CEILING = 0x800000;
    public static final int CENTERED = 0x1000000;
    public static final int FLOOR = 0x2000000;
    public static final int UNDERLINED = 1;
    public String label = null;
    private Font font = null;
    private Color color = null;
    private Color backgroundColor = null;
    private int height = 0;
    private int width = 0;
    private int ascent = 0;
    private int baseheight = 0;
    private int alignment = 0x880000;

    TransLabel() {
        this("");
    }

    TransLabel(String string) {
        this.label = string;
        this.font = new Font("Arial", 0, 12);
        this.color = Color.black;
        this.alignment = 0;
    }

    public void addAttribute(int n) {
        this.alignment ^= n;
    }

    public void calcExtend() {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        this.width = fontMetrics.stringWidth(this.label);
        this.height = fontMetrics.getHeight();
        this.ascent = fontMetrics.getAscent();
        this.baseheight = this.height - this.ascent;
    }

    public Color getBackground() {
        return this.backgroundColor;
    }

    public Color getForeground() {
        return this.color;
    }

    public int getWidth() {
        return this.getXPos() + this.width;
    }

    public int getXPos() {
        if ((this.alignment & 0x40000) != 0) {
            return (this.getBounds().width - this.width + 1) / 2;
        }
        if ((this.alignment & 0x80000) != 0) {
            return this.getBounds().width - 2 - this.width;
        }
        return 2;
    }

    public int getYPos() {
        if ((this.alignment & 0x800000) != 0) {
            return 2 + this.ascent;
        }
        if ((this.alignment & 0x2000000) != 0) {
            return this.getBounds().height - 2 - this.height + this.ascent;
        }
        return (this.getBounds().height - this.height) / 2 + this.ascent;
    }

    public void paint(Graphics graphics) {
        if (this.backgroundColor != null) {
            graphics.setColor(this.backgroundColor);
            graphics.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        }
        graphics.setFont(this.font);
        graphics.setColor(this.color);
        int n = this.getXPos();
        int n2 = this.getYPos();
        graphics.drawString(this.label, n, n2);
        if ((this.alignment & 1) != 0) {
            graphics.drawLine(n, n2 + this.baseheight / 2, n + this.width, n2 + this.baseheight / 2);
        }
    }

    public Dimension preferredSize() {
        this.calcExtend();
        return new Dimension(this.width + 4, this.height + 4);
    }

    public void setBackground(Color color) {
        this.backgroundColor = color;
        this.repaint();
    }

    public void setFont(Font font) {
        if (font != null) {
            this.font = font;
            this.calcExtend();
        }
    }

    public void setForeground(Color color) {
        this.color = color;
        this.repaint();
    }

    public void setText(String string) {
        this.label = string;
        this.calcExtend();
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

