/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

class VoteFrame
extends Frame
implements ItemListener {
    private int numKandidates;
    private int maxPos;
    private int maxNeg;
    private int actPos;
    private int actNeg;
    private String topic;
    private GroupChat gc;
    private TextPanel infoPanel;
    private TextPanel posPanel;
    private TextPanel negPanel;
    private TextPanel descrPanel;
    private Choice kandidates;
    private Button plus;
    private Button minus;
    private Button send;
    private int[] votes;
    private String[] names;
    private String[] infos;
    private int numNames;

    public VoteFrame(int n, int n2, int n3, String string, GroupChat groupChat) {
        super(String.valueOf(groupChat.getTranslation(53)) + string);
        this.numKandidates = n;
        this.maxPos = n2;
        this.maxNeg = n3;
        this.topic = string;
        this.gc = groupChat;
        ((Component)this).setBackground(Color.white);
        this.setResizable(false);
        this.move(30, 20);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel(new GridLayout(2, 2, 4, 4));
        this.add("North", panel);
        this.numNames = 0;
        this.actNeg = n3;
        this.actPos = n2;
        this.votes = new int[this.numKandidates];
        this.names = new String[this.numKandidates];
        this.infos = new String[this.numKandidates];
        this.descrPanel = new TextPanel(groupChat, 30, 300, true, true, false, false);
        this.infoPanel = new TextPanel(groupChat, 30, 300, true, true, true, false);
        this.posPanel = new TextPanel(groupChat, this.numKandidates, this.numKandidates * 4, true, true, true, false);
        this.negPanel = new TextPanel(groupChat, this.numKandidates, this.numKandidates * 4, true, true, true, false);
        this.posPanel.forceSize(225, 175);
        Font font = TextPanel.requestFont(0, 0, 0, 16);
        this.kandidates = new Choice();
        this.kandidates.setFont(font);
        this.kandidates.addItemListener(this);
        this.kandidates.add(groupChat.getTranslation(54));
        Panel panel2 = new Panel(new BorderLayout());
        Panel panel3 = new Panel(new BorderLayout());
        Panel panel4 = new Panel(new BorderLayout());
        Panel panel5 = new Panel(new FlowLayout());
        TransLabel transLabel = new TransLabel(groupChat.getTranslation(55));
        transLabel.setFont(TextPanel.requestFont(0, 0, 0, 20));
        transLabel.setBackground(Color.lightGray);
        transLabel.setForeground(Color.blue);
        panel2.add("North", transLabel);
        panel2.add("Center", panel3);
        panel3.add("North", panel4);
        font = TextPanel.requestFont(0, 0, 0, 18);
        this.plus = new Button(" + ");
        this.minus = new Button(" - ");
        this.plus.setForeground(Color.green);
        this.minus.setForeground(Color.red);
        this.plus.setFont(font);
        this.minus.setFont(font);
        panel4.add("West", this.minus);
        panel4.add("East", this.plus);
        panel4.add("Center", this.kandidates);
        panel4.setBackground(Color.lightGray);
        panel3.add("Center", this.descrPanel);
        this.send = new Button(groupChat.getTranslation(56));
        this.send.setFont(font);
        panel2.add("South", this.send);
        panel.add(panel2);
        panel.add(this.infoPanel);
        panel.add(this.negPanel);
        panel.add(this.posPanel);
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.send) {
            this.gc.sendElection(this.topic, this.names, this.votes);
            this.dispose();
            return true;
        }
        if (event.target == this.plus || event.target == this.minus) {
            int n = this.kandidates.getSelectedIndex();
            if (--n >= 0) {
                if (event.target == this.plus) {
                    if (this.votes[n] >= 0) {
                        if (this.actPos > 0) {
                            int n2 = n;
                            this.votes[n2] = this.votes[n2] + 1;
                            --this.actPos;
                        }
                    } else {
                        int n3 = n;
                        this.votes[n3] = this.votes[n3] + 1;
                        ++this.actNeg;
                    }
                } else if (this.votes[n] <= 0) {
                    if (this.actNeg > 0) {
                        int n4 = n;
                        this.votes[n4] = this.votes[n4] - 1;
                        --this.actNeg;
                    }
                } else {
                    int n5 = n;
                    this.votes[n5] = this.votes[n5] - 1;
                    ++this.actPos;
                }
                this.updateVotePanels();
            }
        }
        return super.action(event, object);
    }

    public void add(String string, String string2) {
        if (this.numNames < this.numKandidates) {
            this.kandidates.add(string);
            this.names[this.numNames] = string;
            this.infos[this.numNames] = string2;
            this.votes[this.numNames] = 0;
            ++this.numNames;
            if (this.numNames == this.numKandidates) {
                this.pack();
                this.show();
                this.itemStateChanged(null);
                this.updateVotePanels();
            }
        }
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.dispose();
        }
        return super.handleEvent(event);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.kandidates.getSelectedIndex();
        if (--n >= 0) {
            this.infoPanel.inhalt.remove();
            this.infoPanel.print("\u00b020B\u00b0Info:\u00b0r\u00b0#" + this.infos[n]);
        } else {
            this.infoPanel.inhalt.remove();
            this.infoPanel.print("\u00b020B\u00b0Info:");
        }
    }

    public void updateVotePanels() {
        String string = "\u00b020B\u00b0" + this.gc.getTranslation(57) + ":\u00b0r\u00b0##";
        String string2 = "\u00b020B\u00b0" + this.gc.getTranslation(58) + ":\u00b0r\u00b0##";
        int n = 0;
        while (n < this.numKandidates) {
            if (this.votes[n] > 0) {
                string = String.valueOf(string) + this.names[n] + " _(" + this.votes[n] + ")_#";
            }
            if (this.votes[n] < 0) {
                string2 = String.valueOf(string2) + this.names[n] + " _(" + this.votes[n] + ")_#";
            }
            ++n;
        }
        this.descrPanel.inhalt.remove();
        this.descrPanel.print(String.valueOf(this.gc.getTranslation(59)) + this.actNeg + this.gc.getTranslation(60) + this.actPos + this.gc.getTranslation(61));
        this.posPanel.inhalt.remove();
        this.posPanel.print(string);
        this.negPanel.inhalt.remove();
        this.negPanel.print(string2);
    }
}

