/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class HyperList
extends Panel {
    public Scrollbar schieber = null;
    private Content inhalt = null;
    private Image backgroundImage = null;
    private int imageFlags = 0;
    private static final int ICON_XSIZE = 18;
    private static final int ICON_YSIZE = 18;
    private static final int INSET_XSIZE = 2;
    private static final int INSET_YSIZE = 4;
    private static final int XSCROLLSPEED = 3;
    private Font NOSIZEFONT = new Font("Arial", 0, 1);
    public int STANDARDFONTSIZE = 15;
    private Color selectionBColor = new Color(0, 0, 128);
    private Color selectionFColor = Color.white;
    private Color specialColor = new Color(128, 0, 0);
    public Color backgroundColor = Color.lightGray;
    private Color foregroundColor = Color.black;
    ActionListener al = null;
    Object fakeSource = this;
    public boolean backgroundUpdateNeeded = false;
    private int paintCount = 0;
    private int nextLevel = 1;
    private final int maxCount = 65536;
    private int forcedWidth = -1;
    private int forcedHeight = -1;
    private int selectionCount = 0;
    private boolean multipleSelections;
    private boolean specialSelected = false;

    public HyperList(ActionListener actionListener, boolean bl, Color color) {
        super(new BorderLayout());
        this.multipleSelections = bl;
        this.al = actionListener;
        if (color != null) {
            this.backgroundColor = color;
        }
        this.inhalt = new Content();
        this.setBackground(null);
        this.inhalt.addMouseListener(this.inhalt);
        this.inhalt.setBackground(color);
        this.add("Center", this.inhalt);
        this.inhalt.addMouseMotionListener(this.inhalt);
        this.inhalt.addComponentListener(this.inhalt);
        this.inhalt.addKeyListener(this.inhalt);
        this.schieber = new Scrollbar(1, 1, 1, 0, 1);
        this.schieber.addAdjustmentListener(this.inhalt);
        this.schieber.setBackground(color);
        this.add("East", this.schieber);
    }

    public int addEntry(String string, Color color, Font font) {
        int n = string.indexOf(10);
        String string2 = string;
        String string3 = string;
        if (n >= 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        return this.inhalt.addEntry(string2, string3, color, font);
    }

    public int addEntry(String string, String string2, Color color, Font font) {
        return this.inhalt.addEntry(string, string2, color, font);
    }

    public void addIcon(int n, Image image, Integer n2) {
        this.inhalt.addIcon(n, image, n2);
    }

    public int countItems() {
        return this.inhalt.countItems();
    }

    public void delIcon(int n, Image image) {
        this.inhalt.delIcon(n, image);
    }

    public void deleteAll() {
        this.inhalt.deleteAll();
    }

    public void deleteEntry(int n) {
        this.inhalt.deleteEntry(n);
    }

    public void deselect(int n) {
        this.inhalt.deselect(n);
    }

    public void forceSize(int n, int n2) {
        this.forcedWidth = n;
        this.forcedHeight = n2;
    }

    public int getFirstSelectedIndex() {
        return this.inhalt.getFirstSelectedIndex();
    }

    public Dimension getForcedSize() {
        return new Dimension(this.forcedWidth, this.forcedHeight);
    }

    public String getItem(int n) {
        return this.inhalt.getItem(n);
    }

    public String[] getItems() {
        return this.inhalt.getItems();
    }

    public String[] getSelectedItems() {
        return this.inhalt.getSelectedItems();
    }

    public boolean isInSpecialMode() {
        return this.specialSelected;
    }

    public Dimension preferredSize() {
        if (this.forcedWidth >= 0 && this.forcedHeight >= 0) {
            return new Dimension(this.forcedWidth, this.forcedHeight);
        }
        return super.preferredSize();
    }

    public void select(int n) {
        this.inhalt.select(n);
    }

    public void setBackgroundImage(Image image, int n) {
        this.backgroundImage = image;
        this.imageFlags = n;
        this.paintCount = 0;
        this.nextLevel = 1;
        this.backgroundUpdateNeeded = true;
        this.inhalt.repaint();
    }

    public void setSpecial(int n, boolean bl) {
        this.inhalt.setSpecial(n, bl);
    }

    public void update(Graphics graphics) {
        super.paint(graphics);
    }

    public class Content
    extends Component
    implements ComponentListener,
    AdjustmentListener,
    KeyListener,
    MouseListener,
    MouseMotionListener {
        private Vector words;
        private Vector shownWords;
        private Vector fonts;
        private Vector colors;
        private Vector selections;
        private Vector icons;
        private Vector sizes;
        private Vector drawnImages;
        private Vector newDrawnImages;
        private int delta = 0;
        private int deltaX = 0;
        private int virtualWidth = 0;
        private int virtualHeight = 0;
        private int maxItemHeight = 0;
        private int screenWidth = -1;
        private int screenHeight = -1;
        private boolean mouseInside = false;
        private boolean scrollLeft = false;
        private boolean scrollRight = false;
        private Image puffer = null;
        private Image pufferImg = null;
        private Graphics pg = null;
        private Graphics pgImg = null;
        private boolean paintInProgress = false;
        private boolean repaintNeeded = false;
        private Color veryLightGray = new Color(224, 224, 224);

        public Content() {
            this.words = new Vector(100, 100);
            this.shownWords = new Vector(100, 100);
            this.fonts = new Vector(100, 100);
            this.colors = new Vector(100, 100);
            this.selections = new Vector(100, 100);
            this.icons = new Vector(100, 100);
            this.sizes = new Vector(100, 100);
            this.newDrawnImages = new Vector(3, 5);
            this.drawnImages = new Vector(3, 5);
        }

        public synchronized int addEntry(String string, String string2, Color color, Font font) {
            if (color == null) {
                color = HyperList.this.foregroundColor;
            }
            if (string2 == null) {
                string2 = string;
            }
            Rectangle rectangle = this.calculateExtend(string2, font);
            int n = this.words.size();
            this.words.addElement(string);
            this.shownWords.addElement(string2);
            this.fonts.addElement(font);
            this.colors.addElement(color);
            this.selections.addElement(null);
            this.icons.addElement(new Vector(1, 2));
            this.sizes.addElement(rectangle);
            this.reDoLayout();
            return n;
        }

        public synchronized void addIcon(int n, Image image, Integer n2) {
            if (image != null) {
                ((Vector)this.icons.elementAt(n)).addElement(image);
                if (n2 != null) {
                    ((Vector)this.icons.elementAt(n)).addElement(n2);
                }
                this.repaint();
            }
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            this.setDelta(HyperList.this.schieber.getValue());
            this.repaint();
        }

        public Rectangle calculateExtend(String string, Font font) {
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(HyperList.this.NOSIZEFONT);
            fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            int n = fontMetrics.stringWidth(string);
            int n2 = fontMetrics.getHeight();
            int n3 = fontMetrics.getAscent();
            int n4 = n2 - n3;
            return new Rectangle(n4, n3, n, n2);
        }

        private void checkDelta() {
            if (this.delta + this.screenHeight - 3 > this.virtualHeight) {
                this.delta = this.virtualHeight - this.screenHeight + 3;
            }
            if (this.delta < 0) {
                this.delta = 0;
            }
        }

        private void checkDeltaX() {
            if (this.deltaX > this.virtualWidth - this.screenWidth) {
                this.deltaX = this.virtualWidth - this.screenWidth;
            }
            if (this.deltaX < 0) {
                this.deltaX = 0;
            }
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.setDelta(0);
            this.repaint();
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public int countItems() {
            return this.words.size();
        }

        public void delIcon(int n, Image image) {
            Content content = this;
            synchronized (content) {
                Vector vector = (Vector)this.icons.elementAt(n);
                int n2 = 0;
                while (n2 < vector.size()) {
                    if ((Image)vector.elementAt(n2) == image) {
                        vector.removeElementAt(n2);
                        if (n2 >= vector.size() || !(vector.elementAt(n2) instanceof Integer)) break;
                        vector.removeElementAt(n2);
                        break;
                    }
                    ++n2;
                }
            }
            this.repaint();
        }

        public synchronized void deleteAll() {
            int n = this.words.size() - 1;
            while (n >= 0) {
                if (this.isSelected(n)) {
                    this.deselect(n);
                }
                this.words.removeElementAt(n);
                this.shownWords.removeElementAt(n);
                this.fonts.removeElementAt(n);
                this.colors.removeElementAt(n);
                this.selections.removeElementAt(n);
                this.icons.removeElementAt(n);
                this.sizes.removeElementAt(n);
                --n;
            }
            this.reDoLayout();
        }

        public synchronized void deleteEntry(int n) {
            if (this.isSelected(n)) {
                this.deselect(n);
            }
            this.words.removeElementAt(n);
            this.shownWords.removeElementAt(n);
            this.fonts.removeElementAt(n);
            this.colors.removeElementAt(n);
            this.selections.removeElementAt(n);
            this.icons.removeElementAt(n);
            this.sizes.removeElementAt(n);
            this.reDoLayout();
        }

        public void deselect(int n) {
            try {
                if (this.isSelected(n)) {
                    if (HyperList.this.specialSelected && HyperList.this.al != null) {
                        HyperList.this.al.actionPerformed(new ActionEvent(HyperList.this.fakeSource, 0, "s", 0));
                    }
                    this.selections.setElementAt(null, n);
                    HyperList hyperList = HyperList.this;
                    hyperList.selectionCount = hyperList.selectionCount - 1;
                    this.repaint();
                }
            }
            catch (Exception exception) {
                System.err.println("ERROR: unknown item deselected. " + exception);
            }
        }

        public synchronized int getFirstSelectedIndex() {
            boolean bl = false;
            int n = 0;
            while (n < this.words.size()) {
                if (this.isSelected(n)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public String getItem(int n) {
            try {
                return (String)this.words.elementAt(n);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public synchronized String[] getItems() {
            String[] stringArray = new String[this.words.size()];
            int n = this.words.size() - 1;
            while (n >= 0) {
                stringArray[n] = (String)this.words.elementAt(n);
                --n;
            }
            return stringArray;
        }

        public synchronized String[] getSelectedItems() {
            String[] stringArray = new String[HyperList.this.selectionCount];
            int n = 0;
            int n2 = this.words.size() - 1;
            while (n2 >= 0) {
                if (this.isSelected(n2)) {
                    stringArray[n++] = (String)this.words.elementAt(n2);
                }
                --n2;
            }
            return stringArray;
        }

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if ((n & 0x30) == 0) {
                if ((n & 0xC0) == 0) {
                    return true;
                }
                if (image == HyperList.this.backgroundImage) {
                    HyperList.this.backgroundImage = null;
                }
                this.repaint();
                return false;
            }
            if (image == HyperList.this.backgroundImage) {
                HyperList.this.backgroundUpdateNeeded = true;
            }
            this.repaint();
            return (n & 0x10) != 0 && this.drawnImages.contains(image);
        }

        public boolean isSelected(int n) {
            return this.selections.elementAt(n) != null;
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.mouseInside = false;
            if (this.deltaX > 0) {
                this.repaint();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            this.mouseInside = true;
            this.scrollLeft = n < this.screenWidth / 4 && this.deltaX > 0;
            boolean bl = this.scrollRight = n >= 3 * this.screenWidth / 4 && this.deltaX < this.virtualWidth - this.screenWidth;
            if (this.scrollLeft || this.scrollRight) {
                this.repaint();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = this.maxItemHeight > 0 ? (n2 + this.delta) / this.maxItemHeight : this.words.size() + 10;
            if (n3 < this.words.size()) {
                int n4 = mouseEvent.getModifiers();
                char c = '-';
                if ((n4 & 4) != 0) {
                    c = mouseEvent.getClickCount() < 2 ? (char)'r' : 'R';
                } else if ((n4 & 8) != 0) {
                    c = mouseEvent.getClickCount() < 2 ? (char)'m' : 'M';
                } else if (mouseEvent.getClickCount() == 1) {
                    if (this.isSelected(n3)) {
                        this.deselect(n3);
                    } else {
                        this.select(n3);
                    }
                    c = 'l';
                } else {
                    if (HyperList.this.multipleSelections) {
                        if (this.isSelected(n3)) {
                            this.deselect(n3);
                        } else {
                            this.select(n3);
                        }
                    } else {
                        this.setSpecial(n3, true);
                    }
                    c = 'L';
                }
                if (HyperList.this.al != null) {
                    HyperList.this.al.actionPerformed(new ActionEvent(HyperList.this.fakeSource, n4, String.valueOf(c) + (String)this.words.elementAt(n3), n4));
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public synchronized void paint(Graphics graphics) {
            this.paintInProgress = true;
            this.repaintNeeded = false;
            if (this.mouseInside) {
                if (this.scrollLeft && this.deltaX > 0) {
                    this.deltaX -= 3;
                    this.repaintNeeded = true;
                } else if (this.scrollRight && this.deltaX < this.virtualWidth - this.screenWidth) {
                    this.deltaX += 3;
                    this.repaintNeeded = true;
                }
            } else if (this.deltaX > 0) {
                this.deltaX -= 3;
                this.repaintNeeded = true;
            }
            this.checkDeltaX();
            this.newDrawnImages.removeAllElements();
            HyperList.this.schieber.setValues(this.delta, this.screenHeight, 0, this.virtualHeight);
            int n = this.getSize().width - 2;
            int n2 = this.getSize().height - 4;
            if (n <= 0 || n2 <= 0) {
                return;
            }
            if (this.puffer == null || n != this.screenWidth || n2 != this.screenHeight) {
                this.puffer = this.createImage(n, n2);
                this.pg = this.puffer.getGraphics();
                this.pufferImg = this.createImage(n, n2);
                this.pgImg = this.pufferImg.getGraphics();
                this.screenWidth = n;
                this.screenHeight = n2;
                HyperList.this.backgroundUpdateNeeded = true;
            }
            n += 2;
            n2 += 4;
            if (HyperList.this.backgroundUpdateNeeded) {
                HyperList.this.backgroundUpdateNeeded = false;
                if (HyperList.this.backgroundImage != null) {
                    this.paintBackground(this.pgImg, HyperList.this.backgroundImage, n, n2);
                }
            }
            this.pg.setColor(HyperList.this.backgroundColor);
            if (HyperList.this.backgroundImage == null) {
                this.pg.fillRect(0, 0, n, n2);
            } else {
                this.pg.drawImage(this.pufferImg, 0, 0, this);
            }
            if (this.maxItemHeight > 0 || this.words.size() > 0) {
                int n3 = this.words.size();
                int n4 = this.delta / this.maxItemHeight;
                int n5 = n4 * this.maxItemHeight - this.delta;
                while (n5 < this.screenHeight && n4 < n3) {
                    int n6 = 3 - this.deltaX;
                    Rectangle rectangle = (Rectangle)this.sizes.elementAt(n4);
                    Object e = this.selections.elementAt(n4);
                    if (e != null) {
                        if (HyperList.this.specialSelected) {
                            this.pg.setColor(HyperList.this.specialColor);
                        } else {
                            this.pg.setColor(HyperList.this.selectionBColor);
                        }
                        this.pg.fillRect(0, n5, this.screenWidth, this.maxItemHeight);
                        this.pg.setColor(HyperList.this.selectionFColor);
                    } else {
                        this.pg.setColor((Color)this.colors.elementAt(n4));
                    }
                    this.pg.setFont(HyperList.this.NOSIZEFONT);
                    this.pg.drawString("", 0, 0);
                    this.pg.setFont((Font)this.fonts.elementAt(n4));
                    this.pg.drawString((String)this.shownWords.elementAt(n4), n6, n5 + (this.maxItemHeight - rectangle.height) / 2 + rectangle.y);
                    Vector vector = (Vector)this.icons.elementAt(n4);
                    if (vector.size() > 0) {
                        n6 += rectangle.width;
                        int n7 = 0;
                        while (n7 < vector.size()) {
                            int n8 = 18;
                            if (n7 < vector.size() - 1 && vector.elementAt(n7 + 1) instanceof Integer) {
                                n8 = (Integer)vector.elementAt(n7 + 1);
                                ++n7;
                            }
                            this.pg.drawImage((Image)vector.elementAt(n7), n6, n5 + (this.maxItemHeight - 18) / 2, n8, 18, this);
                            n6 += n8 + 1;
                            ++n7;
                        }
                    }
                    n5 += this.maxItemHeight;
                    ++n4;
                }
            }
            graphics.drawImage(this.puffer, 2, 2, this);
            graphics.setColor(Color.gray);
            graphics.drawLine(0, 0, n - 1, 0);
            graphics.drawLine(0, 0, 0, n2 - 1);
            graphics.setColor(Color.black);
            graphics.drawLine(1, 1, n, 1);
            graphics.drawLine(1, 1, 1, n2 - 1);
            graphics.setColor(Color.lightGray);
            graphics.drawLine(1, n2 - 2, n - 1, n2 - 2);
            graphics.setColor(this.veryLightGray);
            graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
            Vector vector = this.drawnImages;
            this.drawnImages = this.newDrawnImages;
            this.newDrawnImages = vector;
            this.paintInProgress = false;
            if (this.repaintNeeded) {
                this.repaint();
            }
        }

        private void paintBackground(Graphics graphics, Image image, int n, int n2) {
            block13: {
                block14: {
                    block15: {
                        block12: {
                            if (graphics != null && HyperList.this.backgroundColor != null) break block12;
                            HyperList.this.backgroundUpdateNeeded = true;
                            break block13;
                        }
                        if (image == null) break block14;
                        int n3 = HyperList.this.imageFlags >> 4;
                        n3 = n3 > 0 ? n3 : 1;
                        int n4 = image.getWidth(this);
                        int n5 = image.getHeight(this);
                        boolean bl = false;
                        if (n4 <= 0 || n5 <= 0) break block15;
                        switch (HyperList.this.imageFlags & 0xF) {
                            case 1: {
                                int n6 = 0;
                                while (n6 < n2) {
                                    int n7 = 0;
                                    while (n7 < n) {
                                        graphics.drawImage(image, n7, n6, n4 * n3, n5 * n3, this);
                                        n7 += n4 * n3;
                                    }
                                    n6 += n5 * n3;
                                }
                                break block13;
                            }
                            case 2: {
                                int n8 = 0;
                                while (n8 < n2) {
                                    int n9 = bl ? -n4 * n3 / 2 : 0;
                                    while (n9 < n) {
                                        graphics.drawImage(image, n9, n8, n4 * n3, n5 * n3, this);
                                        n9 += n4 * n3;
                                    }
                                    n8 += n5 * n3;
                                    bl ^= true;
                                }
                                break block13;
                            }
                            case 3: {
                                int n10 = 0;
                                while (n10 < n) {
                                    int n11 = bl ? -n5 * n3 / 2 : 0;
                                    while (n11 < n2) {
                                        graphics.drawImage(image, n10, n11, n4 * n3, n5 * n3, this);
                                        n11 += n5 * n3;
                                    }
                                    n10 += n4 * n3;
                                    bl ^= true;
                                }
                                break block13;
                            }
                            case 4: {
                                graphics.setColor(HyperList.this.backgroundColor);
                                graphics.fillRect(0, 0, n, n2);
                                int n12 = (n - n4 * n3) / 2;
                                int n13 = (n2 - n5 * n3) / 2;
                                graphics.drawImage(image, n12, n13, n4 * n3, n5 * n3, this);
                                break;
                            }
                            default: {
                                graphics.drawImage(image, 0, 0, n, n2, this);
                                break;
                            }
                        }
                        break block13;
                    }
                    graphics.setColor(HyperList.this.backgroundColor);
                    graphics.fillRect(0, 0, n, n2);
                    break block13;
                }
                graphics.setColor(HyperList.this.backgroundColor);
                graphics.fillRect(0, 0, n, n2);
            }
        }

        private void reDoLayout() {
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            int n3 = 0;
            while (n3 < this.sizes.size()) {
                Rectangle rectangle = (Rectangle)this.sizes.elementAt(n3);
                int n4 = rectangle.width + 2;
                Vector vector = (Vector)this.icons.elementAt(n3);
                if (vector.size() > 0) {
                    n4 += 2;
                }
                int n5 = 0;
                while (n5 < vector.size()) {
                    bl = true;
                    Content content = n5 + 1 < vector.size() ? vector.elementAt(n5 + 1) : this;
                    if (content instanceof Integer) {
                        ++n5;
                        n4 += (Integer)((Object)content) + 1;
                    } else {
                        n4 += 19;
                    }
                    ++n5;
                }
                if (n < rectangle.height) {
                    n = rectangle.height;
                }
                if (n2 < n4) {
                    n2 = n4;
                }
                ++n3;
            }
            if (bl && n < 18) {
                n = 18;
            }
            this.maxItemHeight = n += 4;
            this.virtualHeight = n * this.sizes.size();
            this.virtualWidth = n2;
            this.checkDelta();
            this.repaint();
        }

        public void repaint() {
            if (this.paintInProgress) {
                this.repaintNeeded = true;
            } else {
                super.repaint();
            }
        }

        public void select(int n) {
            try {
                if (!this.isSelected(n)) {
                    if (HyperList.this.specialSelected || !HyperList.this.multipleSelections && HyperList.this.selectionCount > 0) {
                        int n2 = 0;
                        while (n2 < this.words.size()) {
                            if (this.isSelected(n2)) {
                                this.deselect(n2);
                            }
                            ++n2;
                        }
                        HyperList.this.specialSelected = false;
                    }
                    this.selections.setElementAt(this, n);
                    HyperList hyperList = HyperList.this;
                    hyperList.selectionCount = hyperList.selectionCount + 1;
                    this.repaint();
                }
            }
            catch (Exception exception) {
                System.err.println("ERROR: unknown item selected. " + exception);
            }
        }

        public void setDelta(int n) {
            this.delta = n;
            this.checkDelta();
        }

        public void setSpecial(int n, boolean bl) {
            if (bl) {
                HyperList.this.specialSelected = false;
                int n2 = 0;
                while (n2 < this.words.size()) {
                    if (this.isSelected(n2)) {
                        this.deselect(n2);
                    }
                    ++n2;
                }
                this.select(n);
                HyperList.this.specialSelected = true;
                this.repaint();
            } else if (HyperList.this.specialSelected && this.isSelected(n)) {
                HyperList.this.specialSelected = false;
                this.deselect(n);
            }
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }
}

