/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Frame;
import java.awt.TextField;
import java.util.Vector;

public class PrivateFrame
extends Frame {
    private static Vector instances = new Vector(3);
    private TextPanel tp;
    private TextField tf;
    private GroupFrame gf;
    private GroupChat gc;
    private String nick;
    private String partner;
    private boolean selfMode;
    public static final int historySize = 32;
    private String[] historyStack = new String[32];
    private int historyStart;
    private int historyPosition;

    public PrivateFrame(GroupChat groupChat, GroupFrame groupFrame, String string, String string2) {
        super("Private Talk with " + string2);
        instances.addElement(this);
        this.setLayout(new BorderLayout());
        this.historyPosition = 0;
        this.historyStart = 0;
        this.historyStack[0] = "";
        this.nick = string;
        this.partner = string2;
        this.gf = groupFrame;
        this.gc = groupChat;
        this.selfMode = this.nick.toLowerCase().equals(this.partner.toLowerCase());
        this.tf = new TextField();
        ((Component)this.tf).setBackground(Color.white);
        this.tf.setForeground(Color.black);
        this.tp = new TextPanel(groupChat, 1000, 5000, false, false, true, false);
        this.tp.inhalt.configureTextPanel(groupChat, false, false, 14);
        this.tp.forceSize(400, 280);
        this.add("Center", this.tp);
        this.add("South", this.tf);
        this.check();
        this.move(150, 80);
        this.pack();
        this.show();
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.tf) {
            String string = this.tf.getText();
            String string2 = string.trim();
            if (!string2.startsWith("/")) {
                string2 = "/p " + this.partner + ":" + string2;
            }
            this.tf.setText("");
            if (GroupChat.visitMe(this.gc, this.gf, this, this.tp, string2) | this.gf.handleMsg(string2, false)) {
                this.historyStack[this.historyStart++] = string;
                this.historyStart &= 0x1F;
                this.historyStack[this.historyStart] = "";
                this.historyPosition = 0;
                return true;
            }
        }
        return super.action(event, object);
    }

    public void check() {
        if (this.gf.offline) {
            this.dispose();
        } else {
            this.tp.STANDARDTEXTCOLOR = this.gf.ta.STANDARDTEXTCOLOR;
            this.tp.backgroundColor = this.gf.ta.backgroundColor;
            this.tp.STANDARDFONTSIZE = this.gf.ta.STANDARDFONTSIZE;
            this.tp.breakLineFont = this.gf.ta.breakLineFont;
            this.tp.schieber.setBackground(this.gf.ta.backgroundColor);
            this.tp.schieber.repaint();
            this.tp.repaint();
        }
    }

    public static void checkAll() {
        Vector vector = PrivateFrame.getInstances();
        int n = vector.size() - 1;
        while (n >= 0) {
            ((PrivateFrame)vector.elementAt(n)).check();
            --n;
        }
    }

    public void dispose() {
        instances.removeElement(this);
        super.dispose();
    }

    public static Vector getInstances() {
        return instances;
    }

    public boolean handleEvent(Event event) {
        if (event.id == 205 || event.id == 204 || event.id == 202 || event.id == 1004) {
            this.tf.requestFocus();
        } else if (event.id == 201) {
            this.dispose();
        } else if (event.id == 403 && event.target == this.tf) {
            if (event.key == 1004 && this.historyPosition < 31) {
                if (this.historyPosition == 0) {
                    this.historyStack[this.historyStart] = this.tf.getText();
                }
                ++this.historyPosition;
            } else if (event.key == 1005 && this.historyPosition > 0) {
                --this.historyPosition;
            } else {
                return super.handleEvent(event);
            }
            String string = this.historyStack[this.historyStart - this.historyPosition & 0x1F];
            if (string == null) {
                --this.historyPosition;
            } else {
                this.tf.setText(string);
            }
        } else {
            return super.handleEvent(event);
        }
        return true;
    }

    public boolean isInSelfMode() {
        return this.selfMode;
    }

    public boolean print(String string, String string2, String string3) {
        if (this.selfMode) {
            if (string3.toLowerCase().indexOf(string2) != -1) {
                this.tp.print("_" + string + "_ " + string3);
                return true;
            }
        } else {
            if (string.toLowerCase().equals(this.partner.toLowerCase())) {
                this.tp.print("_" + this.partner + ":_ " + string3);
                return true;
            }
            if (string.toLowerCase().equals(this.nick.toLowerCase()) && string2.indexOf(", " + this.partner + ",") != -1) {
                this.tp.print("_" + this.nick + ":_ " + string3);
                return true;
            }
        }
        return false;
    }

    public static boolean printAllSelfMode(String string, String string2, String string3) {
        boolean bl = false;
        Vector vector = PrivateFrame.getInstances();
        int n = vector.size() - 1;
        while (n >= 0) {
            PrivateFrame privateFrame = (PrivateFrame)vector.elementAt(n);
            if (privateFrame.isInSelfMode()) {
                bl |= privateFrame.print(string, string2, string3);
            }
            --n;
        }
        return bl;
    }
}

