// Horst Gierhardt, Version vom 31.10.2004 //

import java.awt.*;

class Turtle
{
  protected double posX, posY;         // Aktuelle Position der Turtle
  protected double winkel;             // Aktueller Blickwinkel
  protected Color farbe=Color.black;   // Standard-Zeichenfarbe
  protected Container c;
  protected double homeX, homeY;       // Home-Koordinaten
  protected boolean stiftUnten;
  protected boolean kos = false;
  protected int breiteX, hoeheY;
  protected double xScale, yScale;
  protected double xOffset, yOffset;
  protected Graphics g;

  public Turtle(Container cont)
  { this(cont, 0, 0, 0);
  }

  public Turtle(Container cont, double x, double y, double richtung)
  {
    posX=x;
    posY=y;
    winkel=richtung;
    homeX=x;
    homeY=y;
    c=cont;
    g=c.getGraphics();
    stiftUnten = true;
    breiteX = c.getBounds().width;
    hoeheY = c.getBounds().height;
  }

  public void setzeKOS(double xMin, double xMax, double yMin, double yMax)
  {
    xScale = breiteX  / (xMax - xMin);
    yScale = -hoeheY / (yMax - yMin);
    xOffset = -xMin * xScale;
    yOffset = hoeheY - yMin * yScale;
    kos = true;
    posX = (xMax + xMin) / 2.0; // Standardmaessig in die Mitte setzen
    posY = (yMax + yMin) / 2.0;
    homeX=posX;
    homeY=posY;
  } // setzeKOS

  private int sx(double x)
  {  return (int)Math.round(x * xScale + xOffset); }
  
  private int sy(double y)
  { return (int)Math.round(y * yScale + yOffset); }


  public void zumStartpunkt()
  {
    posX=homeX;
    posY=homeY;
  }

  public void vor(double laenge)
  {
    g.setColor(farbe);
    double neuX = posX + Math.cos(bogen(winkel))*laenge;
    double neuY;
    if (kos)
    {
    neuY = posY + Math.sin(bogen(winkel))*laenge;
    if (stiftUnten) g.drawLine(sx(posX), sy(posY), sx(neuX), sy(neuY));
    }
    else
    {
    neuY = posY - Math.sin(bogen(winkel))*laenge;
    if (stiftUnten) g.drawLine((int) posX, (int) posY, (int) neuX, (int) neuY);
    }

    posX = neuX;
    posY = neuY;
  }

  public void zurueck(double laenge)
  {
    drehe(180);
    vor(laenge);
    drehe(180);
  }
  public void drehe(double grad)
  {
    winkel = winkel + grad;
  }

  public void loesche()
  {
    zumStartpunkt();
    winkel=0;
    int x=c.getBounds().width;
    int y=c.getBounds().height;
    g.clearRect(0, 0, x, y);
  }

  public void setzeRichtung(double grad)
  {
    winkel = grad;
  }

  public void geheZu(double neuX, double neuY)
  {
    g.setColor(farbe);
    if (kos)
    {
    if (stiftUnten) g.drawLine(sx(posX), sy(posY), sx(neuX), sy(neuY));
    }
    else
    {
    if (stiftUnten) g.drawLine((int) posX, (int) posY, (int) neuX, (int) neuY);
    }
    posX = neuX;
    posY = neuY;
  }

  public void strecke(double vonX, double vonY, double nachX, double nachY)
  {
    g.setColor(farbe);
    if (kos)
    {
      g.drawLine(sx(vonX), sy(vonY), sx(nachX), sy(nachY));
    }
    else
    {
      g.drawLine((int) vonX, (int) vonY, (int) nachX, (int) nachY);
    }
  } // strecke
  
  public void dickPunkt(double pX, double pY, int dicke)
  {
    g.setColor(farbe);
    int xversatz = dicke/2;
    int yversatz = dicke/2;
    if (kos)
    {
      g.fillOval(sx(pX) - xversatz, sy(pY)- yversatz, dicke, dicke);
    }
    else
    {
      g.fillOval((int)pX - xversatz, (int)pY - yversatz, dicke, dicke);
    }
  } // dickPunkt


  public void stiftfarbe(Color c)
  {
    farbe = c;
  }

  public void stiftHoch()
  {
    stiftUnten=false;
  }

  public void stiftRunter()
  {
    stiftUnten=true;
  }

  public double aktuelleRichtung()
  {
    return winkel;
  }

  public double aktuellesX()
  {
    return posX;
  }

  public double aktuellesY()
  {
    return posY;
  }

  public Color aktuelleFarbe()
  {
    return (Color)farbe;
  }

  public void schreibe(String str, double x, double y)
  {
    if (kos)
    {
    if (stiftUnten) g.drawString(str, sx(x), sy(y));
    }
    else
    {
    if (stiftUnten) g.drawString(str, (int) x, (int) y);
    }

  }

  public void zeichneNormal()
  {
    g.setPaintMode();
  }

  public void zeichneXOR()
  {
    g.setXORMode(Color.lightGray);
  }

  private double bogen(double winkel)
  {
    return winkel*Math.PI/180;
  }

}//Turtle.class
