#global module:false
module.exports = (grunt) ->

  require('load-grunt-tasks')(grunt);

  # Project configuration.
  grunt.initConfig

    # Metadata.
    pkg: grunt.file.readJSON("package.json")

    clean:
      dist: [
        "dist"
      ]

    coffee:
      dist:
        files: [
          expand: true,
          cwd: 'src',
          src: ['{,**/}*.coffee'],
          dest: 'dist',
          ext: '.js'
        ]

    watch:
      gruntfile:
        files: 'Gruntfile.coffee'
        tasks: [ "default" ]

      src:
        files: 'src/{,**/}*.coffee'
        tasks: [
          "newer:coffee:dist"
        ]

    execute:
      target:
        src: "dist/main.js"

  grunt.registerTask "dist", [
    "clean"
    "newer:coffee:dist"
  ]

  grunt.registerTask "default", [
    "dist"
  ]
  return
