WebSocketClient = require( 'websocket' ).client
{ EventEmitter } = require 'events'

{ Packet } = require( './packet' )
packets = require( './packet' )

{ KPwd } = require( './pwd' )

class @KClient extends EventEmitter

  _client = null
  _connection = null

  constructor: ( @nickname, @password, @channel, options={} ) ->
    _client = new WebSocketClient()
    { @host, @port } = options
    @host ?= 'chat.knuddels.de'
    @port ?= 2710
    super()


  connect: () ->
    _client.connect "ws://#{@host}:#{@port}/webchat/connect"

    _client.once 'connect', (connection) =>
      _connection = connection

      @sendPacket new packets.Auth( @nickname, @channel )

      _connection.on 'message', (message) =>
        return unless message.type == 'utf8'

        packet = Packet.parse( message.utf8Data )

        switch packet.ident

          when '5'
            # BUTLER NAME
            # -> start ping
            @butler = packets.Butler.parse( packet )
            @startPing()

          when '('
            # PASSWORD HASH
            # -> send login
            console.log packet.get(1)
            pwdhash = KPwd.generate( packet.get(1), @password )
            @sendPacket new packets.Login( @nickname, @channel, pwdhash )

          when ','
            # PING RECEIVED FROM SERVER/USER
            ping = packets.Ping.parse( packet )
            @emit 'ping', ping
            if ping.sender? # answer the fucking ping from the fucking user
              @sendPacket new packets.Ping( ping.sender, ping.time )

          when 'a', '1'
            # NEW WINDOW/CHANNEL
            channel = packets.Channel.parse( packet )
            @channel = channel.name
            @emit 'channel', channel

          when '&'
            # do nothing / same like 'l'
            return
          when 'l' # , '&'
            # A USER JOINED THE CHANNEL
            userjoin = packets.Userjoin.parse( packet )
            @emit 'userjoin', userjoin

          when 'w'
            # A USER LEAVED THE CHANNEL
            userleave = packets.Userleave.parse( packet )
            @emit 'userleave', userleave

          when 'u'
            # LIST OF CURRENT USERS IN CHANNEL
            userlist = packets.Userlist.parse( packet )
            @emit 'userlist', userlist

          when 'e', 't'
            # PUBLIC MESSAGE or ACTION MESSAGE
            message = packets.PublicMessage.parse( packet )
            @emit 'publicMessage', message

          when 'r'
            # PRIVATE MESSAGE
            message = packets.PrivateMessage.parse( packet )
            if message.sender == '-' # sender == me
              message.sender = @nickname
            @emit 'privateMessage', message

          else
            @emit 'packet', packet


  sendPacket: (packet) ->
    @emit 'send', packet
    _connection.sendUTF packet.toString()

  startPing: () ->
    # 2 minutes interval
    setInterval () =>
      @sendPacket new packets.Ping()
    , 1000 * 60 * 2

  sendPublicMessage: (message, channel=@channel) ->
    @sendPacket new packets.PublicMessage( message, channel )

  sendPrivateMessage: (message, receivers...) ->
    @sendPacket new packets.PrivateMessage( message, @channel, receivers )
