{ Packet } = require './packet'

class @Ping extends Packet

  constructor: (receiver = '-', time = '') ->
    super(
        'h'
        if receiver? and time? then receiver + '|' + time else receiver
      )

  @parse: (packet) ->
    sender = packet.get(1)
    if sender?.length > 0 and sender.indexOf( '|' ) != -1
      [ user, time ] = sender.split '|'
      packet.sender = user
      packet.time = parseInt( time )

    return packet
