fs = require 'fs'
colors = require 'colors'

kndsAuth = require './knds/auth'
{ KClient } = require './knds/client'

######################################################
console.log '- START -\n'.rainbow

kndsAccount =
  nick: '..' # nickname eintragen
  pwd: '' # passwort eintragen
  channel: '/ok'

# -----------
console.log "Login as #{kndsAccount.nick.underline}.".green + ' Please wait...'.inverse

# -----------

connect = (account) ->
  console.log '\nAuthentication details received. -> ' + account.pwd.toString().red
  client = new KClient(account.nick, account.pwd, kndsAccount.channel)

  client.on 'packet', (packet) ->
    unless packet.isNewProtocol()
      tokens = packet.getAsArray()
      visual = ''
      tokens.map (token) ->
        if token.length > 30
          token = token.substr(0, 30) + '...'
        visual += token.yellow + '\\0'

      console.log visual

  # ---------------------------

  client.on 'channel', (channel) ->
    console.log "You joined #{channel.name.green}.."

  client.on 'userlist', (packet) ->
    console.log 'User in this channel: ' + packet.userlist.length

  client.on 'userjoin', (user) ->
    console.log "#{user.nickname} joined..".magenta

  client.on 'userleave', (user) ->
    console.log "#{user.nickname} leave..".magenta

  # ---------------------------

  client.on 'ping', (ping) ->
    console.log 'ping received'
    if ping.sender?
      timeNow = new Date( ping.time )
      console.log "PINGED! From user '#{ping.sender}' at #{timeNow}".red

  # ---------------------------

  client.on 'publicMessage', (message) ->
    console.log "#{message.sender}: ".blue +  message.message

    if message.sender == 'patlux'
      client.sendPublicMessage("HALLO")
      client.sendPrivateMessage("HALLO", client.butler)

  client.on 'privateMessage', (message) ->
    console.log "#{message.sender}(to #{message.receiver.underline}): ".red +  message.message

  # ---------------------------

  client.on 'send', (packet) ->
    unless packet.isNewProtocol()
      tokens = packet.getAsArray()
      visual = ''
      tokens.map (token) ->
        if token.length > 30
          token = token.substr(0, 30) + '...'
        visual += token.cyan + '\\0'

      console.log 'SEND: '.cyan + visual

  console.log '\n\nConnecting to chat...\n'.inverse
  client.connect()

# -----------

getAccount = (account) ->
  kndsAuth( account.nick, account.pwd ).then (result) ->
    result = JSON.parse( result )


    unless result.ok?.pwd?
      console.log 'ERROR: ', result
      return

    result = result.ok
    console.log result.text.green

    delete result.text

    fs.writeFile 'knds.json', JSON.stringify( result, null, 2 ), (err) ->
      return console.log err if err

      console.log 'Account saved in knds.json'.green

    # connect( result )

# -----------

if fs.existsSync( 'knds.json' )

  fs.readFile 'knds.json', (err, data) ->
    return console.log err if err
    result = JSON.parse( data )

    unless result.pwd?
      getAccount(kndsAccount)
      return

    console.log 'Get account from file knds.json'.green

    connect( result )

else
  getAccount(kndsAccount)
