﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;
using System.ComponentModel;
using System.Drawing.Drawing2D;
using System.Drawing;
using System.Windows.Forms;
//17.12.14 - 17:10 Uhr
enum MouseState : byte
{
    None = 0,
    Over = 1,
    Down = 2,
    Block = 3
}
public class Draw
{
    public static GraphicsPath RoundRectF(RectangleF Re, int Curve)
    {
        GraphicsPath P = new GraphicsPath();
        int ArcReWi = (Curve * 2);
        P.AddArc(new RectangleF(Re.X, Re.Y, ArcReWi, ArcReWi), -180, 90);
        P.AddArc(new RectangleF(Re.Width - ArcReWi + Re.X, Re.Y, ArcReWi, ArcReWi), -90, 90);
        P.AddArc(new RectangleF(Re.Width - ArcReWi + Re.X, Re.Height - ArcReWi + Re.Y, ArcReWi, ArcReWi), 0, 90);
        P.AddArc(new RectangleF(Re.X, Re.Height - ArcReWi + Re.Y, ArcReWi, ArcReWi), 90, 90);
        P.AddLine(new PointF(Re.X, Re.Height - ArcReWi + Re.Y), new PointF(Re.X, Curve + Re.Y));
        return P;
    }
   
}
public class MangoEControlBox : Control
{
    #region " MouseStates "
    MouseState State = MouseState.None;
    int X;
    Rectangle CloseBtn = new Rectangle(43, 2, 17, 17);
    Rectangle MinBtn = new Rectangle(3, 2, 17, 17);
    Rectangle MaxBtn = new Rectangle(23, 2, 17, 17);

    RectangleF bgr = new RectangleF((float)0, (float)0, (float)62.5, (float)21);
    protected override void OnMouseDown(System.Windows.Forms.MouseEventArgs e)
    {
        base.OnMouseDown(e);
        if (X > 3 && X < 20)
        {
            FindForm().WindowState = FormWindowState.Minimized;
        }
        else if (X > 23 && X < 40)
        {
            if (FindForm().WindowState == FormWindowState.Maximized)
            {
                FindForm().WindowState = FormWindowState.Minimized;
                FindForm().WindowState = FormWindowState.Normal;
            }
            else
            {
                FindForm().WindowState = FormWindowState.Minimized;
                FindForm().WindowState = FormWindowState.Maximized;
            }

        }
        else if (X > 43 && X < 60)
        {
            Environment.Exit(1);
        }
        State = MouseState.Down;
        this.Invalidate();
    }
    protected override void OnMouseUp(System.Windows.Forms.MouseEventArgs e)
    {
        base.OnMouseUp(e);
        State = MouseState.Over;
        this.Invalidate();
    }
    protected override void OnMouseEnter(System.EventArgs e)
    {
        base.OnMouseEnter(e);
        State = MouseState.Over;
        this.Invalidate();
    }
    protected override void OnMouseLeave(System.EventArgs e)
    {
        base.OnMouseLeave(e);
        State = MouseState.None;
        this.Invalidate();
    }
    protected override void OnMouseMove(System.Windows.Forms.MouseEventArgs e)
    {
        base.OnMouseMove(e);
        X = e.Location.X;
        this.Invalidate();
    }
    #endregion

    public MangoEControlBox()
    {
        this.SetStyle(ControlStyles.AllPaintingInWmPaint | ControlStyles.OptimizedDoubleBuffer | ControlStyles.UserPaint | ControlStyles.ResizeRedraw | ControlStyles.SupportsTransparentBackColor | ControlStyles.FixedHeight, true);
        this.UpdateStyles();
        this.Size = new Size(64, 22);
        this.MinimumSize = new Size(64, 22);
        this.MaximumSize = new Size(64, 22);
        this.BackColor = Color.Transparent;
        Font = new Font("Marlett", 7);
        Anchor = AnchorStyles.Top | AnchorStyles.Right;
    }

    protected override void OnPaint(System.Windows.Forms.PaintEventArgs e)
    {
        using (Bitmap B = new Bitmap(Width, Height))
        {

            using (Graphics G = Graphics.FromImage(B))
            {
                base.OnPaint(e);
                G.SmoothingMode = SmoothingMode.HighQuality;
                G.TextRenderingHint = System.Drawing.Text.TextRenderingHint.ClearTypeGridFit;

                Func<int, int, int, Color> ARGBC = (int dd, int ee, int ff) => { return Color.FromArgb(dd, ee, ff); };

                using(LinearGradientBrush bg0 = new LinearGradientBrush(bgr, ARGBC(60, 59, 55), ARGBC(60, 59, 55), 90)) {G.FillPath(bg0, Draw.RoundRectF(bgr, 10));}
               
                using(LinearGradientBrush lgb10 = new LinearGradientBrush(MinBtn, ARGBC(152, 151, 146), ARGBC(56, 55, 51), 90))
                {
                    G.FillEllipse(lgb10, MinBtn);
                    G.DrawEllipse(Pens.DimGray, MinBtn);
                }
               

                G.DrawString("0", Font, new SolidBrush(ARGBC(58, 57, 53)), new RectangleF((float)5.5, (float)6, (float)0, (float)0));

                using(LinearGradientBrush lgb20 = new LinearGradientBrush(MaxBtn, ARGBC(152, 151, 146), ARGBC(56, 55, 51), 90)) {G.FillEllipse(lgb20, MaxBtn);}
               
                G.DrawEllipse(Pens.DimGray, MaxBtn);
                G.DrawString("1", Font, new SolidBrush(ARGBC(58, 57, 53)), new Rectangle(26, 7, 0, 0));

                using(LinearGradientBrush lgb30 = new LinearGradientBrush(CloseBtn, ARGBC(247, 150, 116), ARGBC(223, 81, 6), 90)){G.FillEllipse(lgb30, CloseBtn);}
                    
                G.DrawEllipse(Pens.DimGray, CloseBtn);
                G.DrawString("r", Font, new SolidBrush(ARGBC(58, 57, 53)), new Rectangle(46, 7, 0, 0));

                switch (State)
                {
                    case MouseState.None:
                        using (LinearGradientBrush bg = new LinearGradientBrush(bgr, ARGBC(60, 59, 55), ARGBC(60, 59, 55), 90)) { G.FillPath(bg, Draw.RoundRectF(bgr, 10)); }
                        using (LinearGradientBrush lgb1 = new LinearGradientBrush(MinBtn, ARGBC(152, 151, 146), ARGBC(56, 55, 51), 90)) {G.FillEllipse(lgb1, MinBtn); }

                        G.DrawEllipse(Pens.DimGray, MinBtn);
                        G.DrawString("0", Font, new SolidBrush(ARGBC(58, 57, 53)), new RectangleF((float)5.5, (float)6, (float)0, (float)0));

                        using (LinearGradientBrush lgb2 = new LinearGradientBrush(MaxBtn, ARGBC(152, 151, 146), ARGBC(56, 55, 51), 90)) { G.FillEllipse(lgb2, MaxBtn); }
                 
                        G.DrawEllipse(Pens.DimGray, MaxBtn);
                        G.DrawString("1", Font, new SolidBrush(ARGBC(58, 57, 53)), new Rectangle(26, 7, 0, 0));

                        using (LinearGradientBrush lgb3 = new LinearGradientBrush(CloseBtn, ARGBC(247, 150, 116), ARGBC(223, 81, 6), 90)) { G.FillEllipse(lgb3, CloseBtn); }
                    
                        G.DrawEllipse(Pens.DimGray, CloseBtn);
                        G.DrawString("r", Font, new SolidBrush(ARGBC(58, 57, 53)), new Rectangle(46, 7, 0, 0));
                        break;
                    case MouseState.Over:
                        if (X > 3 && X < 20)
                        {
                            using (LinearGradientBrush bgx = new LinearGradientBrush(bgr, ARGBC(60, 59, 55), ARGBC(60, 59, 55), 90)) { G.FillPath(bgx, Draw.RoundRectF(bgr, 10)); }

                            using (LinearGradientBrush lgby = new LinearGradientBrush(MinBtn, ARGBC(172, 171, 166), ARGBC(76, 75, 71), 90)) { G.FillEllipse(lgby, MinBtn); }
                           
                            G.DrawEllipse(Pens.DimGray, MinBtn);
                            G.DrawString("0", Font, new SolidBrush(ARGBC(58, 57, 53)), new RectangleF((float)5.5, (float)6, (float)0, (float)0));

                            using (LinearGradientBrush lgbz = new LinearGradientBrush(MaxBtn, ARGBC(152, 151, 146), ARGBC(56, 55, 51), 90)) { G.FillEllipse(lgbz, MaxBtn); }
                         
                            G.DrawEllipse(Pens.DimGray, MaxBtn);
                            G.DrawString("1", Font, new SolidBrush(ARGBC(58, 57, 53)), new Rectangle(26, 7, 0, 0));

                            using (LinearGradientBrush lgbAA = new LinearGradientBrush(CloseBtn, ARGBC(247, 150, 116), ARGBC(223, 81, 6), 90)) { G.FillEllipse(lgbAA, CloseBtn); }
                        
                            G.DrawEllipse(Pens.DimGray, CloseBtn);
                            G.DrawString("r", Font, new SolidBrush(ARGBC(58, 57, 53)), new Rectangle(46, 7, 0, 0));
                        }
                        else if (X > 23 && X < 40)
                        {
                            using (LinearGradientBrush bgWW = new LinearGradientBrush(bgr, ARGBC(60, 59, 55), ARGBC(60, 59, 55), 90)) { G.FillPath(bgWW, Draw.RoundRectF(bgr, 10)); }


                            using (LinearGradientBrush lgbXX = new LinearGradientBrush(MinBtn, ARGBC(152, 151, 146), ARGBC(56, 55, 51), 90)) { G.FillEllipse(lgbXX, MinBtn); }
                
                            G.DrawEllipse(Pens.DimGray, MinBtn);
                            G.DrawString("0", Font, new SolidBrush(ARGBC(58, 57, 53)), new RectangleF((float)5.5, (float)6, (float)0, (float)0));

                            using (LinearGradientBrush lgbJJ = new LinearGradientBrush(MaxBtn, ARGBC(172, 171, 166), ARGBC(76, 75, 71), 90)) { G.FillEllipse(lgbJJ, MaxBtn); }
                         
                            G.DrawEllipse(Pens.DimGray, MaxBtn);
                            G.DrawString("1", Font, new SolidBrush(ARGBC(58, 57, 53)), new Rectangle(26, 7, 0, 0));

                            using (LinearGradientBrush lgbKK = new LinearGradientBrush(CloseBtn, ARGBC(247, 150, 116), ARGBC(223, 81, 6), 90)) { G.FillEllipse(lgbKK, CloseBtn); }
                       
                            G.DrawEllipse(Pens.DimGray, CloseBtn);
                            G.DrawString("r", Font, new SolidBrush(ARGBC(58, 57, 53)), new Rectangle(46, 7, 0, 0));
                        }
                        else if (X > 43 && X < 60)
                        {
                            using (LinearGradientBrush bgPP = new LinearGradientBrush(bgr, ARGBC(60, 59, 55), ARGBC(60, 59, 55), 90)) { G.FillPath(bgPP, Draw.RoundRectF(bgr, 10)); }


                            using (LinearGradientBrush lgb1SS = new LinearGradientBrush(MinBtn, ARGBC(152, 151, 146), ARGBC(56, 55, 51), 90)) { G.FillEllipse(lgb1SS, MinBtn); }
                       
                            G.DrawEllipse(Pens.DimGray, MinBtn);
                            G.DrawString("0", Font, new SolidBrush(ARGBC(58, 57, 53)), new RectangleF((float)5.5, (float)6, (float)0, (float)0));

                            using (LinearGradientBrush lgbRR = new LinearGradientBrush(MaxBtn, ARGBC(152, 151, 146), ARGBC(56, 55, 51), 90)) { G.FillEllipse(lgbRR, MaxBtn); }
                           
                            G.DrawEllipse(Pens.DimGray, MaxBtn);
                            G.DrawString("1", Font, new SolidBrush(ARGBC(58, 57, 53)), new Rectangle(26, 7, 0, 0));

                            using (LinearGradientBrush lgbCC = new LinearGradientBrush(CloseBtn, ARGBC(255, 170, 136), ARGBC(243, 101, 26), 90)) { G.FillEllipse(lgbCC, CloseBtn); }
                  
                            G.DrawEllipse(Pens.DimGray, CloseBtn);
                            G.DrawString("r", Font, new SolidBrush(ARGBC(58, 57, 53)), new Rectangle(46, 7, 0, 0));
                        }
                        break;
                    default:
                        using (LinearGradientBrush bga = new LinearGradientBrush(bgr, ARGBC(60, 59, 55), ARGBC(60, 59, 55), 90)) { G.FillPath(bga, Draw.RoundRectF(bgr, 10)); }


                        using (LinearGradientBrush lgbb = new LinearGradientBrush(MinBtn, ARGBC(152, 151, 146), ARGBC(56, 55, 51), 90)) { G.FillEllipse(lgbb, MinBtn); }
                  
                        G.DrawEllipse(Pens.DimGray, MinBtn);
                        G.DrawString("0", Font, new SolidBrush(ARGBC(58, 57, 53)), new RectangleF((float)5.5, (float)6, (float)0, (float)0));

                        using (LinearGradientBrush lgbc = new LinearGradientBrush(MaxBtn, ARGBC(152, 151, 146), ARGBC(56, 55, 51), 90)) { G.FillEllipse(lgbc, MaxBtn); }
                       
                        G.DrawEllipse(Pens.DimGray, MaxBtn);
                        G.DrawString("1", Font, new SolidBrush(ARGBC(58, 57, 53)), new Rectangle(26, 7, 0, 0));

                        using (LinearGradientBrush lgbd = new LinearGradientBrush(CloseBtn, ARGBC(247, 150, 116), ARGBC(223, 81, 6), 90)) { G.FillEllipse(lgbd, CloseBtn); }
                        
                        G.DrawEllipse(Pens.DimGray, CloseBtn);
                        G.DrawString("r", Font, new SolidBrush(ARGBC(58, 57, 53)), new Rectangle(46, 7, 0, 0));
                        break;
                }


                e.Graphics.DrawImage((Image)B.Clone(), 0, 0);
            }
        }
    }




    void Dispose()
    {
        Dispose(true);
        // Suppress finalization.
        GC.SuppressFinalize(this);
    }
}

[DefaultEvent("Click")] public class MangoEForm : ContainerControl
{
    public MangoEForm()
    {
        this.SetStyle(ControlStyles.AllPaintingInWmPaint | ControlStyles.OptimizedDoubleBuffer | ControlStyles.UserPaint | ControlStyles.ResizeRedraw | ControlStyles.SupportsTransparentBackColor | ControlStyles.FixedHeight, true);
        this.UpdateStyles();
        BackColor = Color.FromArgb(25, 25, 25);
    }
    protected override void OnPaint(System.Windows.Forms.PaintEventArgs e)
    {
        using (Bitmap B = new Bitmap(Width, Height))
        {
            using (Graphics G = Graphics.FromImage(B))
            {
                Rectangle TopBar = new Rectangle(0, 0, Width - 1, 30);
                Rectangle FixBottom = new Rectangle(0, 26, Width - 1, 0);
                Rectangle Body = new Rectangle(0, 5, Width - 1, Height - 6);

                base.OnPaint(e);

                G.Clear(Color.Fuchsia);

                G.SmoothingMode = SmoothingMode.HighSpeed;

                using(LinearGradientBrush lbb = new LinearGradientBrush(Body, Color.FromArgb(242, 241, 240), Color.FromArgb(240, 240, 238), 90)) {G.FillPath(lbb, Draw.RoundRectF(Body, 1));}
               
                using(SolidBrush sb = new SolidBrush(Color.FromArgb(60,60,60)))
                {
                    using (Pen pe = new Pen(sb)) {G.DrawPath(pe, Draw.RoundRectF(Body, 1)); }
                }
               

                using(LinearGradientBrush lgb = new LinearGradientBrush(TopBar, Color.FromArgb(87, 86, 81), Color.FromArgb(60, 59, 55), 90)){G.FillPath(lgb, Draw.RoundRectF(TopBar, 4));}
              
                G.DrawPath(Pens.Black, Draw.RoundRectF(TopBar, 3));
                G.DrawPath(Pens.Black, Draw.RoundRectF(FixBottom, 1));
                G.FillRectangle(Brushes.White, 1, 27, Width - 2, Height - 29);

                Font drawFont = new Font("Tahoma", 10, FontStyle.Regular);

                G.TextRenderingHint = System.Drawing.Text.TextRenderingHint.ClearTypeGridFit;


                using (SolidBrush sb = new SolidBrush(Color.WhiteSmoke))
                {
                    G.DrawString(Text, drawFont, sb, new Rectangle(25, 0, Width - 1, 27), new StringFormat { Alignment = StringAlignment.Near, LineAlignment = StringAlignment.Center });
                }
               
                G.DrawIcon(FindForm().Icon, new Rectangle(5, 5, 16, 16));

                e.Graphics.DrawImage((Image)B.Clone(), 0, 0);
            }
        }
    }

    private Size MouseP = new Size(0, 0);
    private bool Cap = false;
    protected override void OnMouseDown(System.Windows.Forms.MouseEventArgs e)
    {
        base.OnMouseDown(e);
        if (e.Button == System.Windows.Forms.MouseButtons.Left & new Rectangle(0, 0, Width, 26).Contains(e.Location))
        {
            Cap = true;
            MouseP = new Size(e.Location);
        }
    }
    protected override void OnMouseUp(System.Windows.Forms.MouseEventArgs e)
    {
        base.OnMouseUp(e);
        Cap = false;
    }
    protected override void OnMouseMove(System.Windows.Forms.MouseEventArgs e)
    {
        base.OnMouseMove(e);
        if (Cap) Parent.Location = MousePosition - MouseP;
    }

    protected override void OnCreateControl()
    {
        base.OnCreateControl();
        this.ParentForm.FormBorderStyle = FormBorderStyle.None;
        this.ParentForm.TransparencyKey = Color.Fuchsia;
        Dock = DockStyle.Fill;
    }

    void Dispose()
    {
        Dispose(true);
        // Suppress finalization.
        GC.SuppressFinalize(this);
    }
}
[DefaultEvent("Click")]public class MangoEGroupBox : ContainerControl
{

    private int h_Height = 10;

    [Browsable(true), DesignerSerializationVisibility(DesignerSerializationVisibility.Visible)]
    public int HeaderHeight
    {
        get { return h_Height; }
        set
        {
            if (h_Height == value || h_Height < 1 || h_Height < 5) return;
            h_Height = value;
            this.Invalidate();
        }
    }

    public MangoEGroupBox()
    {
        this.SetStyle(ControlStyles.AllPaintingInWmPaint | ControlStyles.OptimizedDoubleBuffer | ControlStyles.UserPaint | ControlStyles.ResizeRedraw | ControlStyles.SupportsTransparentBackColor | ControlStyles.FixedHeight, true);
        this.UpdateStyles();
        this.Size = new Size(200, 100);
        this.BackColor = Color.Transparent;
    }


    protected override void OnPaint(System.Windows.Forms.PaintEventArgs e)
    {
        using (Bitmap B = new Bitmap(Width, Height))
        {
            using (Graphics G = Graphics.FromImage(B))
            {
                Rectangle TopBar = new Rectangle(0, 0, Width - 1, HeaderHeight);
                Rectangle box = new Rectangle(0, 0, Width - 1, Height - 10);

               

                base.OnPaint(e);

                G.SmoothingMode = SmoothingMode.HighQuality;



                using(LinearGradientBrush bodygrade = new LinearGradientBrush(ClientRectangle, Color.White, Color.White, 120)){G.FillPath(bodygrade, Draw.RoundRectF(new Rectangle(0, 12, Width - 1, Height - 15), 1));}
                

                using(LinearGradientBrush outerBorder = new LinearGradientBrush(ClientRectangle, Color.FromArgb(50, 50, 50), Color.DimGray, 90)){G.DrawPath(new Pen(outerBorder), Draw.RoundRectF(new Rectangle(0, 12, Width - 1, Height - 15), 1));}
               

                using(LinearGradientBrush lbb = new LinearGradientBrush(TopBar, Color.FromArgb(87, 86, 81), Color.FromArgb(60, 59, 55), 90)){G.FillPath(lbb, Draw.RoundRectF(TopBar, 1));}
                
                using(SolidBrush sb = new SolidBrush(Color.FromArgb(50,50,50)))
                {
                    using(Pen pe = new Pen(sb)){G.DrawPath(pe, Draw.RoundRectF(TopBar, 2));}
                }
          
               
                Font drawFont = new Font("Tahoma", (HeaderHeight / 2) + 3, FontStyle.Regular);
                G.TextRenderingHint = System.Drawing.Text.TextRenderingHint.ClearTypeGridFit;

                using(SolidBrush sb = new SolidBrush(Color.White)) {G.DrawString(Text, drawFont, sb, TopBar, new StringFormat { Alignment = StringAlignment.Center, LineAlignment = StringAlignment.Center });}
             
                e.Graphics.DrawImage((Image)B.Clone(), 0, 0);
            }
        }
    }

    void Dispose()
    {
        Dispose(true);
        // Suppress finalization.
        GC.SuppressFinalize(this);
    }
}
[DefaultEvent("Click")] public class MangoEButtonOrange : Control
{
    #region " MouseStates "
    MouseState State = MouseState.None;
    protected override void OnMouseDown(System.Windows.Forms.MouseEventArgs e)
    {
        base.OnMouseDown(e);
        State = MouseState.Down;
        this.Invalidate();
    }
    protected override void OnMouseUp(System.Windows.Forms.MouseEventArgs e)
    {
        base.OnMouseUp(e);
        State = MouseState.Over;
        this.Invalidate();
    }
    protected override void OnMouseEnter(System.EventArgs e)
    {
        base.OnMouseEnter(e);
        State = MouseState.Over;
        this.Invalidate();
    }
    protected override void OnMouseLeave(System.EventArgs e)
    {
        base.OnMouseLeave(e);
        State = MouseState.None;
        this.Invalidate();
    }
    #endregion
    public MangoEButtonOrange()
    {
        this.SetStyle(ControlStyles.AllPaintingInWmPaint | ControlStyles.OptimizedDoubleBuffer | ControlStyles.UserPaint | ControlStyles.ResizeRedraw | ControlStyles.SupportsTransparentBackColor | ControlStyles.FixedHeight, true);
        this.UpdateStyles();
        this.BackColor = Color.Transparent;
        ForeColor = Color.FromArgb(86, 109, 109);
    }
    protected override void OnPaint(System.Windows.Forms.PaintEventArgs e)
    {
        using (Bitmap B = new Bitmap(Width, Height))
        {
            using (Graphics G = Graphics.FromImage(B))
            {
                Rectangle ClientRectangle = new Rectangle(0, 0, Width - 1, Height - 1);

                base.OnPaint(e);

                G.SmoothingMode = SmoothingMode.HighQuality;
                Font drawFont = new Font("Tahoma", 11, FontStyle.Regular);
                Pen p = new Pen(Color.FromArgb(157, 118, 103), 1);
                Brush nb = new SolidBrush(Color.FromArgb(86, 109, 109));

                G.TextRenderingHint = System.Drawing.Text.TextRenderingHint.ClearTypeGridFit;
                switch (State)
                {
                    case MouseState.None:

                        LinearGradientBrush lgb = new LinearGradientBrush(ClientRectangle, Color.FromArgb(249, 163, 128), Color.FromArgb(237, 139, 99), 90);
                        G.FillPath(lgb, Draw.RoundRectF(ClientRectangle, 3));
                        G.DrawPath(p, Draw.RoundRectF(ClientRectangle, 3));

                        G.DrawString(Text, drawFont, nb, new Rectangle(0, 0, Width - 1, Height - 1), new StringFormat {Alignment = StringAlignment.Center,LineAlignment = StringAlignment.Center});
                        break;
                    case MouseState.Over:
                        LinearGradientBrush lgbVV = new LinearGradientBrush(ClientRectangle, Color.FromArgb(255, 186, 153), Color.FromArgb(255, 171, 135), 90);
                        G.FillPath(lgbVV, Draw.RoundRectF(ClientRectangle, 3));
                        G.DrawPath(p, Draw.RoundRectF(ClientRectangle, 3));

                        G.DrawString(Text, drawFont, nb, new Rectangle(0, 0, Width - 1, Height - 1), new StringFormat{Alignment = StringAlignment.Center, LineAlignment = StringAlignment.Center});
                        break;
                    case MouseState.Down:
                        LinearGradientBrush lgbTT = new LinearGradientBrush(ClientRectangle, Color.FromArgb(200, 116, 83), Color.FromArgb(194, 101, 65), 90);
                        G.FillPath(lgbTT, Draw.RoundRectF(ClientRectangle, 3));
                        G.DrawPath(p, Draw.RoundRectF(ClientRectangle, 3));

                        G.DrawString(Text, drawFont, nb, new Rectangle(0, 0, Width - 1, Height - 1), new StringFormat{Alignment = StringAlignment.Center,LineAlignment = StringAlignment.Center});
                        break;
                }

                e.Graphics.DrawImage((Image)B.Clone(), 0, 0);
            }
        }
    }

    void Dispose()
    {
        Dispose(true);
        // Suppress finalization.
        GC.SuppressFinalize(this);
    }
}
[DefaultEvent("Click")] public class MangoEButtonGray : Control
{
    #region " MouseStates "
    MouseState State = MouseState.None;
    protected override void OnMouseDown(System.Windows.Forms.MouseEventArgs e)
    {
        base.OnMouseDown(e);
        State = MouseState.Down;
        this.Invalidate();
    }
    protected override void OnMouseUp(System.Windows.Forms.MouseEventArgs e)
    {
        base.OnMouseUp(e);
        State = MouseState.Over;
        this.Invalidate();
    }
    protected override void OnMouseEnter(System.EventArgs e)
    {
        base.OnMouseEnter(e);
        State = MouseState.Over;
        this.Invalidate();
    }
    protected override void OnMouseLeave(System.EventArgs e)
    {
        base.OnMouseLeave(e);
        State = MouseState.None;
        this.Invalidate();
    }
    #endregion

    public MangoEButtonGray()
    {

        this.SetStyle(ControlStyles.AllPaintingInWmPaint | ControlStyles.OptimizedDoubleBuffer | ControlStyles.UserPaint | ControlStyles.ResizeRedraw | ControlStyles.SupportsTransparentBackColor | ControlStyles.FixedHeight, true);
        this.UpdateStyles();
        this.BackColor = Color.Transparent;
        ForeColor = Color.FromArgb(90, 84, 82);
    }

    protected override void OnPaint(System.Windows.Forms.PaintEventArgs e)
    {
        using (Bitmap B = new Bitmap(Width, Height))
        {
            using (Graphics G = Graphics.FromImage(B))
            {
                Rectangle ClientRectangle = new Rectangle(0, 0, Width - 1, Height - 1);
                base.OnPaint(e);
                G.SmoothingMode = SmoothingMode.HighQuality;
                Font drawFont = new Font("Tahoma", 11, FontStyle.Regular);
                Pen p = new Pen(Color.FromArgb(166, 166, 166), 1);
                Brush nb = new SolidBrush(Color.FromArgb(80, 84, 82));

                G.TextRenderingHint = System.Drawing.Text.TextRenderingHint.ClearTypeGridFit;

                switch (State)
                {
                    case MouseState.None:

                        LinearGradientBrush lgb = new LinearGradientBrush(ClientRectangle, Color.FromArgb(223, 223, 223), Color.FromArgb(197, 197, 197), 90);
                        G.FillPath(lgb, Draw.RoundRectF(ClientRectangle, 3));
                        G.DrawPath(p, Draw.RoundRectF(ClientRectangle, 3));

                        G.DrawString(Text, drawFont, nb, new Rectangle(0, 0, Width - 1, Height - 1), new StringFormat{Alignment = StringAlignment.Center,LineAlignment = StringAlignment.Center});
                        break;
                    case MouseState.Over:
                        LinearGradientBrush lgbFF = new LinearGradientBrush(ClientRectangle, Color.FromArgb(243, 243, 243), Color.FromArgb(217, 217, 217), 90);
                        G.FillPath(lgbFF, Draw.RoundRectF(ClientRectangle, 3));
                        G.DrawPath(p, Draw.RoundRectF(ClientRectangle, 3));

                        G.DrawString(Text, drawFont, nb, new Rectangle(0, 0, Width - 1, Height - 1), new StringFormat{Alignment = StringAlignment.Center,LineAlignment = StringAlignment.Center});
                        break;
                    case MouseState.Down:
                        LinearGradientBrush lgbII = new LinearGradientBrush(ClientRectangle, Color.FromArgb(212, 211, 216), Color.FromArgb(156, 155, 151), 90);
                        G.FillPath(lgbII, Draw.RoundRectF(ClientRectangle, 3));
                        G.DrawPath(p, Draw.RoundRectF(ClientRectangle, 3));

                        G.DrawString(Text, drawFont, nb, new Rectangle(0, 0, Width - 1, Height - 1), new StringFormat{Alignment = StringAlignment.Center,LineAlignment = StringAlignment.Center});
                        break;
                }

                e.Graphics.DrawImage((Image)B.Clone(), 0, 0);
            }
        }
    }

    void Dispose()
    {
        Dispose(true);
        // Suppress finalization.
        GC.SuppressFinalize(this);
    }
}
[DefaultEvent("CheckedChanged")] public class MangoECheckBox : Control
{

    #region " Control Help - MouseState & Flicker Control"
    private MouseState State = MouseState.None;
    protected override void OnMouseEnter(System.EventArgs e)
    {
        base.OnMouseEnter(e);
        State = MouseState.Over;
        this.Invalidate();
    }
    protected override void OnMouseDown(System.Windows.Forms.MouseEventArgs e)
    {
        base.OnMouseDown(e);
        State = MouseState.Down;
        this.Invalidate();
    }
    protected override void OnMouseLeave(System.EventArgs e)
    {
        base.OnMouseLeave(e);
        State = MouseState.None;
        this.Invalidate();
    }
    protected override void OnMouseUp(System.Windows.Forms.MouseEventArgs e)
    {
        base.OnMouseUp(e);
        State = MouseState.Over;
        this.Invalidate();
    }
    protected override void OnTextChanged(EventArgs e)
    {
        base.OnTextChanged(e);
        this.Width = 24 + Convert.ToInt32(this.CreateGraphics().MeasureString(Text, Font).Width);
    }
    private bool _Checked;
    public bool Checked
    {
        get { return _Checked; }
        set
        {
            if (value.Equals(_Checked)) return;
            _Checked = value;
            this.Invalidate();
        }
    }
    protected override void OnResize(System.EventArgs e)
    {
        base.OnResize(e);
        Height = 14;
    }
    protected override void OnClick(System.EventArgs e)
    {
        _Checked = !_Checked;
        if (CheckedChanged != null) CheckedChanged(this);
        base.OnClick(e);
    }
    public event CheckedChangedEventHandler CheckedChanged;
    public delegate void CheckedChangedEventHandler(object sender);
    #endregion

    public MangoECheckBox(): base()
    {
        this.SetStyle(ControlStyles.AllPaintingInWmPaint | ControlStyles.OptimizedDoubleBuffer | ControlStyles.UserPaint | ControlStyles.ResizeRedraw | ControlStyles.SupportsTransparentBackColor | ControlStyles.FixedHeight, true);
        this.UpdateStyles();
        this.Size = new Size(145, 16);
        this.BackColor = Color.Transparent;
        this.ForeColor = Color.Black;
    }

    protected override void OnPaint(System.Windows.Forms.PaintEventArgs e)
    {
        using (Bitmap B = new Bitmap(Width, Height))
        {
            using (Graphics G = Graphics.FromImage(B))
            {
                Rectangle checkBoxRectangle = new Rectangle(0, 0, Height - 1, Height - 1);

                LinearGradientBrush bodyGrad = new LinearGradientBrush(checkBoxRectangle, Color.FromArgb(102, 101, 96), Color.FromArgb(76, 75, 71), 90);
                G.FillRectangle(bodyGrad, bodyGrad.Rectangle);
                G.DrawRectangle(new Pen(Color.Gray), new Rectangle(1, 1, Height - 3, Height - 3));
                G.DrawRectangle(new Pen(Color.FromArgb(42, 47, 49)), checkBoxRectangle);

         
                Font drawFont = new Font("Tahoma", 10, FontStyle.Regular);
                Brush nb = new SolidBrush(Color.FromArgb(86, 83, 87));

                G.TextRenderingHint = System.Drawing.Text.TextRenderingHint.ClearTypeGridFit;
                G.DrawString(Text, drawFont, nb, new Point(16, 7), new StringFormat{Alignment = StringAlignment.Near,LineAlignment = StringAlignment.Center});


                if (Checked)
                {
                    Rectangle chkPoly = new Rectangle(Convert.ToInt32(checkBoxRectangle.X + checkBoxRectangle.Width / 4), Convert.ToInt32(checkBoxRectangle.Y + checkBoxRectangle.Height / 4), checkBoxRectangle.Width / 2, checkBoxRectangle.Height / 2);
                    Point[] Poly = {
						new Point(chkPoly.X, chkPoly.Y + chkPoly.Height / 2),
						new Point(chkPoly.X + chkPoly.Width / 2, chkPoly.Y + chkPoly.Height),
						new Point(chkPoly.X + chkPoly.Width, chkPoly.Y)
					};
                    G.SmoothingMode = SmoothingMode.HighQuality;
                    Pen P1 = new Pen(Color.FromArgb(247, 150, 116), 2);
                    LinearGradientBrush chkGrad = new LinearGradientBrush(chkPoly, Color.FromArgb(200, 200, 200), Color.FromArgb(255, 255, 255), (float) 0);
                    for (int i = 0; i <= Poly.Length - 2; i++)
                    {
                        G.DrawLine(P1, Poly[i], Poly[i + 1]);
                    }
                }

                e.Graphics.DrawImage((Image)B.Clone(), 0, 0);
            }
        }
    }


    void Dispose()
    {
        Dispose(true);
        // Suppress finalization.
        GC.SuppressFinalize(this);
    }
}
[DefaultEvent("CheckedChanged")] public class MangoERadioButton : Control
{
    #region "Control Help - MouseState & Flicker Control"
    private MouseState State = MouseState.None;
    protected override void OnMouseEnter(System.EventArgs e)
    {
        base.OnMouseEnter(e);
        State = MouseState.Over;
        this.Invalidate();
    }
    protected override void OnMouseDown(System.Windows.Forms.MouseEventArgs e)
    {
        base.OnMouseDown(e);
        State = MouseState.Down;
        this.Invalidate();
    }
    protected override void OnMouseLeave(System.EventArgs e)
    {
        base.OnMouseLeave(e);
        State = MouseState.None;
        this.Invalidate();
    }
    protected override void OnMouseUp(System.Windows.Forms.MouseEventArgs e)
    {
        base.OnMouseUp(e);
        State = MouseState.Over;
        this.Invalidate();
    }
    protected override void OnResize(System.EventArgs e)
    {
        base.OnResize(e);
        Height = 16;
    }
    protected override void OnTextChanged(EventArgs e)
    {
        base.OnTextChanged(e);
        this.Width = 24 + Convert.ToInt32(this.CreateGraphics().MeasureString(Text, Font).Width);
    }
    private bool _Checked;
    public bool Checked
    {
        get { return _Checked; }
        set
        {
            if (value.Equals(_Checked)) return;
            _Checked = value;
            if(_Checked) InvalidateControls();
            if (CheckedChanged != null) CheckedChanged(this);
            this.Invalidate();
        }
    }
    protected override void OnClick(EventArgs e)
    {
        if (!Checked) Checked = true;
        base.OnClick(e);
    }
    public event CheckedChangedEventHandler CheckedChanged;
    public delegate void CheckedChangedEventHandler(object sender);
    protected override void OnCreateControl()
    {
        base.OnCreateControl();
        InvalidateControls();
    }
    private void InvalidateControls()
    {
        if (!IsHandleCreated || !_Checked) return;

        foreach (Control C in Parent.Controls)
        {
            if (!object.ReferenceEquals(C, this) && C is MangoERadioButton) ((MangoERadioButton)C).Checked = false;
        }
    }
    #endregion

    public MangoERadioButton() : base()
    {
        this.SetStyle(ControlStyles.AllPaintingInWmPaint | ControlStyles.OptimizedDoubleBuffer | ControlStyles.UserPaint | ControlStyles.ResizeRedraw | ControlStyles.SupportsTransparentBackColor | ControlStyles.FixedHeight, true);
        this.UpdateStyles();
        this.Size = new Size(150, 16);
        this.BackColor = Color.Transparent;
        this.ForeColor = Color.Black;
    }

    protected override void OnPaint(System.Windows.Forms.PaintEventArgs e)
    {
        using (Bitmap B = new Bitmap(Width, Height))
        {
            using (Graphics G = Graphics.FromImage(B))
            {
                Rectangle radioBtnRectangle = new Rectangle(0, 0, Height - 1, Height - 1);

                G.SmoothingMode = SmoothingMode.HighQuality;



                LinearGradientBrush bgGrad = new LinearGradientBrush(radioBtnRectangle, Color.FromArgb(0, 191, 255), Color.FromArgb(16, 78, 139), 90);
                G.FillEllipse(bgGrad, radioBtnRectangle);

                G.DrawEllipse(new Pen(Color.Gray), new Rectangle(1, 1, Height - 3, Height - 3));
                G.DrawEllipse(new Pen(Color.FromArgb(42, 47, 49)), radioBtnRectangle); //UmRandung
               
                if (Checked)
                {
                    LinearGradientBrush chkGrad = new LinearGradientBrush(new Rectangle(4, 4, Height - 9, Height - 9), Color.FromArgb(247, 150, 116), Color.FromArgb(197, 100, 66), 90);
                    G.FillEllipse(chkGrad, new Rectangle(4, 4, Height - 9, Height - 9));
                }

                Font drawFont = new Font("Calibri", 10, FontStyle.Regular);
                Brush nb = new SolidBrush(Color.FromArgb(86, 83, 87));

                G.TextRenderingHint = System.Drawing.Text.TextRenderingHint.ClearTypeGridFit;
                G.DrawString(Text, drawFont, nb, new Point(16, 1), new StringFormat {Alignment = StringAlignment.Near,LineAlignment = StringAlignment.Near});

                e.Graphics.DrawImage((Image)B.Clone(), 0, 0);
            }
        }
    }


    void Dispose()
    {
        Dispose(true);
        // Suppress finalization.
        GC.SuppressFinalize(this);
    }
}
[DefaultEvent("TextChanged")] public class MangoETextBox : Control
{
    private TextBox tB = new TextBox();
    
    #region "Control Help - Properties & Flicker Control"

   

    private bool _passmask = false;

    public  bool UseSystemPasswordChar
    {
        get {return _passmask;}

        set
        {
            if (value.Equals(_passmask)) return;
            tB.UseSystemPasswordChar = UseSystemPasswordChar;
            _passmask = value;
            this.Invalidate();
        }
    }

    private int _maxchars = 32767;
    public int MaxLength
    {
        get {return _maxchars;}
        set
        {
            if (value == _maxchars) return;
            _maxchars = value;
            tB.MaxLength = MaxLength;
            this.Invalidate();
        }
    }
    private HorizontalAlignment _align;
    public  HorizontalAlignment TextAlignment
    {
        get {return _align;}
        set
        {
            if (value.Equals(_align)) return;
            _align = value;
            this.Invalidate();
        }
    }

    public void tb_TextChanged(object sender, EventArgs e) { this.Text = tB.Text; }

    protected override void OnPaintBackground(System.Windows.Forms.PaintEventArgs pevent) {}
    protected override void OnTextChanged(System.EventArgs e)
    {
        base.OnTextChanged(e);
        tB.Text = Text;
        this.Invalidate();
    }
    protected override void OnBackColorChanged(System.EventArgs e)
    {
        base.OnBackColorChanged(e);
        tB.BackColor = Color.White;
        this.Invalidate();
    }
    protected override void OnForeColorChanged(System.EventArgs e)
    {
        base.OnForeColorChanged(e);
        tB.ForeColor = ForeColor;
        this.Invalidate();
    }
    protected override void OnFontChanged(System.EventArgs e)
    {
        base.OnFontChanged(e);
        tB.Font = Font;
    }
    protected override void OnGotFocus(System.EventArgs e)
    {
        base.OnGotFocus(e);
        tB.Focus();
    }
    public void NewTextBox()
    {
        var _with1 = tB;
        _with1.Multiline = false;
        _with1.ForeColor = ForeColor;
        _with1.BackColor = Color.White;
        _with1.Text = String.Empty;
        _with1.TextAlign = HorizontalAlignment.Center;
        _with1.BorderStyle = BorderStyle.None;
        _with1.Location = new Point(5, 4);
        _with1.Font = new Font("Trebuchet MS", 8.25f, FontStyle.Bold);
        _with1.Size = new Size(Width - 10, Height - 11);
        _with1.UseSystemPasswordChar = UseSystemPasswordChar;
        _with1.TextChanged += new System.EventHandler(this.tb_TextChanged);
        this.Controls.Add(_with1);
    }
    #endregion

    public MangoETextBox() : base()
    {
        this.SetStyle(ControlStyles.AllPaintingInWmPaint | ControlStyles.OptimizedDoubleBuffer | ControlStyles.UserPaint | ControlStyles.ResizeRedraw | ControlStyles.SupportsTransparentBackColor | ControlStyles.FixedHeight, true);
        this.UpdateStyles();
        this.BackColor = Color.White;
        this.ForeColor = Color.FromArgb(102, 102, 102);
        this.Size = new Size(135, 35);

        NewTextBox();
        Text = string.Empty;
    }

    protected override void OnPaint(System.Windows.Forms.PaintEventArgs e)
    {
        using (Bitmap B = new Bitmap(Width, Height))
        {
            using (Graphics G = Graphics.FromImage(B))
            {

                Rectangle ClientRectangle = new Rectangle(0, 0, Width - 1, Height - 1);

                Height = tB.Height + 11;
                Font drawFont = new Font("Tahoma", 9, FontStyle.Regular);
                var _with2 = tB;
                _with2.Width = Width - 12;
                _with2.ForeColor = Color.FromArgb(102, 102, 102);
                _with2.Font = drawFont;
                _with2.TextAlign = TextAlignment;
                _with2.UseSystemPasswordChar = UseSystemPasswordChar;

                G.Clear(BackColor);

                G.SmoothingMode = SmoothingMode.HighQuality;
                G.CompositingQuality = CompositingQuality.HighQuality;

                G.FillRectangle(new SolidBrush(Color.White), ClientRectangle);
                G.DrawPath(new Pen(Color.FromArgb(0, 191, 255)), Draw.RoundRectF(new Rectangle(1, 1, Width - 3, Height - 3), 1));
                G.DrawPath(new Pen(Color.FromArgb(0, 191, 255)), Draw.RoundRectF(new Rectangle(1, 1, Width - 3, Height - 3), 2));
                G.DrawPath(new Pen(Color.FromArgb(16, 78, 139)), Draw.RoundRectF(new Rectangle(0, 0, Width - 1, Height - 1), 2));
                G.DrawPath(new Pen(Color.FromArgb(16, 78, 139)), Draw.RoundRectF(new Rectangle(0, 0, Width - 1, Height - 1), 3));


                e.Graphics.DrawImage((Image)B.Clone(), 0, 0);
            }
        }
    }

    void Dispose()
    {
        Dispose(true);
        // Suppress finalization.
        GC.SuppressFinalize(this);
    }
}
[DefaultEvent("Click")] public class StudioMinimizeButton : Control
{
    public enum State : short
    {
        DeActivated = 0,
        Activated = 1
    }
    private State CurrSt = State.DeActivated;
    private struct ButtonState
    {
        public readonly Bitmap CurrButton;
        public ButtonState(Bitmap button) { this.CurrButton = button; }
    }
    private ButtonState[] buttonStates = 
    {
		new ButtonState(MangoETheme.Properties.Resources.MinimizeUnlighted),
		new ButtonState(MangoETheme.Properties.Resources.MinimizeLighted)
	};
    public StudioMinimizeButton()
    {
        this.SetStyle(ControlStyles.AllPaintingInWmPaint | ControlStyles.OptimizedDoubleBuffer | ControlStyles.UserPaint | ControlStyles.ResizeRedraw | ControlStyles.SupportsTransparentBackColor | ControlStyles.FixedHeight, true);
        this.UpdateStyles();
        this.MinimumSize = new Size(11, 4);
        this.MaximumSize = new Size(11, 4);
        this.Size = new Size(11, 4);
        this.BackColor = Color.Transparent;
    }
    private void Redraw(Graphics gr)
    {
        ButtonState buttonState = buttonStates[(int)CurrSt];
        gr.DrawImage(buttonState.CurrButton, new Point(0, 0));
    }
    protected override void OnPaint(System.Windows.Forms.PaintEventArgs pevent) { Redraw(pevent.Graphics); }
    protected override void OnMouseDown(System.Windows.Forms.MouseEventArgs mevent)
    {
        CurrSt = State.Activated;
        this.Invalidate();
        base.OnMouseDown(mevent);
    }
    protected override void OnMouseEnter(System.EventArgs e)
    {
        CurrSt = State.Activated;
        this.Invalidate();
        base.OnMouseEnter(e);
    }
    protected override void OnLeave(System.EventArgs e)
    {
        CurrSt = State.DeActivated;
        this.Invalidate();
        base.OnLeave(e);
    }
    protected override void OnMouseLeave(System.EventArgs e)
    {
        CurrSt = State.DeActivated;
        this.Invalidate();
        base.OnMouseLeave(e);
    }
    protected override void OnMouseUp(System.Windows.Forms.MouseEventArgs mevent)
    {
        CurrSt = State.Activated;
        this.Invalidate();
        base.OnMouseUp(mevent);
    }

    void Dispose()
    {
        Dispose(true);
        // Suppress finalization.
        GC.SuppressFinalize(this);
    }
}
[DefaultEvent("Click")] public class StudioExitButton : Control 
{
	public enum State : short
	{
		DeActivated = 0,
		Activated = 1
	}
    private State CurrSt = State.DeActivated;
	private struct ButtonState
	{
		public readonly Bitmap CurrButton;
		public ButtonState(Bitmap button){this.CurrButton = button;}
	}
	private ButtonState[] buttonStates = 
    {
		new ButtonState(MangoETheme.Properties.Resources.ExitUnlighted),
		new ButtonState(MangoETheme.Properties.Resources.ExitLighted)
	};
	public StudioExitButton()
	{
        this.SetStyle(ControlStyles.AllPaintingInWmPaint | ControlStyles.OptimizedDoubleBuffer | ControlStyles.UserPaint | ControlStyles.ResizeRedraw | ControlStyles.SupportsTransparentBackColor | ControlStyles.FixedHeight, true);
        this.UpdateStyles();
        this.MinimumSize = new Size(11, 12);
        this.MaximumSize = new Size(11, 12);
        this.Size = new Size(11, 12);
        this.BackColor = Color.Transparent;
	}
	private void Redraw(Graphics gr)
	{
        ButtonState buttonState = buttonStates[(int)CurrSt];
		gr.DrawImage(buttonState.CurrButton, new Point(0, 0));
	}
	protected override void OnPaint(System.Windows.Forms.PaintEventArgs pevent){Redraw(pevent.Graphics);}
	protected override void OnMouseDown(System.Windows.Forms.MouseEventArgs mevent)
	{
        CurrSt = State.Activated;
		this.Invalidate();
		base.OnMouseDown(mevent);
	}
	protected override void OnMouseEnter(System.EventArgs e)
	{
        CurrSt = State.Activated;
		this.Invalidate();
		base.OnMouseEnter(e);
	}
	protected override void OnLeave(System.EventArgs e)
	{
        CurrSt = State.DeActivated;
		this.Invalidate();
		base.OnLeave(e);
	}
	protected override void OnMouseLeave(System.EventArgs e)
	{
        CurrSt = State.DeActivated;
		this.Invalidate();
		base.OnMouseLeave(e);
	}
	protected override void OnMouseUp(System.Windows.Forms.MouseEventArgs mevent)
	{
        CurrSt = State.Activated;
		this.Invalidate();
		base.OnMouseUp(mevent);
	}

    void Dispose()
    {
        Dispose(true);
        // Suppress finalization.
        GC.SuppressFinalize(this);
    }
}
[DefaultEvent("CheckedChanged")]public class AppleCheckBox : Control
{
    public event EventHandler CheckedChanged;
    private bool Checkd = false;
    public enum State : short
    {
        DeActivated = 0,
        Activated = 1
    }
    private State CurrSt = State.DeActivated;
    private struct ButtonState
    {
        public readonly Bitmap CurrButton;
        public ButtonState(Bitmap button) { this.CurrButton = button; }
    }

    private ButtonState[] buttonStates = 
    {
		new ButtonState(MangoETheme.Properties.Resources.AppleCheckBoxUnChecked),
		new ButtonState(MangoETheme.Properties.Resources.AppleCheckBoxChecked)
	};

    public AppleCheckBox()
    {
        this.SetStyle(ControlStyles.AllPaintingInWmPaint | ControlStyles.OptimizedDoubleBuffer | ControlStyles.UserPaint | ControlStyles.ResizeRedraw | ControlStyles.SupportsTransparentBackColor | ControlStyles.FixedHeight, true);
        this.UpdateStyles();
        this.MinimumSize = new Size(18, 18);
        this.Size = new Size(18, 18);
        this.BackColor = Color.Transparent;
    }
    private void Redraw(Graphics gr)
    {
        ButtonState buttonState = buttonStates[(int)CurrSt];
        gr.DrawImage(buttonState.CurrButton, 0, 0, buttonState.CurrButton.Width, buttonState.CurrButton.Height);

        Font drawFont = new Font("Tahoma", 10, FontStyle.Regular);

    
      
        this.Font = drawFont;
        this.Width = 12 + Convert.ToInt32(this.CreateGraphics().MeasureString(Text, Font).Width);
        if (Text.Length <= 6) this.Width += 4;

        gr.TextRenderingHint = System.Drawing.Text.TextRenderingHint.ClearTypeGridFit;

        using (SolidBrush nb = new SolidBrush(Color.FromArgb(86, 83, 87)))
        {
            gr.DrawString(Text, drawFont, nb, new Point(18, 8), new StringFormat { Alignment = StringAlignment.Near, LineAlignment = StringAlignment.Center });
        }
        

    }

    protected override void OnTextChanged(EventArgs e)
    {
        base.OnTextChanged(e);
        this.Width = 12 + Convert.ToInt32(this.CreateGraphics().MeasureString(Text, Font).Width);
        if (Text.Length <= 6) this.Width += 4;
    }
    protected override void OnPaint(PaintEventArgs pevent) { Redraw(pevent.Graphics); }

    protected override void OnClick(EventArgs e)
    {
        base.OnClick(e);
        Checked = !Checked;
        this.Invalidate();
    }

    [Browsable(true), DesignerSerializationVisibility(DesignerSerializationVisibility.Visible)]
    public bool Checked
    {
        get {return Checkd;}
        set
        {
            if (Checkd == value) return;
            Checkd = value;
            if (Checkd) CurrSt = State.Activated; else CurrSt = State.DeActivated;
            this.Invalidate();
            if (CheckedChanged != null) CheckedChanged(this, EventArgs.Empty);
        }
    }
    public override Font Font
    {
        get { return base.Font; }
        set
        {
            if (base.Font.Equals(value)) return;
            base.Font = value;
            this.Invalidate();
        }
    }

    void Dispose()
    {
        Dispose(true);
        // Suppress finalization.
        GC.SuppressFinalize(this);
    }
}
[DefaultEvent("CheckedChanged")] public class AppleRadioButton : Control
{
	public event EventHandler CheckedChanged;
	private bool Checkd = false;
	public enum State : short
	{
		DeActivated = 0,
		Activated = 1
	}
    private State CurrSt = State.DeActivated;
	private struct ButtonState
	{
		public readonly Bitmap CurrButton;
		public ButtonState(Bitmap button){this.CurrButton = button;}
	}

	private ButtonState[] buttonStates = 
    {
		new ButtonState(MangoETheme.Properties.Resources.AppleRadioButtonUnChecked),
		new ButtonState(MangoETheme.Properties.Resources.AppleRadioButtonChecked)
	};

	public AppleRadioButton()
	{
        this.SetStyle(ControlStyles.AllPaintingInWmPaint | ControlStyles.OptimizedDoubleBuffer | ControlStyles.UserPaint | ControlStyles.ResizeRedraw | ControlStyles.SupportsTransparentBackColor | ControlStyles.FixedHeight, true);
        this.UpdateStyles();
		this.MinimumSize = new Size(16, 16);
        this.MaximumSize = new Size(16, 16);
        this.Size = new Size(16, 16);
        this.BackColor = Color.Transparent;
	}
	private void Redraw(Graphics gr)
	{
        ButtonState buttonState = buttonStates[(int)CurrSt];
		gr.DrawImage(buttonState.CurrButton, 0, 0, buttonState.CurrButton.Width, buttonState.CurrButton.Height);
		gr.TextRenderingHint = System.Drawing.Text.TextRenderingHint.ClearTypeGridFit;
		gr.DrawString(Text, Font, Brushes.Black, 18, 0);
	}

	protected override void OnTextChanged(EventArgs e)
	{
		base.OnTextChanged(e);
        this.Width = 24 + Convert.ToInt32(this.CreateGraphics().MeasureString(Text, Font).Width);
	}
	protected override void OnPaint(PaintEventArgs pevent) {Redraw(pevent.Graphics);}
	protected override void OnClick(EventArgs e)
	{
		base.OnClick(e);
		foreach (Control C in Parent.Controls) 
        {
			if (C is AppleRadioButton) ((AppleRadioButton)C).Checked = false;
		}
		Checked = true;
		this.Invalidate();
	}

    [Browsable(true), DesignerSerializationVisibility(DesignerSerializationVisibility.Visible)]
    public bool Checked
    {
        get { return Checkd; }
        set
        {
            if (Checkd == value) return;
            Checkd = value;
            if (Checkd) CurrSt = State.Activated; else CurrSt = State.DeActivated;
            this.Invalidate();
            if (CheckedChanged != null) CheckedChanged(this, EventArgs.Empty);
        }
    }
	public override Font Font 
    {
		get {return base.Font;}
		set 
        {
            if (base.Font.Equals(value)) return;
			base.Font = value;
			Invalidate();
		}
	}

    void Dispose()
    {
        Dispose(true);
        // Suppress finalization.
        GC.SuppressFinalize(this);
    }
}
[DefaultEvent("Click")] public class FakeMacButton : Control
{
    private State CurrSt = State.Normal;
	private struct ButtonState
	{
		public readonly Bitmap Li,Mi,Ri;
		public ButtonState(Bitmap left, Bitmap middle, Bitmap right)
		{
			this.Li = left;
			this.Mi = middle;
			this.Ri = right;
		}
	}
	private ButtonState[] buttonStates = 
    {
		new ButtonState(MangoETheme.Properties.Resources.MacBtnLeft, MangoETheme.Properties.Resources.MacBtnMiddle, MangoETheme.Properties.Resources.MacBtnRight),
		new ButtonState(MangoETheme.Properties.Resources.MacBtnLeftEntered, MangoETheme.Properties.Resources.MacBtnMiddleEntered, MangoETheme.Properties.Resources.MacBtnRightEntered),
		new ButtonState(MangoETheme.Properties.Resources.MacBtnLeftPressed, MangoETheme.Properties.Resources.MacBtnMiddlePressed, MangoETheme.Properties.Resources.MacBtnRightPressed)
	};
	public enum State : short
	{
		Normal = 0,
		Entered = 1,
		Down = 2
	}
	public FakeMacButton()
	{
        this.SetStyle(ControlStyles.AllPaintingInWmPaint | ControlStyles.OptimizedDoubleBuffer | ControlStyles.UserPaint | ControlStyles.ResizeRedraw | ControlStyles.SupportsTransparentBackColor, true);
        this.UpdateStyles();
        this.MinimumSize = new Size(53, 20);
        this.Size = new Size(53, 20);
        this.BackColor = Color.Transparent;
	}
	public void Redraw(Graphics gr)
	{
        ButtonState buttonState = buttonStates[(int) CurrSt];

        gr.DrawImage(buttonState.Li, 0, 0, buttonState.Li.Width, this.Height);
		for (int i = buttonState.Li.Width; i <= this.Width - buttonState.Ri.Width - 1; i++) {
			gr.DrawImage(buttonState.Mi, i, 0, buttonState.Mi.Width, this.Height);
		}
		gr.DrawImage(buttonState.Ri, this.Width - buttonState.Ri.Width, 0, buttonState.Ri.Width, this.Height);

        SizeF textSize = this.CreateGraphics().MeasureString(Text, Font, Width - 4);
        StringFormat sf = new StringFormat() {LineAlignment = StringAlignment.Center, Alignment = StringAlignment.Center};
		gr.TextRenderingHint = System.Drawing.Text.TextRenderingHint.ClearTypeGridFit;
		gr.DrawString(Text, Font, Brushes.Black, new RectangleF(2, 2, this.Width - 5, this.Height - 4), sf);
	}
    protected override void OnTextChanged(EventArgs e)
    {
        base.OnTextChanged(e);
        this.Width = 24 + Convert.ToInt32(this.CreateGraphics().MeasureString(Text, Font).Width);
    }


	public override Font Font 
    {
		get {return base.Font;}
		set 
        {
            if (base.Font.Equals(value)) return;
			base.Font = value;
            this.Invalidate();
		}
	}
	[Browsable(true), EditorBrowsable(EditorBrowsableState.Always), DesignerSerializationVisibility(DesignerSerializationVisibility.Visible)]
	public override Color ForeColor 
    {
		get {return Color.Empty;}
		set 
        {
			if (base.ForeColor.Equals(value)) return;
			base.ForeColor = value;
            this.Invalidate();
		}
	}
	protected override void OnMouseDown(MouseEventArgs mevent)
	{
        CurrSt = State.Down;
		this.Invalidate();
		base.OnMouseDown(mevent);
	}
	protected override void OnMouseEnter(EventArgs e)
	{
        CurrSt = State.Entered;
		this.Invalidate();
		base.OnMouseEnter(e);
	}
	protected override void OnLeave(EventArgs e)
	{
        CurrSt = State.Normal;
		this.Invalidate();
		base.OnLeave(e);
	}
	protected override void OnMouseLeave(EventArgs e)
	{
        CurrSt = State.Normal;
		this.Invalidate();
		base.OnMouseLeave(e);
	}
	protected override void OnMouseUp(MouseEventArgs mevent)
	{
        CurrSt = State.Entered;
		this.Invalidate();
		base.OnMouseUp(mevent);
	}
	protected override void OnPaint(PaintEventArgs pevent){Redraw(pevent.Graphics);}

    void Dispose()
    {
        Dispose(true);
        // Suppress finalization.
        GC.SuppressFinalize(this);
    }
}
[DefaultEvent("ValueChanged")] public class MangoETrackBar : Control
    {
        public enum AndroidTrackBarState : short
        {
            Normal = 1,
            Pressed = 2,
            Hover = 3
        }

        private Color _valuelinecolor = Color.FromArgb(70, 151, 196);
        private Color _nonvaluelinecolor = Color.FromArgb(229, 229, 229);
        private Color _outercircle = Color.FromArgb(119, 206, 234);
        private AndroidTrackBarState _state = AndroidTrackBarState.Normal;
        private int spectrum, x, y;
        private bool ismousein = false;
        private Rectangle mover = new Rectangle();
        private int _value = 0;
        private int _minimum = 0;
        private int _maximum = 100;
        private int _largechange = 0;
        public int Value 
        {
            get {return this._value;}
            set {
                if (value <= _maximum && value >= _minimum)
                    _value = value;
                    this.Invalidate();
                }

        }
        public int Maximum 
        {
            get {return this._maximum;}
            set {
                if (_value <= value && value >= _minimum)
                    _maximum = value;
                    this.Invalidate();
            }
        }

        public int Minimum 
        {
            get {return this._minimum;}
            set {
                if (value <= _maximum && _value >= value) 
                  _minimum = value;
                this.Invalidate();
            }
        }

        public int LargeChange
        {
            get {return this._largechange;}
            set {
                if(_largechange != value)  
                    _largechange = value;
                   this.Invalidate();
            }
        }
        public MangoETrackBar()
        {
            this.SetStyle(ControlStyles.AllPaintingInWmPaint | ControlStyles.OptimizedDoubleBuffer | ControlStyles.UserPaint | ControlStyles.ResizeRedraw | ControlStyles.SupportsTransparentBackColor, true);
            this.UpdateStyles();
            this.MinimumSize = new Size(26, 24);
            this.Size = new Size(75, 24);
            this.BackColor = Color.Transparent;
        }
        #region Events
        protected override void OnPaint(PaintEventArgs e)
        {
            Graphics g = e.Graphics;
            g.SmoothingMode = SmoothingMode.AntiAlias;
            g.PixelOffsetMode = PixelOffsetMode.HighQuality;
            g.InterpolationMode = InterpolationMode.HighQualityBilinear;
            g.CompositingQuality = CompositingQuality.HighQuality;
            e.Graphics.DrawLine(new Pen(_nonvaluelinecolor), new Point(12, (int)Height / 2), new Point(Width - 12, (int)Height / 2));
            spectrum = Maximum - Minimum;

            double pix = (double) Math.Ceiling(((((float)Math.Abs(Minimum) + (float)Value) / (float)spectrum) * ((float)Width - 24)) + 12);
            int currsi = (int)Height / 2;
            
            Rectangle gr = new Rectangle((int)pix - 12, currsi - 12, 24, 24);
            Rectangle grt = new Rectangle((int)pix - 5, currsi - 5, 10, 10);
            mover = gr;

            if(_state == AndroidTrackBarState.Normal)
            {

                using (SolidBrush sb = new SolidBrush(_outercircle)) { e.Graphics.FillEllipse(sb, gr); }
                using (SolidBrush sbb = new SolidBrush(_valuelinecolor)) { e.Graphics.FillEllipse(sbb, grt); }
               
  
                g.DrawLine(new Pen(_valuelinecolor, 3), new Point(12, (int)(Height / 2)), new Point((int)pix, (int)Height / 2));
            }
            else if(_state == AndroidTrackBarState.Hover)
            {
                Color darkcolor = Color.FromArgb(_outercircle.A,
                                                 (int)((255 - _outercircle.R) * ((0.25) * 2) + _outercircle.R),
                                                 (int)((255 - _outercircle.G) * ((0.25) * 2) + _outercircle.G),
                                                 (int)((255 - _outercircle.B) * ((0.25) * 2) + _outercircle.B));
                
                using (SolidBrush sb = new SolidBrush(darkcolor)){g.FillEllipse(sb, gr);}
                using (SolidBrush sbb = new SolidBrush(_valuelinecolor)){g.FillEllipse(sbb, grt);}

                g.DrawLine(new Pen(_valuelinecolor, 3), new Point(12, (int)(Height / 2)), new Point((int)pix, (int)Height / 2));
            }
            base.OnPaint(e);

            e.Graphics.DrawString(this.Value.ToString(), new Font("Segoe UI", 7), Brushes.Black, new Point(7, this.Height - 10));
        }
        protected override void OnMouseDown(MouseEventArgs e)
        {
            if(x > mover.X && x < (mover.Width + mover.X) && y > mover.Y && y < (mover.Height + mover.Y))
            {
                ismousein = true;
                _state = AndroidTrackBarState.Normal;
            }
            base.OnMouseDown(e);
        }

  
        protected override void OnMouseMove(MouseEventArgs e)
        {
            x = e.X;
            y = e.Y;
            if(ismousein)
            {
                mover.X = e.X;
                float toch = (float)((float)e.X / (float)Width) * (float)spectrum - (float)Math.Abs(Minimum);
                if (toch > Maximum) toch = Maximum;
                if (toch < Minimum) toch = Minimum;
                Value = (int)Math.Ceiling(toch);
            }
            else
            {
                if (x > mover.X && x < (mover.Width + mover.X))
                {
                    if (y > mover.Y && y < (mover.Height + mover.Y)) _state = AndroidTrackBarState.Hover;  else _state = AndroidTrackBarState.Normal;
                  
                }
                
            }
            this.Invalidate();
            base.OnMouseMove(e);
        }
        protected override void OnMouseUp(MouseEventArgs e)
        {
            ismousein = false;
            base.OnMouseUp(e);
        }
        protected override void OnPreviewKeyDown(PreviewKeyDownEventArgs e)
        {

            switch(e.KeyCode)
            {
                case Keys.Right:
                    if (this.Value + 1 <= Maximum) this.Value += 1; else this.Value = this.Maximum;
                    break;

                case Keys.Left:
                   if (this.Value - 1 >= Minimum) this.Value -= 1;  else this.Value = this.Minimum;
                    break;

                case Keys.PageUp:
                    if (this.Value + LargeChange <= Maximum) this.Value += LargeChange; else  this.Value = this.Maximum;
                    break;

                case Keys.PageDown:
                    if (this.Value - LargeChange >= Minimum) this.Value -= LargeChange; else   this.Value = this.Minimum;   
                    break;
            }
            this.Invalidate();
            base.OnPreviewKeyDown(e);
        }
        #endregion
        
        protected override CreateParams CreateParams
        {
            get
            {
                CreateParams cp = base.CreateParams;
                cp.ExStyle = cp.ExStyle | 0x20;
                return cp;
            }
        }


        void Dispose()
        {
            Dispose(true);
            // Suppress finalization.
            GC.SuppressFinalize(this);
        }
    }




