package billard;

public class Line {
	private PhysicalVector startpoint;
	private PhysicalVector endpoint;
	private PhysicalVector direction;

	public Line(double x1, double y1, double x2, double y2) {
		double[] point		= new double[] { x1, y1 };
		this.startpoint		= new PhysicalVector(point);
		double[] direction	= new double[] { x2 - x1, y2 - y1 };
		this.direction		= new PhysicalVector(direction);
		this.endpoint		= this.startpoint.add(this.direction);
	}

	public Line(double x1, double y1, PhysicalVector p) {
		double[] point		= new double[] { x1, y1 };
		this.startpoint		= new PhysicalVector(point);
		this.direction		= p;
		this.endpoint		= this.startpoint.add(this.direction);
	}

	public PhysicalVector getStartPoint() {
		return this.startpoint;
	}

	public PhysicalVector getEndPoint() {
		return this.endpoint;
	}

	public PhysicalVector getDirection() {
		return this.direction;
	}

	public String toDataString() {
		return this.startpoint.toString() + "," + this.endpoint.toString() + "," + this.direction.toString();
	}
}