package billard;

import java.util.StringTokenizer;

public class PhysicalVector {
	private double[] components;

	public static int countSeperator(String a, char sep) {
		int cnt = 0;
		int l = a.length();
		boolean dirty = false;

		for (int i = 0; i < l; ++i) {
			if (a.charAt(i) == sep) {
				if (!dirty) {
					++cnt;
					dirty = true;
				}
			} else {
				dirty = false;
			}
		}

		return cnt;
	}

	public static PhysicalVector parsePhysicalVector(String s) {
		int size = countSeperator(s, ',');
		double[] d = new double[size + 1];
		StringTokenizer st = new StringTokenizer(s, ",");
		int var4 = 0;

		while (st.hasMoreTokens()) {
			try {
				d[var4++] = BillardTableDataCalculator.parseDouble(st.nextToken());
			} catch (NumberFormatException var6) {
				d[var4++] = 0.0D;
			}
		}

		return new PhysicalVector(d);
	}

	public PhysicalVector(int size) {
		this.components = new double[size];
		this.setAllTo(0.0D);
	}

	public PhysicalVector(double[] d) {
		this.components = d;
	}

	public PhysicalVector setOneTo(int i, double a) {
		this.components[i] = a;
		return this;
	}

	public int getSize() {
		return this.components.length;
	}

	public double[] getComponentsDbl() {
		return this.components;
	}

	public int[] getComponentsInt() {
		int[] c = new int[this.components.length];

		for (int i = this.components.length - 1; i >= 0; --i) {
			c[i] = (int) Math.round(this.components[i]);
		}

		return c;
	}

	public PhysicalVector setAllTo(double a) {
		for (int i = this.components.length - 1; i >= 0; --i) {
			this.components[i] = a;
		}

		return this;
	}

	public double getLength() {
		return Math.sqrt(this.getLengthSquare());
	}

	public double getLengthSquare() {
		double p = 0.0D;

		for (int i = this.components.length - 1; i >= 0; --i) {
			p += this.components[i] * this.components[i];
		}

		return p;
	}

	public PhysicalVector subIntern(PhysicalVector v) {
		if (v.getSize() == this.getSize()) {
			double[] c = v.getComponentsDbl();

			for (int i = this.components.length - 1; i >= 0; --i) {
				this.components[i] -= c[i];
			}
		}

		return this;
	}

	public PhysicalVector mulIntern(double s) {
		for (int i = this.components.length - 1; i >= 0; --i) {
			this.components[i] *= s;
		}

		return this;
	}

	public void addIntern(double s) {
		for (int i = this.components.length - 1; i >= 0; --i) {
			this.components[i] += s;
		}

	}

	public PhysicalVector addIntern(PhysicalVector v) {
		if (v.getSize() == this.getSize()) {
			double[] c = v.getComponentsDbl();

			for (int i = this.components.length - 1; i >= 0; --i) {
				this.components[i] += c[i];
			}
		}

		return this;
	}

	public PhysicalVector sub(PhysicalVector v) {
		if (v.getSize() != this.getSize()) {
			return null;
		} else {
			double[] d = new double[this.components.length];
			double[] c = v.getComponentsDbl();

			for (int i = this.components.length - 1; i >= 0; --i) {
				d[i] = this.components[i] - c[i];
			}

			return new PhysicalVector(d);
		}
	}

	public PhysicalVector mul(double s) {
		double[] d = new double[this.components.length];

		for (int i = this.components.length - 1; i >= 0; --i) {
			d[i] = this.components[i] * s;
		}

		return new PhysicalVector(d);
	}

	public PhysicalVector add(PhysicalVector v) {
		if (v.getSize() != this.getSize()) {
			return null;
		} else {
			double[] d = new double[this.components.length];
			double[] c = v.getComponentsDbl();

			for (int i = this.components.length - 1; i >= 0; --i) {
				d[i] = this.components[i] + c[i];
			}

			return new PhysicalVector(d);
		}
	}

	public boolean isZero() {
		for (int i = this.components.length - 1; i >= 0; --i) {
			if (this.components[i] != 0.0D) {
				return false;
			}
		}

		return true;
	}

	public double mul(PhysicalVector v) {
		double p = 0.0D;
		if (v.getSize() == this.getSize()) {
			double[] c = v.getComponentsDbl();

			for (int i = this.components.length - 1; i >= 0; --i) {
				p += this.components[i] * c[i];
			}
		}

		return p;
	}

	public PhysicalVector normToLengthIntern(double l) {
		double le = this.getLength();
		if (le != 0.0D) {
			this.mulIntern(l / le);
		}

		return this;
	}

	public PhysicalVector normToLength(double l) {
		double le = this.getLength();
		return le != 0.0D ? this.mul(l / le) : this.mul(0.0D);
	}

	public PhysicalVector getNormal() {
		if (this.getSize() == 2) {
			double[] d = new double[] { -this.components[1], this.components[0] };
			return new PhysicalVector(d);
		} else {
			return null;
		}
	}

	public PhysicalVector makeCloneIntern(PhysicalVector v) {
		if (v.getSize() == this.getSize()) {
			double[] c = v.getComponentsDbl();

			for (int i = this.components.length - 1; i >= 0; --i) {
				this.components[i] = c[i];
			}
		}

		return this;
	}

	public PhysicalVector getClone() {
		return this.mul(1.0D);
	}

	public String toString() {
		String s = "";
		if (this.components.length <= 0) {
			return "-";
		} else {
			s = s + "" + this.components[0];

			for (int i = 1; i < this.components.length; ++i) {
				s = s + "," + this.components[i];
			}

			return s;
		}
	}
}