package billard;

public class Hole {
	private PhysicalVector point;
	private double radius;
	public static final int NOMARK = 0;
	public static final int LIGHT = 1;
	public static final int STRONG = 2;
	private int marked = 0;

	public Hole(double x1, double y1, double r) {
		double[] point = new double[] { x1, y1 };
		this.marked = 0;
		this.point = new PhysicalVector(point);
		this.radius = r;
	}

	public Hole(PhysicalVector p, double r) {
		this.point = p;
		this.radius = r;
	}

	public PhysicalVector getCenter() {
		return this.point;
	}

	public double getDistance(double x, double y) {
		double[] d = new double[] { x, y };
		PhysicalVector p = new PhysicalVector(d);
		return p.subIntern(this.point).getLength();
	}

	public void setCenter(PhysicalVector p) {
		this.point = p;
	}

	public double getRadius() {
		return this.radius;
	}

	public void setMark(int i) {
		this.marked = i;
	}

	public int getMark() {
		return this.marked;
	}

	public boolean isMarked(int type) {
		return this.marked == type;
	}

	public String toDataString() {
		return this.point.toString() + "," + this.radius + "," + this.marked;
	}
}