package billard;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;

@SuppressWarnings("unused")
public class Ball {
	public static final int DIMENSIONS = 2;
	public static double PI = 3.141592653589793D;
	public static final double SLIDINGFRICTION_norm = 123.0D;
	public static final double ROLLINGFRICTION_norm = 12.3D;
	public static final double LINEIMPULSELOSS = 0.5274884363D;
	public static final double BALLIMPULSELOSS = 0.98D;
	public static final double MINIMPULSELOSS = 0.01D;
	public static final double ROTATIONIMPULSELOSS = 0.95D;
	public static final int STILL = 0;
	public static final int ROLLING = 1;
	public static final int SLIDING = 2;
	public static final int ACCELERATING = 3;
	public static final int ANTIACCELERATING = 4;
	public static final double MATERIALCONST = 0.7D;
	public static final double ROTATIONENERGYLOSS = 0.5D;
	public static final double ROTATIONCONST;
	public static final double ROTATIONCONSTACC;
	public static final double ROUNDOFF = 1.0E-7D;
	public static final int NOMARK = 0;
	public static final int LIGHT = 1;
	public static final int STRONG = 2;
	public static Image markImg_Light;
	public static Image markImg_Strong;
	private Color borderColor;
	private Color col;
	private double size;
	private int scrSize;
	private PhysicalVector direction;
	private double speed;
	private double rotationspeed;
	private PhysicalVector position;
	private int movementType;
	private Image ballImage;
	private Image ballMaskImage;
	private ImageObserver imgObserver;
	private boolean onTable;
	private boolean markable;
	private int marked;
	public String name;
	public double SLIDINGFRICTION;
	public double ROLLINGFRICTION;
	double[] temp_pos;
	public int[] paintData;
	public int nextMovementType;

	public Ball(double size, Color c, Image img, Image imgMask, ImageObserver imgObserver) {
		this.borderColor = Color.black;
		this.movementType = 0;
		this.ballImage = null;
		this.ballMaskImage = null;
		this.imgObserver = null;
		this.onTable = false;
		this.markable = false;
		this.marked = 0;
		this.name = "";
		this.SLIDINGFRICTION = 123.0D;
		this.ROLLINGFRICTION = 12.3D;
		this.temp_pos = new double[2];
		this.paintData = new int[3];
		this.nextMovementType = 0;
		this.size = size;
		this.scrSize = (int) (size + 0.5D);
		this.col = c;
		this.ballImage = img;
		this.ballMaskImage = imgMask;
		this.imgObserver = imgObserver;
		this.onTable = false;
		this.markable = false;
		this.marked = 0;
		this.direction = new PhysicalVector(2);
		this.speed = 0.0D;
		this.rotationspeed = 0.0D;
		this.position = new PhysicalVector(2);
	}

	public void setImage(Image i) {
		this.ballImage = i;
	}

	public void setMark(int i) {
		this.marked = i;
	}

	public int getMark() {
		return this.marked;
	}

	public boolean isMarked(int type) {
		return this.marked == type;
	}

	public void setMarkable(boolean b) {
		this.markable = b;
	}

	public boolean isMarkable() {
		return this.markable;
	}

	public Ball getClone() {
		Ball b = new Ball(this.size, this.col, this.ballImage, this.ballMaskImage, this.imgObserver);
		b.name = this.name;
		b.startWith(this.movementType);
		b.setOnTable(this.onTable);
		b.setSpeed(this.speed, this.rotationspeed, this.direction.getClone());
		b.setPosition(this.position.getClone());
		b.setMark(this.marked);
		b.setMarkable(this.markable);
		b.setROLLINGFRICTION(this.getROLLINGFRICTION());
		b.setSLIDINGFRICTION(this.getSLIDINGFRICTION());
		return b;
	}

	public void stop() {
		this.speed = 0.0D;
		this.rotationspeed = 0.0D;
		this.movementType = 0;
	}

	public void drop() {
		this.stop();
		this.setMark(0);
		this.onTable = false;
	}

	public void move(double time) {
		if (this.isReallyMoving()) {
			double friction = this.getFriction();
			PhysicalVector temp = this.direction.mul(this.speed * time);
			if (time > 0.0D) {
				PhysicalVector pv = this.direction.mul(friction * time * time / 2.0D);
				if (this.movementType == 3) {
					temp.addIntern(pv);
				} else {
					temp.subIntern(pv);
				}
			}

			this.position.addIntern(temp);
			switch (this.movementType) {
			case 0:
			default:
				break;
			case 1:
				this.speed -= friction * time;
				this.rotationspeed = this.speed;
				break;
			case 2:
				this.speed -= friction * time;
				this.rotationspeed += friction * time * ROTATIONCONST;
				break;
			case 3:
				this.speed += friction * time;
				this.rotationspeed -= friction * time * ROTATIONCONSTACC;
				break;
			case 4:
				this.speed -= friction * time;
				this.rotationspeed += friction * time * ROTATIONCONSTACC;
			}
		}

	}

	public void forceMove(double time, double friction) {
		PhysicalVector temp = this.direction.mul(this.speed * time);
		if (time > 0.0D) {
			temp.subIntern(this.direction.mul(friction * time * time / 2.0D));
		}

		this.position.addIntern(temp);
		this.speed -= friction * time;
	}

	public void startWith(int type) {
		switch (type) {
		case 0:
			this.stop();
			break;
		case 1:
			this.rotationspeed = this.speed;
			break;
		case 2:
			if (this.rotationspeed < 0.0D) {
				this.rotationspeed = 0.0D;
			}
			break;
		case 3:
			if (this.speed < 0.0D) {
				this.speed = 0.0D;
			}

			if (this.rotationspeed < 0.0D) {
				this.direction.mulIntern(-1.0D);
				this.rotationspeed = -this.rotationspeed;
			}
		}

		this.movementType = type;
	}

	public double getSize() {
		return this.size;
	}

	public boolean isMovingOnTable() {
		return this.onTable ? this.isReallyMoving() : false;
	}

	public boolean isReallyMoving() {
		return this.speed != 0.0D || this.rotationspeed != 0.0D;
	}

	public boolean isOnTable() {
		return this.onTable;
	}

	public void setOnTable(boolean b) {
		this.onTable = b;
	}

	public PhysicalVector getDirection() {
		return this.direction;
	}

	public double getSpeed() {
		return this.speed;
	}

	public double getRotationspeed() {
		return this.rotationspeed;
	}

	public int getMovementType() {
		return this.movementType;
	}

	public void setSpeed(double s) {
		this.speed = s;
	}

	public void setSpeed(double s, double r, PhysicalVector direction) {
		if (s == 0.0D && r == 0.0D) {
			this.stop();
		} else {
			this.direction = direction.normToLengthIntern(1.0D);
			this.speed = s;
			this.rotationspeed = r;
		}

	}

	public PhysicalVector getPosition() {
		return this.position;
	}

	public void setPosition(PhysicalVector p) {
		this.position = p;
	}

	public void adjustMovementType() {
		double s = this.speed;
		double r = this.rotationspeed;
		if (s < 1.0E-7D && r < 1.0E-7D && r > -1.0E-7D) {
			this.stop();
		} else if (r + 1.0E-7D > s && r - 1.0E-7D < s) {
			this.startWith(1);
		} else if (r >= -1.0E-7D && r < s) {
			this.startWith(2);
		} else if (r < 0.0D) {
			this.startWith(4);
		} else if (r > s) {
			this.startWith(3);
		}

	}

	public double getFriction() {
		switch (this.movementType) {
		case 0:
		default:
			return Double.POSITIVE_INFINITY;
		case 1:
			return this.getROLLINGFRICTION();
		case 2:
		case 3:
		case 4:
			return this.getSLIDINGFRICTION();
		}
	}

	public double[] getPosition(double time) {
		if (this.isReallyMoving() && time > 0.0D) {
			double[] temp = this.direction.getComponentsDbl();
			double[] temp2 = this.position.getComponentsDbl();
			double acc = this.getFriction() * (double) (this.movementType == 3 ? 1 : -1);
			this.temp_pos[0] = temp[0] * (this.speed + acc * time / 2.0D) * time + temp2[0];
			this.temp_pos[1] = temp[1] * (this.speed + acc * time / 2.0D) * time + temp2[1];
			return this.temp_pos;
		} else {
			return this.position.getComponentsDbl();
		}
	}

	private double getSquareDistance(Ball b, double time) {
		double[] d = this.getPosition(time);
		double[] e = b.getPosition(time);
		double x = d[0] - e[0];
		double y = d[1] - e[1];
		return x * x + y * y;
	}

	private double approximateCollisionTime(Ball b, double earliest, double latest, double sizes) {
		double nearestEvent = Double.POSITIVE_INFINITY;
		if (this.getSquareDistance(b, earliest) > sizes) {
			double min = earliest;
			double temp = 0.0D;
			double max = latest;
			double tempOld = earliest;

			while (min != max) {
				temp = (min + max) / 2.0D;
				if (temp == tempOld) {
					break;
				}

				tempOld = temp;
				if (this.getSquareDistance(b, temp) <= sizes) {
					max = temp;
				} else {
					min = temp;
				}
			}

			nearestEvent = min;
		}

		return nearestEvent;
	}

	private double[] distanceFunktion(Ball b) {
		double a1 = this.getFriction() * (double) (this.movementType == 3 ? -1 : 1);
		double a2 = b.getFriction() * (double) (b.getMovementType() == 3 ? -1 : 1);
		double speed1 = this.speed;
		double speed2 = b.getSpeed();
		double[] temp = this.direction.getComponentsDbl();
		double x1 = temp[0];
		double y1 = temp[1];
		temp = b.getDirection().getComponentsDbl();
		double x2 = temp[0];
		double y2 = temp[1];
		temp = this.position.sub(b.getPosition()).getComponentsDbl();
		double dx = temp[0];
		double dy = temp[1];
		double[] coeff = new double[] {
				(y1 * y1 + x1 * x1) * a1 * a1 / 4.0D - (x1 * x2 + y1 * y2) * a1 * a2 / 2.0D
						+ (y2 * y2 + x2 * x2) * a2 * a2 / 4.0D,
				((y2 * y1 + x2 * x1) * a1 - (y2 * y2 + x2 * x2) * a2) * speed2
						+ ((y1 * y2 + x1 * x2) * a2 - (x1 * x1 + y1 * y1) * a1) * speed1,
				(y2 * dy + x2 * dx) * a2 - (y1 * dy + x1 * dx) * a1 + (x2 * x2 + y2 * y2) * speed2 * speed2
						- (x1 * x2 + y1 * y2) * 2.0D * speed1 * speed2 + (x1 * x1 + y1 * y1) * speed1 * speed1,
				(x1 * dx + y1 * dy) * speed1 * 2.0D - (y2 * dy + x2 * dx) * speed2 * 2.0D, dx * dx + dy * dy };
		return coeff;
	}

	private double[] diff(double[] coeff) {
		double[] c = null;
		int l = coeff.length;
		if (l > 1) {
			--l;
			c = new double[l];

			for (int i = 0; i < c.length; ++i) {
				c[i] = coeff[i] * (double) (l--);
			}
		}

		return c;
	}

	private double evalFct(double[] coeff, double t) {
		double sum = 0.0D;

		for (int i = 0; i < coeff.length; ++i) {
			sum *= t;
			sum += coeff[i];
		}

		return sum;
	}

	private double[] thrdRt(double[] a) {
		double[] rt = new double[2];
		double l = a[0] * a[0] + a[1] * a[1];
		if (l > 0.0D) {
			l = sqrt(l);
			if (a[1] >= 0.0D) {
				rt[0] = thirdOfAngle(a[0] / l, 0.5D, 1.0D);
				rt[1] = sqrt(1.0D - rt[0] * rt[0]);
			} else {
				rt[0] = thirdOfAngle(a[0] / l, 0.5D, -0.5D);
				rt[1] = sqrt(1.0D - rt[0] * rt[0]);
			}

			l = thrdrt(l);
			rt[0] *= l;
			rt[1] *= l;
		}

		return rt;
	}

	private void divide(double[] a, double[] b) {
		double l = b[0] * b[0] + b[1] * b[1];
		double r = a[0] * b[0] - a[1] * b[1];
		double i = a[1] * b[0] - a[0] * b[1];
		a[0] = r / l;
		a[1] = i / l;
	}

	private double[] solvePolynom(double[] co) {
		double[] sol = new double[3];
		if (co.length == 4 && co[0] != 0.0D) {
			double c = co[1] / co[0];
			double d = co[2] / co[0];
			double e = co[3] / co[0];
			double c2 = c * c;
			double d2 = d * d;
			double e2 = e * e;
			double c3 = c * c * c;
			double d3 = d * d * d;
			double[] root = new double[] {
					12.0D * d3 - 3.0D * d2 * c2 - 54.0D * c * d * e + 81.0D * e2 + 12.0D * e * c3, 0.0D };
			if (root[0] >= 0.0D) {
				root[0] = sqrt(root[0]);
			} else {
				root[1] = sqrt(-root[0]);
				root[0] = 0.0D;
			}

			double[] temp = new double[] { 36.0D * c * d - 108.0D * e - 8.0D * c3 + 12.0D * root[0], 12.0D * root[1] };
			double[] root3 = this.thrdRt(temp);
			double const1 = d / 3.0D - c2 / 9.0D;
			temp[0] = const1;
			temp[1] = 0.0D;
			this.divide(temp, root3);
			double[] s1 = new double[] { root3[0] / 6.0D - c / 3.0D - 6.0D * temp[0], 0.0D };
			double[] s2 = new double[] { -root3[0] / 12.0D + 3.0D * temp[0] - c / 3.0D
					- sqrt(3.0D) / 2.0D * (root3[1] / 6.0D + 6.0D * temp[1]), 0.0D };
			double[] s3 = new double[] { -root3[0] / 12.0D + 3.0D * temp[0] - c / 3.0D
					+ sqrt(3.0D) / 2.0D * (root3[1] / 6.0D + 6.0D * temp[1]), 0.0D };
			sol[0] = s1[0];
			sol[1] = s2[0];
			sol[2] = s3[0];
			double t;
			if (sol[0] > sol[1]) {
				t = sol[1];
				sol[1] = sol[0];
				sol[0] = t;
			}

			if (sol[0] > sol[2]) {
				t = sol[2];
				sol[2] = sol[0];
				sol[0] = t;
			}

			if (sol[1] > sol[2]) {
				t = sol[2];
				sol[2] = sol[1];
				sol[1] = t;
			}
		}

		return sol;
	}

	public boolean canReach(Ball b, double dist, double latest, boolean kicker1, boolean kicker2, double sizes) {
		double v0 = (kicker2 ? b.getSpeed() : 0.0D) + (kicker1 ? this.speed : 0.0D);
		double acc = (kicker1 ? this.getFriction() * (double) (this.movementType == 3 ? -1 : 1) : 0.0D)
				+ (kicker2 ? b.getFriction() * (double) (b.getMovementType() == 3 ? -1 : 1) : 0.0D);
		return v0 * latest - acc / 2.0D * latest * latest + sizes >= dist - 1.0E-7D;
	}

	public double predictCollision(Ball b, double latest) {
		double nearestEvent = Double.POSITIVE_INFINITY;
		if (this.isOnTable() && b.isOnTable()) {
			if (this.isReallyMoving() && b.isReallyMoving()) {
				double sizes = this.size + b.getSize();
				PhysicalVector tempV = b.getPosition().sub(this.position);
				boolean kicker1 = this.getDirection().mul(tempV) > 0.0D;
				boolean kicker2 = b.getDirection().mul(tempV) < 0.0D;
				if ((kicker1 || kicker2) && this.canReach(b, tempV.getLength(), latest, kicker1, kicker2, sizes)) {
					double sizesQ = sizes * sizes;
					double[] coeff = this.distanceFunktion(b);
					if (coeff[4] > sizesQ) {
						double[] coeff2 = this.diff(coeff);
						double[] sol = this.solvePolynom(coeff2);
						double[] start = new double[] { 0.0D, this.getSquareDistance(b, 0.0D) };
						double[] end = new double[2];

						for (int i = 0; i < 3; ++i) {
							if (sol[i] > 0.0D && sol[i] < latest) {
								double tmp = this.getSquareDistance(b, sol[i]);
								if (tmp < sizesQ) {
									end[0] = sol[i];
									end[1] = tmp;
									break;
								}

								start[0] = sol[i];
								start[1] = tmp;
							}
						}

						if (end[0] == 0.0D) {
							end[0] = latest;
							end[1] = this.getSquareDistance(b, latest);
						}

						if (end[1] <= sizesQ) {
							nearestEvent = this.approximateCollisionTime(b, start[0], end[0], sizesQ);
						}
					}
				}
			} else {
				Hole h;
				if (b.isReallyMoving()) {
					h = new Hole(this.position, this.size * 2.0D);
					nearestEvent = b.predictCollision(h);
				} else if (this.isReallyMoving()) {
					h = new Hole(b.getPosition(), b.getSize() * 2.0D);
					nearestEvent = this.predictCollision(h);
				}
			}
		}

		return nearestEvent;
	}

	public double predictCollision(Line l) {
		double nearestEvent = Double.POSITIVE_INFINITY;
		if (this.isReallyMoving()) {
			PhysicalVector al = l.getStartPoint();
			PhysicalVector dl = l.getDirection();
			PhysicalVector nl = dl.getNormal().normToLengthIntern(this.size);
			PhysicalVector ab = this.getPosition();
			PhysicalVector db = this.getDirection();
			PhysicalVector temp1 = al.add(nl);
			PhysicalVector temp2 = al.sub(nl);
			if (temp1.sub(ab).getLengthSquare() < temp2.sub(ab).getLengthSquare()) {
				al = temp1;
			} else {
				al = temp2;
				nl.mulIntern(-1.0D);
			}

			if (db.mul(nl) < 0.0D) {
				double ax = al.getComponentsDbl()[0];
				double ay = al.getComponentsDbl()[1];
				double bx = dl.getComponentsDbl()[0];
				double by = dl.getComponentsDbl()[1];
				double cx = ab.getComponentsDbl()[0];
				double cy = ab.getComponentsDbl()[1];
				double dx = db.getComponentsDbl()[0];
				double dy = db.getComponentsDbl()[1];
				double divisor = bx * dy - dx * by;
				double friction = this.getFriction();
				if (this.movementType == 3) {
					friction = -friction;
				}

				if (divisor != 0.0D) {
					double lPos = -(ax * dy - cx * dy - dx * ay + dx * cy) / divisor;
					if (lPos >= 0.0D && lPos < 1.0D) {
						double dist = -(ax * by - bx * ay + bx * cy - cx * by) / divisor;
						if (dist > 0.0D) {
							double v0 = this.speed;
							double root = v0 * v0 - 2.0D * friction * dist;
							if (root >= 0.0D) {
								nearestEvent = (v0 - sqrt(root)) / friction;
							}
						}
					}
				}
			}
		}

		return nearestEvent;
	}

	public double predictCollision(PhysicalVector p) {
		double nearestEvent = Double.POSITIVE_INFINITY;
		PhysicalVector c = p.sub(this.position);
		if (c.mul(this.direction) > 0.0D) {
			double a1 = c.getComponentsDbl()[0];
			double a2 = c.getComponentsDbl()[1];
			double b1 = this.direction.getComponentsDbl()[0];
			double b2 = this.direction.getComponentsDbl()[1];
			double e = this.size * this.size + 1.0E-7D;
			double friction = this.getFriction();
			if (this.movementType == 3) {
				friction = -friction;
			}

			double root = 2.0D * a2 * b2 * a1 * b1 - b2 * b2 * a1 * a1 + b2 * b2 * e + b1 * b1 * e - b1 * b1 * a2 * a2;
			if (root >= 0.0D) {
				double dist = (a2 * b2 + a1 * b1 - sqrt(root)) / (b2 * b2 + b1 * b1);
				if (dist > 0.0D) {
					double v0 = this.speed;
					double root2 = v0 * v0 - 2.0D * friction * dist;
					if (root2 >= 0.0D) {
						nearestEvent = (v0 - sqrt(root2)) / friction;
					}
				}
			}
		}

		return nearestEvent;
	}

	public double predictCollision(Hole h) {
		double nearestEvent = Double.POSITIVE_INFINITY;
		PhysicalVector c = h.getCenter().sub(this.position);
		if (c.mul(this.direction) > 0.0D) {
			double a1 = c.getComponentsDbl()[0];
			double a2 = c.getComponentsDbl()[1];
			double b1 = this.direction.getComponentsDbl()[0];
			double b2 = this.direction.getComponentsDbl()[1];
			double e = h.getRadius();
			e *= e;
			double friction = this.getFriction();
			if (this.movementType == 3) {
				friction = -friction;
			}

			double root = 2.0D * a2 * b2 * a1 * b1 - b2 * b2 * a1 * a1 + b2 * b2 * e + b1 * b1 * e - b1 * b1 * a2 * a2;
			if (root >= 0.0D) {
				double dist = (a2 * b2 + a1 * b1 - sqrt(root)) / (b2 * b2 + b1 * b1);
				if (dist > 0.0D) {
					double v0 = this.speed;
					double root2 = v0 * v0 - 2.0D * friction * dist;
					if (root2 >= 0.0D) {
						nearestEvent = (v0 - sqrt(root2)) / friction;
					}
				}
			}
		}

		return nearestEvent;
	}

	public double collide(Line l) {
		PhysicalVector a = this.direction;
		PhysicalVector b = l.getDirection().normToLength(1.0D);
		b.normToLengthIntern(a.mul(b));
		PhysicalVector c = a.sub(b);
		double energy = c.getLength();
		c.mulIntern(-0.5274884363D);
		b.addIntern(c);
		this.speed *= b.getLength();
		this.direction = b.normToLengthIntern(1.0D);
		this.rotationspeed *= this.direction.mul(a) * 0.95D;
		this.adjustMovementType();
		return energy;
	}

	public double collide(PhysicalVector p) {
		this.startWith(2);
		PhysicalVector b = this.position.sub(p).getNormal().normToLength(1.0D);
		return this.collide(new Line(0.0D, 0.0D, b));
	}

	public double collide(Ball b, double MATERIALCONST) {
		double ELASTICITY = (MATERIALCONST + 1.0D) / 2.0D;
		PhysicalVector p = this.getPosition();
		PhysicalVector d = this.getDirection();
		PhysicalVector s = d.mul(this.speed);
		PhysicalVector op = b.getPosition();
		PhysicalVector od = b.getDirection();
		PhysicalVector os = od.mul(b.getSpeed());
		PhysicalVector diff = op.sub(p);
		boolean isKicker1 = d.mul(diff) > 0.0D;
		boolean isKicker2 = od.mul(diff) < 0.0D;
		if (diff.getLength() > 3.0D * this.size) {
			this.stop();
			b.stop();
			return 0.0D;
		} else {
			diff.normToLengthIntern(1.0D);
			double v1 = diff.mul(s);
			double v2 = diff.mul(os);
			double energy = v1 - v2;
			if (energy < 0.0D) {
				energy = -energy;
			}

			PhysicalVector sp1 = diff.normToLength(v1);
			PhysicalVector sp2 = diff.normToLength(v2);
			s.subIntern(sp1);
			os.subIntern(sp2);
			double v3 = v2 * ELASTICITY + v1 * (1.0D - ELASTICITY);
			double v4 = v1 * ELASTICITY + v2 * (1.0D - ELASTICITY);
			if (isKicker1 && !isKicker2) {
				v3 *= 0.98D;
				if (v3 < 0.0D) {
					v3 += 0.01D;
				} else {
					v3 -= 0.01D;
				}
			} else if (isKicker2 && !isKicker1) {
				v4 *= 0.98D;
				if (v4 < 0.0D) {
					v4 += 0.01D;
				} else {
					v4 -= 0.01D;
				}
			}

			s.addIntern(diff.normToLength(v3));
			os.addIntern(diff.normToLength(v4));
			v1 = s.getLength();
			v2 = os.getLength();
			s.normToLengthIntern(1.0D);
			os.normToLengthIntern(1.0D);
			double r = s.mul(d) * this.rotationspeed * 0.95D;
			double or = os.mul(od) * b.getRotationspeed() * 0.95D;
			this.setSpeed(v1, r, s);
			b.setSpeed(v2, or, os);
			this.adjustMovementType();
			b.adjustMovementType();
			return energy;
		}
	}

	public boolean isInside(Ball b) {
		double size = b.size + this.size;
		double diff = this.position.sub(b.getPosition()).getLengthSquare() - size * size;
		return diff < 0.0D;
	}

	public boolean isInContact(double x, double y, double size) {
		double[] d = this.position.getComponentsDbl();
		double a = d[0] - x;
		double b = d[1] - y;
		double c = size + this.size;
		double diff = a * a + b * b - c * c;
		return diff <= 5.0E-11D;
	}

	public void paint(Graphics g, double x, double y) {
		this.paint(g, x, y, false);
	}

	public void paint(Graphics g, double x, double y, boolean forcePaint) {
		if (this.onTable || forcePaint) {
			int xp;
			int yp;
			if (this.ballImage != null) {
				xp = (int) (x - this.size + 1.0D);
				yp = (int) (y - this.size + 1.0D);
				g.drawImage(this.ballImage, xp, yp, this.imgObserver);
				if (forcePaint && this.ballMaskImage != null) {
					g.drawImage(this.ballMaskImage, xp, yp, this.imgObserver);
				}

				this.paintData[0] = xp;
				this.paintData[1] = yp;
				this.paintData[2] = this.ballImage.getWidth((ImageObserver) null);
				if (this.marked != 0) {
					Image img = null;
					int div = 2;
					if (this.marked == 1) {
						img = markImg_Light;
						g.setColor(Color.red);
						div = 1;
					} else if (this.marked == 2) {
						img = markImg_Strong;
						g.setColor(Color.white);
					}

					if (img == null) {
						g.drawOval((int) (x - this.size + 0.5D), (int) (y - this.size + 0.5D), this.scrSize * 2 + 2,
								this.scrSize * 2 + 2);
					} else {
						int w = img.getWidth((ImageObserver) null);
						xp = (int) ((double) xp + this.size - (double) (w / 2));
						yp = (int) ((double) yp + this.size - (double) (img.getHeight((ImageObserver) null) / div));
						if (w > this.paintData[2]) {
							this.paintData[0] = xp;
							this.paintData[1] = yp;
							this.paintData[2] = w;
						}

						g.drawImage(img, xp, yp, (ImageObserver) null);
					}
				}
			} else {
				xp = (int) (x - this.size + 0.5D);
				yp = (int) (y - this.size + 0.5D);
				this.paintData[0] = xp;
				this.paintData[1] = yp;
				this.paintData[2] = this.scrSize * 2 + 1;
				g.setColor(this.col);
				g.fillOval(xp, yp, this.scrSize * 2, this.scrSize * 2);
				g.setColor(this.borderColor);
				g.drawOval(xp, yp, this.scrSize * 2, this.scrSize * 2);
			}
		}

	}

	public void paint(Graphics g, double time) {
		this.paint(g, time, false);
	}

	public void paint(Graphics g, double time, boolean forcePaint) {
		if (!this.onTable && !forcePaint) {
			this.paintData[2] = -1;
		} else {
			double[] p;
			if (this.isReallyMoving() && time > 0.0D) {
				p = this.getPosition(time);
			} else {
				p = this.position.getComponentsDbl();
			}

			this.paint(g, p[0], p[1], forcePaint);
		}

	}

	public double getDistance(double x, double y) {
		double[] d = new double[] { x, y };
		PhysicalVector p = new PhysicalVector(d);
		return p.subIntern(this.position).getLength();
	}

	public String toDataString() {
		String mt = "-";
		switch (this.movementType) {
		case 0:
			mt = "STOP";
			break;
		case 1:
			mt = "ROLL";
			break;
		case 2:
			mt = "SLD";
			break;
		case 3:
			mt = "ACC";
			break;
		case 4:
			mt = "ANTIACC";
		}

		return "(" + mt + ") speed=" + this.speed + " \trot=" + this.rotationspeed + " \tdirection: "
				+ this.direction.toString() + "\tPos=" + this.position.toString();
	}

	public String toString() {
		return this.ballImage != null ? this.ballImage.toString() : "" + this.col;
	}

	public double predictNextMovementChange() {
		switch (this.movementType) {
		case 0:
		default:
			this.nextMovementType = 0;
			return Double.POSITIVE_INFINITY;
		case 1:
			this.nextMovementType = 0;
			return this.speed / this.getROLLINGFRICTION();
		case 2:
			this.nextMovementType = 1;
			return (this.speed - this.rotationspeed) / (this.getSLIDINGFRICTION() * (ROTATIONCONST + 1.0D));
		case 3:
			this.nextMovementType = 1;
			return (this.rotationspeed - this.speed) / (this.getSLIDINGFRICTION() * (ROTATIONCONSTACC + 1.0D));
		case 4:
			double t1 = -this.rotationspeed / (this.getSLIDINGFRICTION() * ROTATIONCONSTACC);
			double t2 = this.speed / this.getSLIDINGFRICTION();
			if (t1 < t2) {
				this.nextMovementType = 2;
				return t1;
			} else {
				this.nextMovementType = 3;
				return t2;
			}
		}
	}

	public static double sqrt(double a) {
		if (a >= 0.0D && !Double.isNaN(a)) {
			double n = a / 2.0D;
			double x = 0.0D;

			for (double x2 = a; x != x2; x2 = x2 / 2.0D + n / x2) {
				x = x2;
			}

			return x;
		} else {
			return Double.NaN;
		}
	}

	public static double thrdrt(double a) {
		if (a >= 0.0D && !Double.isNaN(a)) {
			double c = 0.6666666666666666D;
			double n = a / 3.0D;
			double x2 = a * c + n / (a * a);

			for (double x = x2 * 2.0D; x > x2; x2 = x2 * c + n / (x2 * x2)) {
				x = x2;
			}

			return x2;
		} else {
			return Double.NaN;
		}
	}

	public static double thirdOfAngle(double a, double start, double end) {
		if (Double.isNaN(a)) {
			return Double.NaN;
		} else {
			double x2 = start;

			while (start != end) {
				double x = (start + end) / 2.0D;
				if (x == x2) {
					return x;
				}

				x2 = x;
				double y = (4.0D * x * x - 3.0D) * x - a;
				if (y > 0.0D) {
					end = x;
				} else {
					if (y >= 0.0D) {
						return x;
					}

					start = x;
				}
			}

			return start;
		}
	}

	public void setSLIDINGFRICTION(double sLIDINGFRICTION) {
		this.SLIDINGFRICTION = sLIDINGFRICTION;
	}

	public double getSLIDINGFRICTION() {
		return this.SLIDINGFRICTION;
	}

	public void setROLLINGFRICTION(double rOLLINGFRICTION) {
		this.ROLLINGFRICTION = rOLLINGFRICTION;
	}

	public double getROLLINGFRICTION() {
		return this.ROLLINGFRICTION;
	}

	static {
		ROTATIONCONST = sqrt(1.25D) * 2.0D * PI;
		ROTATIONCONSTACC = sqrt(5.0D) * 2.0D * PI;
		markImg_Light = null;
		markImg_Strong = null;
	}
}