package billard;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class BillardTableDataCalculator implements IBillardConstants {
	private Ball[] balls;
	private Line[] lines;
	private Hole[] holes;
	private Ball[] savedBalls;
	private double ballSizeDbl = 9.5D;
	private double maxQueueValue = 100.0D;
	private final double bandenLaenge = 660.0D;
	private double[] powerInterpolator1 = new double[] {
		0.0D,
		0.07D,
		0.17D,
		0.3D,
		0.45D,
		0.65D,
		0.95D,
		1.3D,
		1.7D,
		2.2D,
		2.8D
	};
	private double[] powerInterpolator2 = new double[] {
		0.0D,
		0.0D,
		0.0D,
		0.0D,
		0.0D,
		0.0D,
		0.0D,
		0.0D,
		0.0D,
		0.0D,
		0.0D,
		0.0D,
		0.0D,
		0.0D,
		0.0D,
		0.03D,
		0.06125D,
		0.125D,
		0.25D,
		0.5D,
		1.0D
	};
	private double constMATERIAL = 0.7D;
	private PhysicalVector queuePoint = null;
	private PhysicalVector queueDirection = null;
	private double queueDistanceFromBall = 0.0D;
	private int maxBanden = 50;
	private int maxBalls = 5;
	private int eventType;
	private int object1;
	private int object2;
	private int local_object1;
	private int local_object2;
	private IBallHolderInterface ballHolder;
	private IRepaintable cnt;
	private double ballRollingFriction;
	private double ballSlidingFriction;

	public static double parseDouble(String s) {
		return Double.valueOf(s);
	}

	public double getBallSizeDbl() {
		return this.ballSizeDbl;
	}

	public void setBallSizeDbl(double size) {
		this.ballSizeDbl = size;
	}

	public Ball[] getBalls() {
		return this.balls;
	}

	public void setBalls(Ball[] balls) {
		this.balls = balls;
		this.updateFrinction();
	}

	public Ball[] getSavedBalls() {
		return this.savedBalls;
	}

	public Line[] getLines() {
		return this.lines;
	}

	public void setLines(Line[] lines) {
		this.lines = lines;
	}

	public Hole[] getHoles() {
		return this.holes;
	}

	public void setHoles(Hole[] holes) {
		this.holes = holes;
	}

	public void calculate(int nr, double power, PhysicalVector direction, Vector<Object> precalculatedEvents, boolean addToBallHolder) {
		this.setQueuePoint(this.getBalls()[nr].getPosition().getClone());
		this.setQueueDirection(direction.getClone());
		direction.normToLengthIntern(power);
		this.getBalls()[nr].setSpeed(power, 0.0D, direction.getClone());
		this.getBalls()[nr].startWith(2);
		this.saveSituation();
		precalculatedEvents.removeAllElements();
		this.logOutput();

		while (this.stillMoving()) {
			double[] e = new double[] {
				this.predictNextEvent(),
				(double) this.getEventType() + 0.1D,
				(double) this.getObject1() + 0.1D,
				(double) this.getObject2() + 0.1D
			};
			
			precalculatedEvents.addElement(e);
			this.movePositionsUntil(e[0]);
			this.calculateEventEffectsPrecalculation(precalculatedEvents);
			this.logOutput();
		}

		this.logOutput();
	}

	public boolean calculatePreview(int nr, double power, double powerAfterBallHit, PhysicalVector direction, Vector<double[]> events, boolean addToBallHolder) {
		events.removeAllElements();
		direction.normToLengthIntern(power);
		this.getBalls()[nr].setSpeed(power, 0.0D, direction.getClone());
		this.getBalls()[nr].startWith(2);
		events.addElement(this.getBalls()[nr].getPosition().getClone().getComponentsDbl());
		int cntBande = 0;
		int cntBalls = 0;
		boolean arrow_needed = false;
		boolean finished = false;
		int runningBall = nr;

		while(this.stillMoving() && !finished && cntBande <= this.getMaxBanden() && cntBalls <= this.getMaxBalls()) {
			double time = this.predictNextEvent();
			this.movePositionsUntil(time);
			
			if(this.getEventType() != 5 || this.getObject2() == 0 || this.getObject2() == 3) {
				events.addElement(this.getBalls()[runningBall].getPosition().mul(1.0D).getComponentsDbl());
			}

			this.calculateEventEffects((Vector<Object>) null, addToBallHolder);
			
			if (this.getEventType() != 5 || this.getObject2() == 0) {
				if (this.getEventType() == 5) {
					arrow_needed = true;
				}

				finished = true;
			}
		}

		return arrow_needed;
	}

	public double predictNextEvent() {
		double nearestEvent = Double.POSITIVE_INFINITY;
		this.setEventType(0);
		double temp = this.predictNextMovementChangeOfBall();
		
		if(temp < nearestEvent) {
			this.setEventType(5);
			this.setObject1(this.local_object1);
			this.setObject2(this.local_object2);
			nearestEvent = temp;
		}

		temp = this.predictNextBallToPointCollision();
		
		if (temp < nearestEvent) {
			this.setEventType(3);
			this.setObject1(this.local_object1);
			this.setObject2(this.local_object2);
			nearestEvent = temp;
		}

		temp = this.predictNextBallToLineCollision();
		
		if (temp < nearestEvent) {
			this.setEventType(2);
			this.setObject1(this.local_object1);
			this.setObject2(this.local_object2);
			nearestEvent = temp;
		}

		temp = this.predictNextBallInHole();
		
		if (temp < nearestEvent) {
			this.setEventType(4);
			this.setObject1(this.local_object1);
			this.setObject2(this.local_object2);
			nearestEvent = temp;
		}

		temp = this.predictNextBallToBallCollision(nearestEvent);
		
		if (temp < nearestEvent) {
			this.setEventType(1);
			this.setObject1(this.local_object1);
			this.setObject2(this.local_object2);
			nearestEvent = temp;
		}

		if (nearestEvent < 1.0E-6D) {
			return nearestEvent > 1.0E-8D ? nearestEvent * 0.9D : 0.0D;
		} else {
			return nearestEvent - 1.0E-7D;
		}
	}

	private double predictNextMovementChangeOfBall() {
		double nearestEvent = Double.POSITIVE_INFINITY;

		for (int i = 0; i < this.getBalls().length; ++i) {
			if (this.getBalls()[i] != null && this.getBalls()[i].isMovingOnTable()) {
				double temp = this.getBalls()[i].predictNextMovementChange();
				if (temp < nearestEvent) {
					this.local_object1 = i;
					this.local_object2 = this.getBalls()[i].nextMovementType;
					nearestEvent = temp;
				}
			}
		}

		return nearestEvent;
	}

	private double predictNextBallToBallCollision(double latest) {
		double nearestEvent = Double.POSITIVE_INFINITY;

		for (int i = this.getBalls().length - 1; i >= 0; --i) {
			for (int j = this.getBalls().length - 1; j > i; --j) {
				if (this.getBalls()[i] != null && this.getBalls()[j] != null) {
					double temp = this.getBalls()[i].predictCollision(this.getBalls()[j], latest);
					if (temp < nearestEvent) {
						this.local_object1 = i;
						this.local_object2 = j;
						nearestEvent = temp;
					}
				}
			}
		}

		return nearestEvent;
	}

	private double predictNextBallToLineCollision() {
		double nearestEvent = Double.POSITIVE_INFINITY;

		for (int i = this.getBalls().length - 1; i >= 0; --i) {
			for (int j = this.getLines().length - 1; j >= 0; --j) {
				if (this.getBalls()[i] != null) {
					double temp = this.getBalls()[i].predictCollision(this.getLines()[j]);
					if (temp < nearestEvent) {
						this.local_object1 = i;
						this.local_object2 = j;
						nearestEvent = temp;
					}
				}
			}
		}

		return nearestEvent;
	}

	private double predictNextBallToPointCollision() {
		double nearestEvent = Double.POSITIVE_INFINITY;

		for (int i = this.getBalls().length - 1; i >= 0; --i) {
			for (int j = this.getLines().length - 1; j >= 0; --j) {
				if (this.getBalls()[i] != null) {
					double temp = this.getBalls()[i].predictCollision(this.getLines()[j].getStartPoint());
					if (temp < nearestEvent) {
						this.local_object1 = i;
						this.local_object2 = j * 2;
						nearestEvent = temp;
					}

					temp = this.getBalls()[i].predictCollision(this.getLines()[j].getEndPoint());
					if (temp < nearestEvent) {
						this.local_object1 = i;
						this.local_object2 = j * 2 + 1;
						nearestEvent = temp;
					}
				}
			}
		}

		return nearestEvent;
	}

	private double predictNextBallInHole() {
		double nearestEvent = Double.POSITIVE_INFINITY;

		for (int i = this.getBalls().length - 1; i >= 0; --i) {
			for (int j = this.getHoles().length - 1; j >= 0; --j) {
				if (this.getBalls()[i] != null) {
					double temp = this.getBalls()[i].predictCollision(this.getHoles()[j]);
					if (temp < nearestEvent) {
						this.local_object1 = i;
						this.local_object2 = j;
						nearestEvent = temp;
					}
				}
			}
		}

		return nearestEvent;
	}

	public void movePositionsUntil(double t) {
		for (int i = 0; i < this.getBalls().length; ++i) {
			if (this.getBalls()[i] != null) {
				this.getBalls()[i].move(t);
			}
		}

	}

	private int calculateEventEffects(Vector<Object> o, boolean addToBallHolder) {
		int loudness = 0;
		
		if (o instanceof Vector) {
			Vector<Object> v = (Vector<Object>) o;
			this.calculateEventEffectsPrecalculation(v);
		} else {
			switch (this.getEventType()) {
			case 1:
				this.getBalls()[this.getObject1()].collide(this.getBalls()[this.getObject2()], this.getConstMATERIAL());
				break;
			case 2:
				this.getBalls()[this.getObject1()].collide(this.getLines()[this.getObject2()]);
				break;
			case 3:
				if ((this.getObject2() & 1) == 0) {
					this.getBalls()[this.getObject1()].collide(this.getLines()[this.getObject2() / 2].getStartPoint());
				} else {
					this.getBalls()[this.getObject1()].collide(this.getLines()[this.getObject2() / 2].getEndPoint());
				}
				break;
			case 4:
				this.getBalls()[this.getObject1()].drop();
				if (addToBallHolder) {
					this.ballHolder.addBall(this.getObject1(), this.getBalls()[this.getObject1()]);
				}

				this.cnt.repaint();
				break;
			case 5:
				this.getBalls()[this.getObject1()].startWith(this.getObject2());
			}
		}

		return loudness;
	}

	public void saveSituation() {
		if (this.savedBalls == null || this.savedBalls.length != this.balls.length) {
			this.savedBalls = new Ball[this.balls.length];
		}

		Ball[] temp = this.savedBalls;
		this.savedBalls = this.balls;
		this.balls = temp;

		for (int i = 0; i < this.balls.length; ++i) {
			this.balls[i] = this.savedBalls[i] == null ? null : this.savedBalls[i].getClone();
		}

	}

	public void restoreSituation() {
		if (this.savedBalls != null && this.savedBalls.length == this.balls.length) {
			for (int i = 0; i < this.balls.length; ++i) {
				this.balls[i] = this.savedBalls[i];
			}
		}

	}

	public int calculateEventEffectsPrecalculation(Vector<Object> v) {
		int loudness = 0;
		double energy = 0.0D;
		switch (this.getEventType()) {
		case 1:
			energy = this.getBalls()[this.getObject1()].collide(this.getBalls()[this.getObject2()],
					this.getConstMATERIAL());
			v.addElement(this.getBalls()[this.getObject1()].getClone());
			v.addElement(this.getBalls()[this.getObject2()].getClone());
			if (energy >= 400.0D) {
				loudness = 2;
			} else if (energy >= 20.0D) {
				loudness = 1;
			}
			break;
		case 2:
			energy = this.getBalls()[this.getObject1()].collide(this.getLines()[this.getObject2()]);
			if (energy >= 50.0D) {
				loudness = 1;
			}

			v.addElement(this.getBalls()[this.getObject1()].getClone());
			break;
		case 3:
			if ((this.getObject2() & 1) == 0) {
				energy = this.getBalls()[this.getObject1()]
						.collide(this.getLines()[this.getObject2() / 2].getStartPoint());
			} else {
				energy = this.getBalls()[this.getObject1()]
						.collide(this.getLines()[this.getObject2() / 2].getEndPoint());
			}

			if (energy >= 50.0D) {
				loudness = 1;
			}

			v.addElement(this.getBalls()[this.getObject1()].getClone());
			break;
		case 4:
			this.getBalls()[this.getObject1()].drop();
			break;
		case 5:
			this.getBalls()[this.getObject1()].startWith(this.getObject2());
		}

		return loudness;
	}

	public double getPreviewPower(IQueuePanelInterface activeQueue) {
		double temp = this.interpolate(this.getPowerInterpolator1(), activeQueue.getData(2) / this.getMaxQueueValue());
		temp += this.getBallSizeDbl() / this.getBandenLaenge();
		return Math.sqrt(2.0D * temp * this.getBandenLaenge() * this.getBallRollingFriction());
	}

	public double getPreviewPower2(IQueuePanelInterface activeQueue) {
		double temp = this.interpolate(this.getPowerInterpolator2(), activeQueue.getData(2) / this.getMaxQueueValue());
		temp += this.getBallSizeDbl();
		return Math.sqrt(2.0D * temp * this.getBandenLaenge() * this.getBallRollingFriction());
	}

	public PhysicalVector calculateAndSetQueuePosition(int playBall, double x, double y) {
		int[] p = this.getBalls()[playBall].getPosition().getComponentsInt();
		PhysicalVector v = PhysicalVector.parsePhysicalVector("" + (x - (double) p[0]) + "," + (y - (double) p[1]));
		if (v.isZero()) {
			v.addIntern(1.0D);
		}

		this.setQueuePoint(this.getBalls()[playBall].getPosition().getClone());
		this.setQueueDirection(v.getClone());
		return v;
	}

	public double getBandenLaenge() {
		return this.bandenLaenge;
	}

	public void setPowerInterpolator1(double[] powerInterpolator1) {
		this.powerInterpolator1 = powerInterpolator1;
	}

	public double[] getPowerInterpolator1() {
		return this.powerInterpolator1;
	}

	public void setPowerInterpolator2(double[] powerInterpolator2) {
		this.powerInterpolator2 = powerInterpolator2;
	}

	public double[] getPowerInterpolator2() {
		return this.powerInterpolator2;
	}

	public void setMaxQueueValue(double maxQueueValue) {
		this.maxQueueValue = maxQueueValue;
	}

	public double getMaxQueueValue() {
		return this.maxQueueValue;
	}

	public boolean stillMoving() {
		for (int i = 0; i < this.getBalls().length; ++i) {
			if (this.getBalls()[i] != null && this.getBalls()[i].isMovingOnTable()) {
				return true;
			}
		}

		return false;
	}

	private double interpolate(double[] werte, double value) {
		if (werte == null) {
			return 0.0D;
		} else if (value <= 0.0D) {
			return werte[0];
		} else if (value >= 1.0D) {
			return werte[werte.length - 1];
		} else {
			double step = 1.0D / (double) (werte.length - 1);
			int lower = (int) (value / step);
			value -= step * (double) lower;
			return (werte[lower] * (step - value) + werte[lower + 1] * value) / step;
		}
	}

	public void setEventType(int eventType) {
		this.eventType = eventType;
	}

	public int getEventType() {
		return this.eventType;
	}

	public void setObject1(int object1) {
		this.object1 = object1;
	}

	public int getObject1() {
		return this.object1;
	}

	public void setObject2(int object2) {
		this.object2 = object2;
	}

	public int getObject2() {
		return this.object2;
	}

	public void setConstMATERIAL(double constMATERIAL) {
		this.constMATERIAL = constMATERIAL;
	}

	public double getConstMATERIAL() {
		return this.constMATERIAL;
	}

	public void setQueuePoint(PhysicalVector queuePoint) {
		this.queuePoint = queuePoint;
	}

	public PhysicalVector getQueuePoint() {
		return this.queuePoint;
	}

	public void setQueueDirection(PhysicalVector queueDirection) {
		this.queueDirection = queueDirection;
	}

	public PhysicalVector getQueueDirection() {
		return this.queueDirection;
	}

	public void setQueueDistanceFromBall(double queueDistanceFromBall) {
		this.queueDistanceFromBall = queueDistanceFromBall;
	}

	public double getQueueDistanceFromBall() {
		return this.queueDistanceFromBall;
	}

	public void setMaxBanden(int maxBanden) {
		this.maxBanden = maxBanden;
	}

	public int getMaxBanden() {
		return this.maxBanden;
	}

	public void setMaxBalls(int maxBalls) {
		this.maxBalls = maxBalls;
	}

	public int getMaxBalls() {
		return this.maxBalls;
	}

	public void setBallHolder(IBallHolderInterface ballHolder) {
		this.ballHolder = ballHolder;
	}

	public void setContent(IRepaintable cnt) {
		this.cnt = cnt;
	}

	public StringTokenizer generateInputStringTokenizer(Vector<?> precalculatedEvents, String sep) {
		String sendBack = this.executeShotSendConstellation("", sep, precalculatedEvents);
		return new StringTokenizer(sendBack, sep);
	}

	public String executeShotSendConstellation(String sendBack, String sep, Vector<?> precalculatedEvents) {
		Enumeration<?> myEnum = precalculatedEvents.elements();
		int cnt = 0;
		StringBuffer sbEvent = new StringBuffer(500);

		while (myEnum.hasMoreElements() && cnt < 1000) {
			try {
				double[] e = (double[]) ((double[]) myEnum.nextElement());
				if ((int) e[1] != 5) {
					sbEvent.append(sep);
					sbEvent.append((int) e[1]);
					sbEvent.append(sep);
					sbEvent.append((int) e[2]);
					sbEvent.append(sep);
					sbEvent.append((int) e[3]);
					++cnt;
				}
			} catch (Exception var9) {
				;
			}
		}

		sendBack = sendBack + sep + cnt + (sbEvent != null ? sbEvent.toString() : "");

		for (int i = 0; i < this.getBalls().length; ++i) {
			if (this.getBalls()[i] != null && this.getBalls()[i].isOnTable()) {
				double[] p = this.getBalls()[i].getPosition().getComponentsDbl();
				sendBack = sendBack + sep + p[0] + sep + p[1];
			} else {
				sendBack = sendBack + sep + "-1" + sep + "-1";
			}
		}

		return sendBack;
	}

	public void preCalculationExecuteShot(Vector<Object> precalculatedEvents) {
		this.saveSituation();
		precalculatedEvents.removeAllElements();
		
		for(;this.stillMoving();) {
			double[] e = new double[] {
				this.predictNextEvent(),
				(double) this.getEventType() + 0.1D,
				(double) this.getObject1() + 0.1D,
				(double) this.getObject2() + 0.1D
			};
			
			precalculatedEvents.addElement(e);
			this.movePositionsUntil(e[0]);
			this.calculateEventEffectsPrecalculation(precalculatedEvents);
		}

		this.restoreSituation();
	}

	public double getBallRollingFriction() {
		return this.ballRollingFriction;
	}

	public void logOutput() {
	}

	public void setBallRollingFriction(double ballRollingFriction) {
		this.ballRollingFriction = ballRollingFriction;
		this.updateFrinction();
	}

	private void updateFrinction() {
		for (int i = 0; i < this.balls.length; ++i) {
			if (this.balls[i] != null) {
				this.balls[i].setROLLINGFRICTION(this.getBallRollingFriction());
				this.balls[i].setSLIDINGFRICTION(this.getBallSlidingFriction());
			}
		}
	}

	public void setBallSlidingFriction(double ballSlidingFriction) {
		this.ballSlidingFriction = ballSlidingFriction;
		this.updateFrinction();
	}

	public double getBallSlidingFriction() {
		return this.ballSlidingFriction;
	}
}